/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ref;

import com.bawnorton.configurable.ConfigurableMain;
import com.bawnorton.configurable.load.IllegalConfigException;
import com.bawnorton.configurable.ref.constraint.ConstraintSet;
import com.bawnorton.configurable.ref.constraint.ReferenceConstraint;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

public class Reference<T> {
    private final String name;
    private final String comment;
    private final Class<?> refHolder;
    private final VarHandle varHandle;
    private final ConstraintSet constraints;
    private final T defaultValue;
    private Object memento;

    public Reference(String name, Class<?> refHolder, Class<T> refType, ConstraintSet.Builder builder) {
        this(name, refHolder, refType, "", builder);
    }

    public Reference(String name, Class<?> refHolder, Class<T> refType, String comment, ConstraintSet.Builder builder) {
        this.name = name;
        this.comment = comment;
        this.refHolder = refHolder;
        try {
            this.constraints = builder.build(refHolder, refType);
        }
        catch (RuntimeException e) {
            throw new IllegalConfigException("Could not build constraints for \"%s\" in \"%s\"".formatted(name, refHolder.getSimpleName()), e);
        }
        try {
            MethodHandles.Lookup publicLookup = MethodHandles.lookup();
            MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(refHolder, publicLookup);
            this.varHandle = privateLookup.findStaticVarHandle(refHolder, name, refType);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        this.defaultValue = this.get();
        if (Objects.equals(this.constraints.apply(this.defaultValue), ReferenceConstraint.DEFAULT)) {
            throw new IllegalConfigException("Default value \"%s\" for \"%s\" in \"%s\" does not conform to it's constraints".formatted(this.defaultValue, name, refHolder.getSimpleName()));
        }
    }

    public T get() {
        return (T)this.varHandle.get();
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public void set(Object value) throws ClassCastException {
        Object pre = value;
        if ((value = this.constraints.apply(value)) != ReferenceConstraint.DEFAULT) {
            this.varHandle.set(value);
        } else {
            ConfigurableMain.LOGGER.warn("Custom value \"%s\" for \"%s\" in \"%s\" violated it's constraints. Set to default".formatted(pre, this.name, this.refHolder.getSimpleName()));
        }
    }

    public String getComment() {
        return this.comment;
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public void setMemento(Object value) {
        this.memento = value;
    }

    public void applyMemento() {
        if (this.memento != null) {
            this.set(this.memento);
        }
    }

    public void update(boolean fromServer, boolean serverEnforces) {
        if (fromServer == serverEnforces) {
            this.applyMemento();
        } else {
            this.memento = null;
        }
    }

    public Class<?> getType() {
        return this.varHandle.varType();
    }

    public String getName() {
        return this.name;
    }
}

