/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.networking;

import com.bawnorton.configurable.ConfigurableMain;
import com.bawnorton.configurable.generated.GeneratedConfig;
import com.bawnorton.configurable.load.ConfigurableWrapper;
import com.bawnorton.configurable.networking.packet.ConfigSyncPacket;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public final class Networking {
    public static void init() {
        PayloadTypeRegistry playC2S = PayloadTypeRegistry.playC2S();
        PayloadTypeRegistry playS2C = PayloadTypeRegistry.playS2C();
        playC2S.register(ConfigSyncPacket.ID, ConfigSyncPacket.PACKET_CODEC);
        playS2C.register(ConfigSyncPacket.ID, ConfigSyncPacket.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ConfigSyncPacket.ID, Networking::handleConfigSync);
    }

    public static void sendServerConfig(class_3222 player, String name, String sourceSet, String configString) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncPacket(name, sourceSet, configString));
    }

    private static void handleConfigSync(ConfigSyncPacket packet, ServerPlayNetworking.Context context) {
        ConfigurableWrapper wrapper = ConfigurableMain.getWrappers(packet.name()).get(packet.sourceSet());
        wrapper.deserializeConfig(packet.config());
        GeneratedConfig config = wrapper.getConfig();
        config.update(false);
        wrapper.saveConfig();
        ServerPlayNetworking.send((class_3222)context.player(), (class_8710)new ConfigSyncPacket(packet.name(), packet.sourceSet(), wrapper.serializeConfig(config)));
    }
}

