/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.load;

import com.bawnorton.configurable.ConfigurableMain;
import com.bawnorton.configurable.api.ConfigurableApi;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public final class ConfigurableApiImplLoader {
    private static final Map<String, ConfigurableApi> impls = new HashMap<String, ConfigurableApi>();

    public static void load() {
        FabricLoader.getInstance().getEntrypointContainers("configurable", ConfigurableApi.class).forEach(container -> {
            String id = container.getProvider().getMetadata().getId();
            try {
                impls.put(id, (ConfigurableApi)container.getEntrypoint());
            }
            catch (Throwable e) {
                ConfigurableMain.LOGGER.error("Mod {} provides a broken ConfigurableApi implemenation", (Object)id, (Object)e);
            }
        });
    }

    public static ConfigurableApi getImpl(String name) {
        return impls.getOrDefault(name, ConfigurableApi.DEFAULT);
    }
}

