/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.libs.parsers.json.gson;

import com.bawnorton.configurable.libs.gson.JsonParseException;
import com.bawnorton.configurable.libs.gson.JsonSyntaxException;
import com.bawnorton.configurable.libs.parsers.json.FormatViolationException;
import com.bawnorton.configurable.libs.parsers.json.JsonReader;
import com.bawnorton.configurable.libs.parsers.json.JsonToken;
import com.bawnorton.configurable.libs.parsers.json.MalformedSyntaxException;
import com.bawnorton.configurable.libs.parsers.json.ParseException;
import java.io.IOException;
import java.io.Reader;

public class GsonReader
extends com.bawnorton.configurable.libs.gson.stream.JsonReader {
    private final JsonReader delegate;

    public GsonReader(JsonReader reader) {
        super(Reader.nullReader());
        this.delegate = reader;
    }

    public JsonReader getDelegate() {
        return this.delegate;
    }

    private <T> T rethrowGsonExceptions(DelegateFunction<T> func) throws IOException {
        try {
            return func.call();
        }
        catch (FormatViolationException | MalformedSyntaxException e) {
            throw new JsonSyntaxException(e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new JsonParseException(e.getMessage(), e);
        }
    }

    private void rethrowGsonExceptionsVoid(DelegateAction action) throws IOException {
        this.rethrowGsonExceptions(action);
    }

    @Override
    public void beginArray() throws IOException {
        this.rethrowGsonExceptionsVoid(this.delegate::beginArray);
    }

    @Override
    public void endArray() throws IOException {
        this.rethrowGsonExceptionsVoid(this.delegate::endArray);
    }

    @Override
    public void beginObject() throws IOException {
        this.rethrowGsonExceptionsVoid(this.delegate::beginObject);
    }

    @Override
    public void endObject() throws IOException {
        this.rethrowGsonExceptionsVoid(this.delegate::endObject);
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.rethrowGsonExceptions(this.delegate::hasNext);
    }

    @Override
    public com.bawnorton.configurable.libs.gson.stream.JsonToken peek() throws IOException {
        JsonToken quiltToken = this.rethrowGsonExceptions(this.delegate::peek);
        switch (quiltToken) {
            case BEGIN_ARRAY: {
                return com.bawnorton.configurable.libs.gson.stream.JsonToken.BEGIN_ARRAY;
            }
            case END_ARRAY: {
                return com.bawnorton.configurable.libs.gson.stream.JsonToken.END_ARRAY;
            }
            case BEGIN_OBJECT: {
                return com.bawnorton.configurable.libs.gson.stream.JsonToken.BEGIN_OBJECT;
            }
            case END_OBJECT: {
                return com.bawnorton.configurable.libs.gson.stream.JsonToken.END_OBJECT;
            }
            case NAME: {
                return com.bawnorton.configurable.libs.gson.stream.JsonToken.NAME;
            }
            case STRING: {
                return com.bawnorton.configurable.libs.gson.stream.JsonToken.STRING;
            }
            case NUMBER: {
                return com.bawnorton.configurable.libs.gson.stream.JsonToken.NUMBER;
            }
            case BOOLEAN: {
                return com.bawnorton.configurable.libs.gson.stream.JsonToken.BOOLEAN;
            }
            case NULL: {
                return com.bawnorton.configurable.libs.gson.stream.JsonToken.NULL;
            }
            case END_DOCUMENT: {
                return com.bawnorton.configurable.libs.gson.stream.JsonToken.END_DOCUMENT;
            }
        }
        throw new IllegalStateException("Delegate returned unrecognized token " + quiltToken);
    }

    @Override
    public String nextName() throws IOException {
        return this.rethrowGsonExceptions(this.delegate::nextName);
    }

    @Override
    public String nextString() throws IOException {
        return this.rethrowGsonExceptions(this.delegate::nextString);
    }

    @Override
    public boolean nextBoolean() throws IOException {
        return this.rethrowGsonExceptions(this.delegate::nextBoolean);
    }

    @Override
    public void nextNull() throws IOException {
        this.rethrowGsonExceptionsVoid(this.delegate::nextNull);
    }

    @Override
    public double nextDouble() throws IOException {
        return this.rethrowGsonExceptions(this.delegate::nextDouble);
    }

    @Override
    public long nextLong() throws IOException {
        return this.rethrowGsonExceptions(this.delegate::nextLong);
    }

    @Override
    public int nextInt() throws IOException {
        return this.rethrowGsonExceptions(this.delegate::nextInt);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
        super.close();
    }

    @Override
    public void skipValue() throws IOException {
        this.rethrowGsonExceptionsVoid(this.delegate::skipValue);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String getPreviousPath() {
        return this.delegate.getPreviousPath();
    }

    @Override
    public String getPath() {
        return this.delegate.getPath();
    }

    @FunctionalInterface
    private static interface DelegateFunction<T> {
        public T call() throws IOException;
    }

    @FunctionalInterface
    private static interface DelegateAction
    extends DelegateFunction<Void> {
        public void run() throws IOException;

        @Override
        default public Void call() throws IOException {
            this.run();
            return null;
        }
    }
}

