/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.yacl;

import com.bawnorton.configurable.OptionType;
import com.bawnorton.configurable.ap.yacl.YaclElement;
import com.bawnorton.configurable.ap.yacl.YaclListeners;
import com.bawnorton.configurable.ap.yacl.YaclOptionBinding;
import com.bawnorton.configurable.ap.yacl.YaclOptionController;
import com.bawnorton.configurable.ap.yacl.YaclOptionDescription;
import com.bawnorton.configurable.ap.yacl.YaclOptionName;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class YaclOption
extends YaclElement {
    private final String generic;
    private final YaclElement optionName;
    private final YaclElement optionDescription;
    private final YaclElement optionBinding;
    private final YaclOptionController optionController;
    private final String optionFlags;
    private final YaclListeners listeners;

    public YaclOption(String generic, YaclOptionName optionName, YaclOptionDescription optionDescription, YaclOptionBinding optionBinding, YaclOptionController optionController, OptionType[] optionTypes, YaclListeners listeners) {
        this.generic = generic;
        this.optionName = optionName;
        this.optionDescription = optionDescription;
        this.optionBinding = optionBinding;
        this.optionController = optionController;
        this.optionFlags = Arrays.stream(optionTypes).map(type -> "OptionFlag.%s".formatted(type.name())).collect(Collectors.joining(", "));
        this.listeners = listeners;
    }

    @Override
    protected void addNeededImports(Consumer<String> adder) {
        adder.accept("dev.isxander.yacl3.api.Option");
        adder.accept("dev.isxander.yacl3.api.OptionFlag");
        this.optionName.addNeededImports(adder);
        this.optionDescription.addNeededImports(adder);
        this.optionBinding.addNeededImports(adder);
        this.optionController.addNeededImports(adder);
        this.listeners.addNeededImports(adder);
    }

    @Override
    protected String getSpec(int depth) {
        YaclOptionController.Custom customController;
        StringBuilder spec = new StringBuilder();
        spec.append("Option.<%2$s>createBuilder()\n%1$s.name(%3$s)\n%1$s.description(%4$s)\n%1$s.binding(%5$s)\n".formatted("\t".repeat(depth), this.generic, this.optionName.getSpec(depth + 1), this.optionDescription.getSpec(depth + 1), this.optionBinding.getSpec(depth + 1)));
        YaclOptionController yaclOptionController = this.optionController;
        String controllerType = yaclOptionController instanceof YaclOptionController.Custom && !(customController = (YaclOptionController.Custom)yaclOptionController).isBuilder() ? "customController" : "controller";
        spec.append("%1$s.%2$s(%3$s)\n".formatted("\t".repeat(depth), controllerType, this.optionController.getSpec(depth + 1)));
        if (!this.optionFlags.isEmpty()) {
            spec.append("%1$s.flag(%2$s)\n".formatted("\t".repeat(depth), this.optionFlags));
        }
        if (!this.listeners.isEmpty()) {
            spec.append("%1$s.listeners(%2$s)\n".formatted("\t".repeat(depth), this.listeners.getSpec(depth + 1)));
        }
        spec.append("%1$s.build()".formatted("\t".repeat(depth)));
        return spec.toString();
    }
}

