/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.yacl;

import com.bawnorton.configurable.Image;
import com.bawnorton.configurable.ImageType;
import com.bawnorton.configurable.ap.helper.MappingsHelper;
import com.bawnorton.configurable.ap.yacl.YaclElement;
import java.util.function.Consumer;

public abstract class YaclDescriptionImage
extends YaclElement {
    protected final Image image;
    protected final String customOwner;
    protected final String customMethod;

    protected YaclDescriptionImage(Image image, String customOwner, String customMethod) {
        this.image = image;
        this.customOwner = customOwner;
        this.customMethod = customMethod;
    }

    @Override
    protected void addNeededImports(Consumer<String> adder) {
        adder.accept("java.nio.file.Path");
        adder.accept(MappingsHelper.getIdentifier());
        if (this.customOwner != null) {
            adder.accept(this.customOwner);
        }
    }

    protected abstract String getCustomImageSpec();

    @Override
    protected String getSpec(int depth) {
        if (this.customOwner != null && this.customMethod != null) {
            return "customImage(%s)".formatted(this.getCustomImageSpec());
        }
        String id = "Identifier.of(\"%s\")".formatted(this.image.value());
        return switch (this.image.type()) {
            default -> throw new MatchException(null, null);
            case ImageType.RESOURCE -> {
                if (!this.image.path().isEmpty()) {
                    yield "image(Path.of(\"%s\"), %s)".formatted(this.image.path(), id);
                }
                int textureWidth = this.image.textureWidth() == 0 ? this.image.width() : this.image.textureWidth();
                int textureHeight = this.image.textureHeight() == 0 ? this.image.height() : this.image.textureHeight();
                yield "image(%s, %sF, %sF, %s, %s, %s, %s)".formatted(id, Float.valueOf(this.image.u()), Float.valueOf(this.image.v()), this.image.width(), this.image.height(), textureWidth, textureHeight);
            }
            case ImageType.WEBP -> !this.image.path().isEmpty() ? "webpImage(Path.of(\"%s\"), %s)".formatted(this.image.path(), id) : "webpImage(%s)".formatted(id);
        };
    }

    public static interface Factory<T extends YaclDescriptionImage> {
        public T create(Image var1, String var2, String var3);
    }
}

