/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.tree;

import com.bawnorton.configurable.ControllerType;
import com.bawnorton.configurable.Image;
import com.bawnorton.configurable.ap.helper.AnnotationHelper;
import com.bawnorton.configurable.ap.helper.MethodHelper;
import com.bawnorton.configurable.ap.tree.ConfigurableHolder;
import com.bawnorton.configurable.ap.yacl.YaclDescriptionImage;
import com.bawnorton.configurable.ap.yacl.YaclDescriptionText;
import com.bawnorton.configurable.ap.yacl.YaclElement;
import com.bawnorton.configurable.ap.yacl.YaclListener;
import com.bawnorton.configurable.ap.yacl.YaclListeners;
import com.bawnorton.configurable.ap.yacl.YaclOptionController;
import com.bawnorton.configurable.ap.yacl.YaclOptionDescriptionImage;
import com.bawnorton.configurable.ap.yacl.YaclOptionGroupDescriptionImage;
import com.bawnorton.configurable.ap.yacl.YaclSimpleDescriptionText;
import com.bawnorton.configurable.ap.yacl.YaclValueFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public record ConfigurableElement(Element element, String comment, ConfigurableHolder annotationHolder, List<ConfigurableElement> children) {
    public String getKey() {
        String key = this.annotationHolder.value();
        if (key.isEmpty()) {
            key = this.element.getSimpleName().toString();
        }
        return key;
    }

    public boolean childless() {
        return this.children.isEmpty();
    }

    public TypeMirror getType() {
        return this.element.asType();
    }

    public String getTypeName() {
        String qualified = this.getType().toString();
        return qualified.substring(qualified.lastIndexOf(46) + 1);
    }

    public String getBoxedType(Types types) {
        String boxed;
        TypeMirror mirror = this.getType();
        if (!mirror.getKind().isPrimitive()) {
            boxed = mirror.toString();
        } else {
            PrimitiveType primitiveType = types.getPrimitiveType(mirror.getKind());
            boxed = types.boxedClass(primitiveType).getSimpleName().toString();
        }
        return boxed.substring(boxed.lastIndexOf(46) + 1);
    }

    public TypeKind getTypeKind() {
        return this.getType().getKind();
    }

    public String getFullyQualifiedTypeName(Types types) {
        return this.getQualifiedTypeName(types, this.element);
    }

    public String getOwnerName() {
        return this.element.getEnclosingElement().getSimpleName().toString();
    }

    public String getFullyQualifiedOwnerName(Types types) {
        Element owner = this.element.getEnclosingElement();
        return this.getQualifiedTypeName(types, owner);
    }

    private String getQualifiedTypeName(Types types, Element owner) {
        TypeMirror mirror = owner.asType();
        if (mirror.getKind().isPrimitive()) {
            PrimitiveType primitiveType = types.getPrimitiveType(mirror.getKind());
            return types.boxedClass(primitiveType).getQualifiedName().toString();
        }
        if (mirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)mirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().toString();
        }
        return mirror.toString();
    }

    public String getElementName() {
        return this.element.getSimpleName().toString();
    }

    public String getElementConfigName() {
        return this.getElementName() + "Config";
    }

    public boolean defaultServerEnforces() {
        return AnnotationHelper.isDefaultValue(this.annotationHolder.getConfigurableMirror(), "serverEnforces");
    }

    public List<ConfigurableElement> getAllChildren() {
        if (this.childless()) {
            return new ArrayList<ConfigurableElement>();
        }
        ArrayList<ConfigurableElement> children = new ArrayList<ConfigurableElement>();
        for (ConfigurableElement child : this.children) {
            children.add(child);
            children.addAll(child.getAllChildren());
        }
        return children;
    }

    public List<ConfigurableElement> disolveMultiLevelParents() {
        ArrayList<ConfigurableElement> result = new ArrayList<ConfigurableElement>();
        boolean allChildrenAreChildless = true;
        for (ConfigurableElement child : this.children) {
            if (child.childless()) continue;
            allChildrenAreChildless = false;
            break;
        }
        if (allChildrenAreChildless) {
            result.add(this);
        } else {
            for (ConfigurableElement child : this.children) {
                result.addAll(child.disolveMultiLevelParents());
            }
        }
        return result;
    }

    public String getCategory() {
        String tab = this.annotationHolder.category();
        if (tab.isEmpty()) {
            Element enclosingElement = this.element.getEnclosingElement();
            while (!(enclosingElement instanceof PackageElement)) {
                if ((enclosingElement = enclosingElement.getEnclosingElement()) != null) continue;
                throw new IllegalStateException("Cannot find enclosing package of: %s".formatted(this.element));
            }
            tab = enclosingElement.getSimpleName().toString();
        }
        return tab;
    }

    public ControllerType getControllerType() {
        return this.annotationHolder.controller();
    }

    public boolean hasCustomController() {
        return !this.annotationHolder.customController().isEmpty();
    }

    public YaclOptionController.Custom getCustomController(Types types, Elements elements) {
        String customController = this.annotationHolder.customController();
        if (customController.isEmpty()) {
            throw new IllegalStateException("Cannot find custom controller of: %s".formatted(this.element));
        }
        return this.getMethodBased(types, (owner, methodName) -> {
            TypeElement builder = elements.getTypeElement("dev.isxander.yacl3.api.controller.ControllerBuilder");
            TypeMirror builderType = builder.asType();
            TypeMirror returnType = MethodHelper.getMethodReturnType(elements, owner, methodName);
            boolean isBuilder = returnType == null ? false : types.isAssignable(types.erasure(returnType), types.erasure(builderType));
            return new YaclOptionController.Custom((String)owner, (String)methodName, isBuilder);
        }, customController);
    }

    public Image image() {
        return this.annotationHolder.image();
    }

    public boolean hasImage() {
        Image image = this.image();
        return !image.value().isEmpty() || !image.custom().isEmpty();
    }

    public YaclValueFormatter getFormatter(Types types) {
        String formatter = this.annotationHolder.formatter();
        if (formatter.isEmpty()) {
            return null;
        }
        return this.getMethodBased(types, YaclValueFormatter::new, formatter);
    }

    public YaclListeners getListeners(Types types) {
        String[] listeners = this.annotationHolder.listener();
        YaclListeners yaclListeners = new YaclListeners();
        for (String listener : listeners) {
            yaclListeners.addListener(this.getMethodBased(types, YaclListener::new, listener));
        }
        return yaclListeners;
    }

    public YaclElement getDescriptionText(Types types, String configName, YaclDescriptionText.Factory<?> factory) {
        String descriptioner = this.annotationHolder.descriptioner();
        if (descriptioner.isEmpty()) {
            return new YaclSimpleDescriptionText(configName, this.getKey());
        }
        return this.getMethodBased(types, factory::create, descriptioner);
    }

    public YaclDescriptionImage getOptionDescriptionImage(Types types) {
        if (this.annotationHolder.inheritedImage()) {
            return this.getOptionGroupDescriptionImage(types);
        }
        return this.getImage(types, YaclOptionDescriptionImage::new);
    }

    public YaclDescriptionImage getOptionGroupDescriptionImage(Types types) {
        return this.getImage(types, YaclOptionGroupDescriptionImage::new);
    }

    private <T extends YaclDescriptionImage> T getImage(Types types, YaclDescriptionImage.Factory<T> factory) {
        if (!this.hasImage()) {
            return null;
        }
        Image image = this.image();
        String custom = image.custom();
        if (custom.isEmpty()) {
            return factory.create(image, null, null);
        }
        return (T)this.getMethodBased(types, (owner, method) -> factory.create(image, (String)owner, (String)method), custom);
    }

    private <T extends YaclElement> T getMethodBased(Types types, BiFunction<String, String, T> ctor, String methodName) {
        String owner;
        if (methodName.contains("#")) {
            String[] parts = methodName.split("#");
            String owner2 = parts[0];
            String method = parts[1];
            return (T)((YaclElement)ctor.apply(owner2, method));
        }
        if (this.element.getKind().isField()) {
            owner = this.getFullyQualifiedOwnerName(types);
        } else if (this.element.getKind().isClass()) {
            owner = this.getFullyQualifiedTypeName(types);
        } else {
            throw new IllegalStateException("Could not determine owner for \"%s\"".formatted(methodName));
        }
        return (T)((YaclElement)ctor.apply(owner, methodName));
    }
}

