/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.sourceprovider;

import com.bawnorton.configurable.ap.sourceprovider.SourceProvider;
import com.bawnorton.configurable.libs.gson.Gson;
import com.bawnorton.configurable.libs.gson.GsonBuilder;
import com.bawnorton.configurable.libs.gson.JsonObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.processing.Filer;

public final class FabricSourceProvider
extends SourceProvider {
    private JsonObject fmj;

    public FabricSourceProvider(Filer filer, Path buildPath) {
        this(filer, buildPath, new GsonBuilder().setPrettyPrinting().create());
    }

    public FabricSourceProvider(Filer filer, Path buildPath, Gson gson) {
        super(filer, buildPath);
        try {
            this.fmj = gson.fromJson(this.getConfigFile(), JsonObject.class);
        }
        catch (IOException e) {
            this.fmj = null;
        }
    }

    @Override
    protected Reader getConfigFile() throws IOException {
        Path projectRoot = this.findProjectRoot();
        String json = Files.readString(projectRoot.resolve("src/main/resources/fabric.mod.json"));
        return new StringReader(json);
    }

    @Override
    public boolean matches() {
        return this.fmj != null;
    }

    @Override
    public String getName() {
        return this.fmj.get("id").getAsString();
    }
}

