/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.generator;

import com.bawnorton.configurable.ControllerType;
import com.bawnorton.configurable.ap.generator.ConfigurableGenerator;
import com.bawnorton.configurable.ap.helper.MappingsHelper;
import com.bawnorton.configurable.ap.tree.ConfigurableElement;
import com.bawnorton.configurable.ap.yacl.YaclCategories;
import com.bawnorton.configurable.ap.yacl.YaclCategory;
import com.bawnorton.configurable.ap.yacl.YaclCategoryName;
import com.bawnorton.configurable.ap.yacl.YaclCategoryTooltip;
import com.bawnorton.configurable.ap.yacl.YaclOption;
import com.bawnorton.configurable.ap.yacl.YaclOptionBinding;
import com.bawnorton.configurable.ap.yacl.YaclOptionController;
import com.bawnorton.configurable.ap.yacl.YaclOptionDescription;
import com.bawnorton.configurable.ap.yacl.YaclOptionDescriptionText;
import com.bawnorton.configurable.ap.yacl.YaclOptionGroup;
import com.bawnorton.configurable.ap.yacl.YaclOptionGroupDescription;
import com.bawnorton.configurable.ap.yacl.YaclOptionGroupDescriptionText;
import com.bawnorton.configurable.ap.yacl.YaclOptionGroupName;
import com.bawnorton.configurable.ap.yacl.YaclOptionGroups;
import com.bawnorton.configurable.ap.yacl.YaclOptionName;
import com.bawnorton.configurable.ap.yacl.YaclOptions;
import com.bawnorton.configurable.ap.yacl.YaclRoot;
import com.bawnorton.configurable.ap.yacl.YaclSave;
import com.bawnorton.configurable.ap.yacl.YaclTitle;
import com.bawnorton.configurable.ap.yacl.YaclValueFormatter;
import com.bawnorton.configurable.load.ConfigurableSettings;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;

public final class ConfigScreenFactoryGenerator
extends ConfigurableGenerator {
    private static final String SCREEN_FACTORY_SPEC = "\npackage <configurable_package>.client;\n\nimport com.bawnorton.configurable.ConfigurableMain;\nimport com.bawnorton.configurable.generated.GeneratedConfigScreenFactory;\nimport com.bawnorton.configurable.load.ConfigurableWrapper;\nimport com.bawnorton.configurable.platform.Platform;\nimport java.net.URI;\nimport java.util.Optional;\n<imports>\n\npublic final class ConfigScreenFactory implements GeneratedConfigScreenFactory {\n    @Override\n    public Screen createScreen(MinecraftClient client, Screen parent) {\n        if(!Platform.isModLoaded(\"yet_another_config_lib_v3\")) {\n            return new ConfirmScreen(result -> {\n                if (result) {\n                    Util.getOperatingSystem().open(URI.create(\"https://modrinth.com/mod/yacl/versions\"));\n                }\n                client.setScreen(parent);\n            }, Text.translatable(\"configurable.yacl.not_installed\"), Text.translatable(\"configurable.yacl.not_installed.message\"), ScreenTexts.YES, ScreenTexts.NO);\n        }\n        return createYaclScreen(parent);\n    }\n\n    @Override\n    public void refresh() {\n        if(Platform.isModLoaded(\"yet_another_config_lib_v3\")) {\n            YaclScreenFactory.refresh();\n        }\n    }\n\n    private Screen createYaclScreen(Screen parent) {\n        return ConfigurableMain.getWrappers(\"<name>\")\n            .values()\n            .stream()\n            .filter(ConfigurableWrapper::hasScreenFactory)\n            .findFirst()\n            .map(wrapper -> YaclScreenFactory.create(parent, (Config) wrapper.getConfig()))\n            .orElse(parent);\n    }\n}\n\n";
    private static final String YACL_SCREEN_FACTORY_SPEC = "\npackage <configurable_package>.client;\n\nimport dev.isxander.yacl3.api.Option;\nimport dev.isxander.yacl3.api.YetAnotherConfigLib;\nimport dev.isxander.yacl3.api.utils.OptionUtils;\n\n<imports>\n\npublic final class YaclScreenFactory {\n    private static YetAnotherConfigLib yacl;\n\n    public static Screen create(Screen parent, Config config) {\n        yacl = createYacl(config);\n        return yacl.generateScreen(parent);\n    }\n\n    private static YetAnotherConfigLib createYacl(Config config) {\n        return <yacl>;\n    }\n\n    public static void refresh() {\n        if(yacl == null) return;\n\n        OptionUtils.forEachOptions(yacl, option -> {\n            option.forgetPendingValue();\n            option.applyValue();\n        });\n    }\n}\n";
    private final Elements elements;

    public ConfigScreenFactoryGenerator(Filer filer, Elements elements, Types types, Messager messager, ConfigurableSettings settings) {
        super(filer, types, messager, settings);
        this.elements = elements;
    }

    public void generateConfigScreenFactory() throws IOException {
        String spec = SCREEN_FACTORY_SPEC;
        String mcImports = "import <config_class_name>;\nimport %s;\nimport %s;\nimport %s;\nimport %s;\nimport %s;\nimport %s;\n".formatted(MappingsHelper.getMinecraftClient(), MappingsHelper.getConfirmScreen(), MappingsHelper.getScreen(), MappingsHelper.getScreenTexts(), MappingsHelper.getText(), MappingsHelper.getUtil()).trim();
        spec = spec.replaceAll("<imports>", mcImports);
        spec = this.applyReplacements(spec);
        JavaFileObject configScreenFactory = this.filer.createSourceFile(this.settings.fullyQualifiedScreenFactory(), new Element[0]);
        try (PrintWriter out = new PrintWriter(configScreenFactory.openWriter());){
            out.println(spec);
        }
    }

    public void generateYaclScreenFactory(List<ConfigurableElement> roots, Function<ConfigurableElement, String> externalRefGetter) throws IOException {
        String spec = YACL_SCREEN_FACTORY_SPEC;
        YaclRoot root = this.createYaclImpl(roots, externalRefGetter);
        spec = spec.replaceAll("<yacl>", root.getSpec(4));
        StringBuilder importBuilder = new StringBuilder();
        importBuilder.append("import %s;\n".formatted(MappingsHelper.getScreen()));
        importBuilder.append("import <config_class_name>;\n");
        for (String neededImport : root.getNeededImports()) {
            importBuilder.append("import ").append(neededImport).append(";\n");
        }
        spec = spec.replaceAll("<imports>", importBuilder.toString());
        spec = this.applyReplacements(spec);
        JavaFileObject configYaclScreenFactory = this.filer.createSourceFile("%s.client.YaclScreenFactory".formatted(this.settings.packageName()), new Element[0]);
        try (PrintWriter out = new PrintWriter(configYaclScreenFactory.openWriter());){
            out.println(spec);
        }
    }

    private YaclRoot createYaclImpl(List<ConfigurableElement> roots, Function<ConfigurableElement, String> externalRefGetter) {
        HashMap<String, List> elementCategories = new HashMap<String, List>();
        for (ConfigurableElement element : roots) {
            String category = element.getCategory();
            elementCategories.computeIfAbsent(category, k -> new ArrayList()).add(element);
        }
        YaclCategories categories = new YaclCategories();
        String configName = this.settings.name();
        elementCategories.forEach((categoryName, entries) -> {
            YaclOptions options = new YaclOptions();
            YaclOptionGroups optionGroups = new YaclOptionGroups();
            entries.forEach(entry -> entry.disolveMultiLevelParents().forEach(parentOrChild -> {
                if (parentOrChild.annotationHolder().exclude()) {
                    return;
                }
                if (parentOrChild.childless()) {
                    options.addOption(this.createYaclOption((ConfigurableElement)parentOrChild, configName, externalRefGetter));
                } else {
                    String key = parentOrChild.getKey();
                    YaclOptions entryOptions = new YaclOptions();
                    parentOrChild.children().forEach(child -> {
                        if (child.annotationHolder().exclude()) {
                            return;
                        }
                        entryOptions.addOption(this.createYaclOption((ConfigurableElement)child, configName, externalRefGetter));
                    });
                    optionGroups.addOptionGroup(new YaclOptionGroup(new YaclOptionGroupName(configName, key), new YaclOptionGroupDescription(parentOrChild.getDescriptionText(this.types, configName, YaclOptionGroupDescriptionText::new), parentOrChild.getOptionGroupDescriptionImage(this.types)), entryOptions, parentOrChild.annotationHolder().collapsed()));
                }
            }));
            categories.addCategory(new YaclCategory(new YaclCategoryName(configName, (String)categoryName), new YaclCategoryTooltip(configName, (String)categoryName), options, optionGroups));
        });
        return new YaclRoot(new YaclTitle(configName), categories, new YaclSave(configName));
    }

    @NotNull
    private YaclOption createYaclOption(ConfigurableElement entry, String configName, Function<ConfigurableElement, String> externalRefGetter) {
        String key = entry.getKey();
        String type = entry.getBoxedType(this.types);
        String externalRef = externalRefGetter.apply(entry);
        return new YaclOption(type, new YaclOptionName(configName, key), new YaclOptionDescription(entry.getDescriptionText(this.types, configName, YaclOptionDescriptionText::new), entry.getOptionDescriptionImage(this.types)), new YaclOptionBinding(externalRef), this.getOptionController(entry, externalRef), entry.annotationHolder().type(), entry.getListeners(this.types));
    }

    @NotNull
    private YaclOptionController getOptionController(ConfigurableElement entry, String externalRef) {
        YaclValueFormatter formatter = entry.getFormatter(this.types);
        if (entry.hasCustomController()) {
            return entry.getCustomController(this.types, this.elements);
        }
        return this.getTypedController(entry, externalRef, formatter);
    }

    @NotNull
    private YaclOptionController getTypedController(ConfigurableElement entry, String externalRef, YaclValueFormatter formatter) {
        return switch (entry.getControllerType()) {
            default -> throw new MatchException(null, null);
            case ControllerType.AUTO -> {
                switch (entry.getTypeKind()) {
                    case BOOLEAN: {
                        yield new YaclOptionController.TickBox();
                    }
                    case BYTE: 
                    case SHORT: 
                    case INT: {
                        yield new YaclOptionController.IntegerSlider(formatter, (int)entry.annotationHolder().min(), (int)entry.annotationHolder().max());
                    }
                    case DOUBLE: {
                        yield new YaclOptionController.DoubleSlider(formatter, entry.annotationHolder().min(), entry.annotationHolder().max());
                    }
                    case CHAR: {
                        yield new YaclOptionController.StringField();
                    }
                    case FLOAT: {
                        yield new YaclOptionController.FloatSlider(formatter, (float)entry.annotationHolder().min(), (float)entry.annotationHolder().max());
                    }
                    case LONG: {
                        yield new YaclOptionController.LongSlider(formatter, (long)entry.annotationHolder().min(), (long)entry.annotationHolder().max());
                    }
                    case DECLARED: {
                        ElementKind elementKind = ((DeclaredType)entry.getType()).asElement().getKind();
                        if (elementKind == ElementKind.ENUM) {
                            yield new YaclOptionController.CyclingEnum(formatter, entry.getFullyQualifiedTypeName(this.types));
                        }
                        if (elementKind == ElementKind.CLASS) {
                            TypeElement string = this.elements.getTypeElement("java.lang.String");
                            if (this.types.isSameType(entry.getType(), string.asType())) {
                                yield new YaclOptionController.StringField();
                            }
                            TypeElement iterable = this.elements.getTypeElement("java.lang.Iterable");
                            if (this.types.isAssignable(entry.getType(), iterable.asType())) {
                                yield new YaclOptionController.CyclingList(formatter, externalRef);
                            }
                            TypeElement item = this.elements.getTypeElement(MappingsHelper.getItem());
                            if (this.types.isSameType(entry.getType(), item.asType())) {
                                yield new YaclOptionController.Item();
                            }
                        }
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Could not automatically create controller for type: %s".formatted(entry.getFullyQualifiedTypeName(this.types)), entry.element());
                        throw new RuntimeException();
                    }
                    case ARRAY: {
                        yield new YaclOptionController.CyclingList(formatter, externalRef);
                    }
                }
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Could not automatically create controller for type: %s".formatted(entry.getFullyQualifiedTypeName(this.types)), entry.element());
                throw new RuntimeException();
            }
            case ControllerType.BOOL -> new YaclOptionController.Bool(formatter);
            case ControllerType.COLOR -> new YaclOptionController.Color(false);
            case ControllerType.COLOR_WITH_ALPHA -> new YaclOptionController.Color(true);
            case ControllerType.CYCLING_LIST -> new YaclOptionController.CyclingList(formatter, externalRef);
            case ControllerType.DOUBLE_FIELD -> new YaclOptionController.DoubleField(formatter, entry.annotationHolder().min(), entry.annotationHolder().max());
            case ControllerType.DOUBLE_SLIDER -> new YaclOptionController.DoubleSlider(formatter, entry.annotationHolder().min(), entry.annotationHolder().max());
            case ControllerType.ENUM -> new YaclOptionController.CyclingEnum(formatter, entry.getFullyQualifiedTypeName(this.types));
            case ControllerType.ENUM_DROPDOWN -> new YaclOptionController.EnumDropdown(formatter);
            case ControllerType.FLOAT_FIELD -> new YaclOptionController.FloatField(formatter, (float)entry.annotationHolder().min(), (float)entry.annotationHolder().max());
            case ControllerType.FLOAT_SLIDER -> new YaclOptionController.FloatSlider(formatter, (float)entry.annotationHolder().min(), (float)entry.annotationHolder().max());
            case ControllerType.INTEGER_FIELD -> new YaclOptionController.IntegerField(formatter, (int)entry.annotationHolder().min(), (int)entry.annotationHolder().max());
            case ControllerType.INTEGER_SLIDER -> new YaclOptionController.IntegerSlider(formatter, (int)entry.annotationHolder().min(), (int)entry.annotationHolder().max());
            case ControllerType.ITEM -> new YaclOptionController.Item();
            case ControllerType.LONG_FIELD -> new YaclOptionController.LongField(formatter, (long)entry.annotationHolder().min(), (long)entry.annotationHolder().max());
            case ControllerType.LONG_SLIDER -> new YaclOptionController.LongSlider(formatter, (long)entry.annotationHolder().min(), (long)entry.annotationHolder().max());
            case ControllerType.STRING_FIELD -> new YaclOptionController.StringField();
            case ControllerType.TICK_BOX -> new YaclOptionController.TickBox();
        };
    }
}

