/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ap.generator;

import com.bawnorton.configurable.ap.generator.ConfigurableGenerator;
import com.bawnorton.configurable.load.ConfigurableSettings;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

public final class ConfigLoaderGenerator
extends ConfigurableGenerator {
    private static final String LOADER_SPEC = "\npackage <configurable_package>;\n\nimport <config_class_name>;\nimport com.bawnorton.configurable.ConfigurableMain;\nimport com.bawnorton.configurable.generated.GeneratedConfigLoader;\nimport com.bawnorton.configurable.ref.Reference;\nimport com.bawnorton.configurable.ref.gson.ReferenceSerializer;\nimport com.bawnorton.configurable.platform.Platform;\nimport com.google.gson.FieldNamingStrategy;\nimport com.google.gson.Gson;\nimport com.google.gson.GsonBuilder;\nimport com.google.gson.JsonPrimitive;\nimport com.google.gson.JsonSyntaxException;\nimport com.google.gson.JsonObject;\nimport com.google.gson.JsonElement;\nimport org.quiltmc.parsers.json.JsonReader;\nimport org.quiltmc.parsers.json.JsonWriter;\nimport org.quiltmc.parsers.json.gson.GsonReader;\nimport org.quiltmc.parsers.json.gson.GsonWriter;\nimport java.io.IOException;\nimport java.io.StringWriter;\nimport java.lang.reflect.Field;\nimport java.lang.ReflectiveOperationException;\nimport java.nio.file.Files;\nimport java.nio.file.Path;\nimport java.nio.file.StandardOpenOption;\nimport java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.Set;\nimport java.util.function.BiConsumer;\nimport java.util.function.UnaryOperator;\n\npublic final class ConfigLoader implements GeneratedConfigLoader<Config> {\n    private static final Path configPath = Platform.getConfigDir()\n            .resolve(\"configurable/<file_name>.json5\");\n    private static final Path legacyConfigPath = Platform.getConfigDir()\n            .resolve(\"configurable/<file_name>.json\");\n    private static final Map<String, Field> FIELDS_BY_KEY_PATH = new HashMap<>();\n    private static final Gson GSON = createGson();\n\n    private static Gson createGson() {\n       GsonBuilder builder = new GsonBuilder()\n            .setPrettyPrinting()\n            .registerTypeAdapter(Reference.class, new ReferenceSerializer());\n       ConfigurableMain.getTypeAdapters(\"<name>\", \"<source_set>\").forEach(builder::registerTypeHierarchyAdapter);\n       FieldNamingStrategy namingStrategy = ConfigurableMain.getFieldNamingStrategy(\"<name>\", \"<source_set>\");\n       builder.setFieldNamingStrategy(namingStrategy);\n\n       recordNestedKeyPaths(Config.class, \"\", namingStrategy, FIELDS_BY_KEY_PATH::put);\n\n       return builder.create();\n    }\n\n    private static void recordNestedKeyPaths(Class<?> clazz, String keyPath, FieldNamingStrategy namingStrategy, BiConsumer<String, Field> setter) {\n        for (Field field : clazz.getDeclaredFields()) {\n            if(field.getName().equals(\"CONFIGURABLE_COMMENT\")) continue;\n\n            String fieldPath = keyPath + namingStrategy.translateName(field);\n            setter.accept(fieldPath, field);\n            if(!field.getType().equals(Reference.class)) {\n                recordNestedKeyPaths(field.getType(), \"%s.\".formatted(fieldPath), namingStrategy, setter);\n            }\n        }\n    }\n\n    @Override\n    public Config loadConfig(UnaryOperator<String> datafixer) {\n        try {\n            boolean usingLegacyConfig = false;\n            Path loadingPath = configPath;\n            if(Files.exists(legacyConfigPath)) {\n                loadingPath = legacyConfigPath;\n                usingLegacyConfig = true;\n            }\n\n            if(!Files.exists(loadingPath)) {\n                Files.createDirectories(loadingPath.getParent());\n                Files.createFile(loadingPath);\n                return new Config();\n            }\n            try {\n                GsonReader reader = new GsonReader(JsonReader.json5(Files.newBufferedReader(loadingPath)));\n                JsonObject config = GSON.fromJson(reader, JsonObject.class);\n                if(config == null) {\n                    ConfigurableMain.LOGGER.warn(\"No config \\\"<file_name>\\\" found, using default\");\n                    return new Config();\n                }\n\n                Config parsed = parseConfig(config, true);\n\n                if(usingLegacyConfig) {\n                    ConfigurableMain.LOGGER.info(\"Migrating legacy config \\\"<file_name>\\\"\");\n                    Files.deleteIfExists(legacyConfigPath);\n                    saveConfig(parsed);\n                }\n\n                ConfigurableMain.LOGGER.info(\"Successfully loaded config \\\"<file_name>\\\"\");\n                return parsed;\n            } catch (JsonSyntaxException e) {\n                ConfigurableMain.LOGGER.error(\"Failed to parse \\\"<file_name>\\\" config file, using default\", e);\n            }\n        } catch (IOException | RuntimeException e) {\n            ConfigurableMain.LOGGER.error(\"Failed to load \\\"<file_name>\\\" config file, using default\", e);\n        }\n        return new Config();\n    }\n\n    @Override\n    public void saveConfig(Config config) {\n        try(StringWriter stringWriter = new StringWriter()) {\n            JsonWriter writer = JsonWriter.json5(stringWriter);\n            writer.beginObject();\n\n            Field[] fields = Config.class.getDeclaredFields();\n            for(Field field : fields) {\n                writeField(field, config, writer);\n            }\n\n            writer.endObject();\n            writer.flush();\n\n            Files.writeString(configPath, stringWriter.toString(), StandardOpenOption.CREATE);\n        } catch (IOException e) {\n            ConfigurableMain.LOGGER.error(\"Failed to write \\\"<file_name>\\\" config file\", e);\n        }\n    }\n\n    private void writeField(Field field, Object instance, JsonWriter writer) throws IOException {\n        try {\n            boolean isRef = field.getType().equals(Reference.class);\n            if(isRef) {\n                writeRefField(field, instance, writer);\n            } else {\n                writeNestedField(field, field.get(instance), writer);\n            }\n        } catch (ReflectiveOperationException e) {\n            throw new IOException(e);\n        }\n    }\n\n    private void writeRefField(Field field, Object instance, JsonWriter writer) throws IOException, ReflectiveOperationException {\n        Reference<?> ref = (Reference<?>) field.get(instance);\n        if(ref.hasComment()) {\n            writer.blockComment(ref.getComment());\n        }\n        writer.name(GSON.fieldNamingStrategy().translateName(field));\n        JsonElement elemnt = GSON.toJsonTree(ref, field.getGenericType());\n        GSON.toJson(elemnt, new GsonWriter(writer));\n    }\n\n    private void writeNestedField(Field field, Object instance, JsonWriter writer) throws IOException, ReflectiveOperationException {\n        try {\n            Field commentField = instance.getClass().getDeclaredField(\"CONFIGURABLE_COMMENT\");\n            String comment = (String) commentField.get(instance);\n            if(comment != null && !comment.isEmpty()) {\n                writer.blockComment(comment);\n            }\n        } catch (NoSuchFieldException ignored) {}\n        writer.name(GSON.fieldNamingStrategy().translateName(field));\n        writer.beginObject();\n        Field[] nestedFields = instance.getClass().getDeclaredFields();\n        for(Field nestedField : nestedFields) {\n            if(nestedField.getName().equals(\"CONFIGURABLE_COMMENT\")) continue;\n\n            nestedField.setAccessible(true);\n            writeField(nestedField, instance, writer);\n        }\n        writer.endObject();\n    }\n\n    @Override\n    public String serializeConfig(Config config) {\n        return GSON.toJson(config);\n    }\n\n    @Override\n    public Config deserializeConfig(String serializedConfig) {\n        return parseConfig(GSON.fromJson(serializedConfig, JsonObject.class), false);\n    }\n\n    private Config parseConfig(JsonObject configJson, boolean set) {\n        List<String> stack = new ArrayList<>();\n        Config config = new Config();\n        parseNested(stack, configJson, config, set);\n        return config;\n    }\n\n    private void parseNested(List<String> stack, JsonObject nestedJson, Config config, boolean set) {\n       Set<String> keys = nestedJson.keySet();\n       for(String key : keys) {\n           JsonElement element = nestedJson.get(key);\n           if(element.isJsonObject()) {\n               stack.add(key);\n               parseNested(stack, element.getAsJsonObject(), config, set);\n               stack.remove(stack.size() - 1);\n           } else if (element.isJsonNull()) {\n               parseReference(key, null, stack, config, set);\n           } else if (element.isJsonPrimitive()) {\n               parseReference(key, element.getAsJsonPrimitive(), stack, config, set);\n           }\n       }\n    }\n\n    private void parseReference(String key, JsonPrimitive value, List<String> parents, Config config, boolean set) {\n        Class<? extends Config> configClass = config.getClass();\n        String keyPath = \"\";\n        if(!parents.isEmpty()) {\n            keyPath = String.join(\".\", parents) + \".\";\n        }\n        keyPath += key;\n\n        Field target = FIELDS_BY_KEY_PATH.get(keyPath);\n        Object instance = config;\n\n        try {\n            if (!parents.isEmpty()) {\n                String parentKeyPath = parents.get(0);\n                Field parentField = FIELDS_BY_KEY_PATH.get(parentKeyPath);\n\n                for (int i = 0; i < parents.size(); i++) {\n                    if (i > 0) {\n                        parentKeyPath += \".\" + parents.get(i);\n                        parentField = FIELDS_BY_KEY_PATH.get(parentKeyPath);\n                    }\n\n                    try {\n                        instance = parentField.get(instance);\n                    } catch (ReflectiveOperationException e) {\n                        ConfigurableMain.LOGGER.error(\"Field: \\\"%s\\\" could not be set.\".formatted(keyPath), e);\n                    }\n                }\n            }\n        } catch (RuntimeException ignored) {\n            ConfigurableMain.LOGGER.warn(\"Field: \\\"%s\\\" could not be found.\".formatted(keyPath));\n            return;\n        }\n        try {\n            Reference<?> reference = (Reference<?>) target.get(instance);\n            Class<?> expected = reference.getType();\n            try {\n                Object refValue = getRefValue(value, expected);\n                if(set) {\n                    reference.set(refValue);\n                } else {\n                    reference.setMemento(refValue);\n                }\n            } catch (ClassCastException | IllegalArgumentException e) {\n               ConfigurableMain.LOGGER.warn(\"Field: \\\"%s\\\" of type \\\"%s\\\" could not be set to \\\"%s\\\". Falling back to default.\".formatted(keyPath, expected, value.toString()));\n            }\n        } catch (IllegalAccessException e) {\n            ConfigurableMain.LOGGER.error(\"Field: \\\"%s\\\" could not be set. Falling back to default\".formatted(keyPath), e);\n        }\n    }\n\n    private Object getRefValue(JsonPrimitive value, Class<?> expected) {\n        if(value == null) return null;\n\n        return GSON.getAdapter(expected).fromJsonTree(value);\n    }\n}\n";

    public ConfigLoaderGenerator(Filer filer, Types types, Messager messager, ConfigurableSettings settings) {
        super(filer, types, messager, settings);
    }

    public void generateConfigLoader() throws IOException {
        String spec = LOADER_SPEC;
        spec = this.applyReplacements(spec);
        JavaFileObject configLoader = this.filer.createSourceFile(this.settings.fullyQualifiedLoader(), new Element[0]);
        try (PrintWriter out = new PrintWriter(configLoader.openWriter());){
            out.println(spec);
        }
    }
}

