/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.level;

import com.google.common.collect.ImmutableList;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.network.S2CSeismicWaveFluidParticlesMessage;
import fuzs.mutantmonsters.services.CommonAbstractions;
import fuzs.mutantmonsters.world.level.ZombieResurrection;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2530;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3709;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class SeismicWave
extends class_2338 {
    private static final int MAX_SEISMIC_WAVES_PER_PLAYER = 64;
    private final boolean first;
    private final boolean affectsTerrain;

    public SeismicWave(int x, int y, int z, boolean first, boolean affectsTerrain) {
        super(x, y, z);
        this.first = first;
        this.affectsTerrain = affectsTerrain;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean affectsTerrain() {
        return this.affectsTerrain;
    }

    public static void createWaves(class_1937 world, List<SeismicWave> list, int x1, int z1, int x2, int z2, int y) {
        int deltaX = x2 - x1;
        int deltaZ = z2 - z1;
        int xStep = deltaX < 0 ? -1 : 1;
        int zStep = deltaZ < 0 ? -1 : 1;
        deltaX = Math.abs(deltaX);
        deltaZ = Math.abs(deltaZ);
        int x = x1;
        int z = z1;
        int deltaX2 = deltaX * 2;
        int deltaZ2 = deltaZ * 2;
        int firstY = ZombieResurrection.getSuitableGround(world, x1, y, z1, 3, false);
        SeismicWave wave = new SeismicWave(x1, y, z1, true, true);
        if (firstY != -1) {
            wave = new SeismicWave(x1, firstY, z1, true, true);
        }
        list.add(wave);
        if (deltaX2 >= deltaZ2) {
            int error = deltaX;
            for (int i = 0; i < deltaX; ++i) {
                x += xStep;
                if ((error += deltaZ2) > deltaX2) {
                    z += zStep;
                    error -= deltaX2;
                }
                SeismicWave.addWave(world, list, x, y, z);
            }
        } else {
            int error = deltaZ;
            for (int i = 0; i < deltaZ; ++i) {
                z += zStep;
                if ((error += deltaX2) > deltaZ2) {
                    x += xStep;
                    error -= deltaZ2;
                }
                SeismicWave.addWave(world, list, x, y, z);
            }
        }
    }

    @Nullable
    public static SeismicWave addWave(class_1937 world, List<SeismicWave> list, int x, int y, int z) {
        y = ZombieResurrection.getSuitableGround(world, x, y, z, 3, false);
        SeismicWave wave = null;
        if (y != -1) {
            wave = new SeismicWave(x, y, z, false, true);
            list.add(wave);
        }
        if (world.field_9229.method_43048(2) == 0) {
            list.add(new SeismicWave(x, y + 1, z, false, false));
        }
        return wave;
    }

    public void affectBlocks(class_1937 level, class_1297 entity) {
        if (this.affectsTerrain) {
            class_1657 playerEntity;
            class_2338 posAbove = this.method_10084();
            class_2680 blockstate = level.method_8320((class_2338)this);
            class_2248 block = blockstate.method_26204();
            class_1657 class_16572 = playerEntity = entity instanceof class_1657 ? (class_1657)entity : null;
            if (playerEntity != null && playerEntity.method_7294() || level.method_8450().method_8355(class_1928.field_19388)) {
                if (blockstate.method_27852(class_2246.field_10219) || blockstate.method_27852(class_2246.field_10194) || blockstate.method_27852(class_2246.field_10362) || blockstate.method_27852(class_2246.field_10520) || blockstate.method_27852(class_2246.field_10402)) {
                    level.method_8501((class_2338)this, class_2246.field_10566.method_9564());
                }
                class_2680 blockstateAbove = level.method_8320(posAbove);
                float hardness = blockstateAbove.method_26214((class_1922)level, posAbove);
                if (blockstateAbove.method_26220((class_1922)level, posAbove).method_1110() && hardness > -1.0f && hardness <= 1.0f) {
                    level.method_22352(posAbove, playerEntity != null);
                }
                if (block instanceof class_2323) {
                    if (class_2323.method_24796((class_2680)blockstate)) {
                        level.method_20290(1019, (class_2338)this, 0);
                    } else {
                        level.method_20290(1020, (class_2338)this, 0);
                    }
                }
                if (block instanceof class_2530) {
                    CommonAbstractions.INSTANCE.onBlockCaughtFire(block, blockstate, level, this, null, (class_1309)playerEntity);
                    level.method_8650((class_2338)this, false);
                }
            }
            if (block instanceof class_3709) {
                ((class_3709)block).method_19285(level, blockstate, new class_3965(class_243.method_24954((class_2382)this), entity.method_5735(), (class_2338)this, false), playerEntity, true);
            }
            if (blockstate.method_27852(class_2246.field_10080)) {
                block.method_9591(level, (class_2338)this, blockstate, entity);
            }
            if (blockstate.method_26227().method_15769()) {
                level.method_20290(2001, posAbove, class_2248.method_9507((class_2680)blockstate));
            } else {
                PlayerSet playerSet = PlayerSet.nearPosition(null, (double)((double)this.method_10263() + 0.5), (double)this.method_10264(), (double)((double)this.method_10260() + 0.5), (double)1024.0, (class_3218)((class_3218)entity.method_37908()));
                MutantMonsters.NETWORK.sendMessage(playerSet, new S2CSeismicWaveFluidParticlesMessage(this).toClientboundMessage());
            }
        }
    }

    public static void addAll(class_1657 player, Collection<SeismicWave> seismicWaves) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)ModRegistry.SEISMIC_WAVE_ATTACHMENT_TYPE.get((Object)player));
        builder.addAll(seismicWaves);
        ModRegistry.SEISMIC_WAVE_ATTACHMENT_TYPE.set((Object)player, (Object)builder.build());
    }

    public static SeismicWave poll(class_1657 player) {
        List seismicWaves = (List)ModRegistry.SEISMIC_WAVE_ATTACHMENT_TYPE.get((Object)player);
        if (seismicWaves.size() > 64) {
            seismicWaves = seismicWaves.subList(seismicWaves.size() - 64, seismicWaves.size());
        }
        if (!seismicWaves.isEmpty()) {
            SeismicWave seismicWave = (SeismicWave)((Object)seismicWaves.getFirst());
            seismicWaves = seismicWaves.subList(1, seismicWaves.size());
            ModRegistry.SEISMIC_WAVE_ATTACHMENT_TYPE.set((Object)player, (Object)ImmutableList.copyOf(seismicWaves));
            return seismicWave;
        }
        return null;
    }
}

