/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters;

import fuzs.mutantmonsters.config.CommonConfig;
import fuzs.mutantmonsters.config.ServerConfig;
import fuzs.mutantmonsters.handler.BiomeModificationsHandler;
import fuzs.mutantmonsters.handler.EntityEventsHandler;
import fuzs.mutantmonsters.handler.PlayerEventsHandler;
import fuzs.mutantmonsters.handler.SpawningPreventionHandler;
import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.network.S2CAddEntityDataMessage;
import fuzs.mutantmonsters.network.S2CAnimationMessage;
import fuzs.mutantmonsters.network.S2CMutantEndermanHeldBlockMessage;
import fuzs.mutantmonsters.network.S2CMutantLevelParticlesMessage;
import fuzs.mutantmonsters.network.S2CSeismicWaveFluidParticlesMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionNameMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionTrackerMessage;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.EndersoulClone;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import fuzs.mutantmonsters.world.entity.mutant.SpiderPig;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemEntityEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import fuzs.puzzleslib.api.event.v1.server.RegisterPotionBrewingMixesCallback;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import fuzs.puzzleslib.api.network.v3.NetworkHandler;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_1799;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_9169;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutantMonsters
implements ModConstructor {
    public static final String MOD_ID = "mutantmonsters";
    public static final String MOD_NAME = "Mutant Monsters";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mutant Monsters");
    public static final NetworkHandler NETWORK = NetworkHandler.builder((String)"mutantmonsters").registerLegacyServerbound(C2SCreeperMinionTrackerMessage.class, C2SCreeperMinionTrackerMessage::new).registerLegacyClientbound(S2CMutantLevelParticlesMessage.class, S2CMutantLevelParticlesMessage::new).registerLegacyClientbound(S2CAddEntityDataMessage.class, S2CAddEntityDataMessage::new).registerLegacyServerbound(C2SCreeperMinionNameMessage.class, C2SCreeperMinionNameMessage::new).registerLegacyClientbound(S2CAnimationMessage.class, S2CAnimationMessage::new).registerLegacyClientbound(S2CSeismicWaveFluidParticlesMessage.class, S2CSeismicWaveFluidParticlesMessage::new).registerLegacyClientbound(S2CMutantEndermanHeldBlockMessage.class, S2CMutantEndermanHeldBlockMessage::new);
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"mutantmonsters").common(CommonConfig.class).server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        MutantMonsters.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        LivingHurtCallback.EVENT.register(EntityEventsHandler::onLivingHurt);
        UseItemEvents.TICK.register(PlayerEventsHandler::onItemUseTick);
        ArrowLooseCallback.EVENT.register(PlayerEventsHandler::onArrowLoose);
        PlayerInteractEvents.USE_ENTITY.register(EntityEventsHandler::onEntityInteract);
        PlayerTickEvents.END.register(PlayerEventsHandler::onEndPlayerTick);
        ServerEntityLevelEvents.LOAD.register(EntityEventsHandler::onEntityLoad);
        LivingDropsCallback.EVENT.register(EntityEventsHandler::onLivingDrops);
        ItemEntityEvents.TOSS.register(PlayerEventsHandler::onItemToss);
        ServerEntityLevelEvents.SPAWN.register(SpawningPreventionHandler::onEntitySpawn);
        ExplosionEvents.DETONATE.register(MutatedExplosionHelper::onExplosionDetonate);
        RegisterPotionBrewingMixesCallback.EVENT.register(MutantMonsters::registerPotionRecipes);
    }

    private static void registerPotionRecipes(RegisterPotionBrewingMixesCallback.Builder builder) {
        builder.registerPotionRecipe(class_1847.field_8985, class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)ModItems.ENDERSOUL_HAND_ITEM.comp_349(), (class_1935)ModItems.HULK_HAMMER_ITEM.comp_349(), (class_1935)ModItems.CREEPER_SHARD_ITEM.comp_349(), (class_1935)ModItems.MUTANT_SKELETON_SKULL_ITEM.comp_349()}), ModRegistry.CHEMICAL_X_POTION);
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((class_1299)ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.comp_349(), CreeperMinion.registerAttributes());
        context.registerEntityAttributes((class_1299)ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.comp_349(), EndersoulClone.registerAttributes());
        context.registerEntityAttributes((class_1299)ModEntityTypes.MUTANT_CREEPER_ENTITY_TYPE.comp_349(), MutantCreeper.registerAttributes());
        context.registerEntityAttributes((class_1299)ModEntityTypes.MUTANT_ENDERMAN_ENTITY_TYPE.comp_349(), MutantEnderman.registerAttributes());
        context.registerEntityAttributes((class_1299)ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.comp_349(), MutantSnowGolem.registerAttributes());
        context.registerEntityAttributes((class_1299)ModEntityTypes.SPIDER_PIG_ENTITY_TYPE.comp_349(), SpiderPig.registerAttributes());
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isFabricLike()) {
            context.registerEntityAttributes((class_1299)ModEntityTypes.MUTANT_SKELETON_ENTITY_TYPE.comp_349(), MutantSkeleton.registerAttributes());
            context.registerEntityAttributes((class_1299)ModEntityTypes.MUTANT_ZOMBIE_ENTITY_TYPE.comp_349(), MutantZombie.registerAttributes());
        }
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((class_1299)ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_1308::method_20636);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.MUTANT_CREEPER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.MUTANT_ENDERMAN_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, MutantEnderman::canSpawn);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.MUTANT_SKELETON_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_1308::method_20636);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.MUTANT_ZOMBIE_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.SPIDER_PIG_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13197, class_1429::method_20663);
    }

    public void onRegisterBiomeModifications(BiomeModificationsContext context) {
        BiomeModificationsHandler.onRegisterBiomeModifications(context);
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID).icon(() -> new class_1799((class_1935)ModItems.ENDERSOUL_HAND_ITEM.comp_349())).displayItems((itemDisplayParameters, output) -> {
            output.method_45421((class_1935)ModItems.CREEPER_MINION_TRACKER_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.CREEPER_SHARD_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.ENDERSOUL_HAND_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.HULK_HAMMER_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_SKELETON_ARMS_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_SKELETON_LIMB_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_SKELETON_PELVIS_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_SKELETON_RIB_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_SKELETON_RIB_CAGE_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_SKELETON_SHOULDER_PAD_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_SKELETON_SKULL_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_SKELETON_CHESTPLATE_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_SKELETON_LEGGINGS_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_SKELETON_BOOTS_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.CREEPER_MINION_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_CREEPER_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_ENDERMAN_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_SKELETON_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_SNOW_GOLEM_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MUTANT_ZOMBIE_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.SPIDER_PIG_SPAWN_EGG_ITEM.comp_349());
        }).appendEnchantmentsAndPotions());
    }

    public ContentRegistrationFlags[] getContentRegistrationFlags() {
        return new ContentRegistrationFlags[]{ContentRegistrationFlags.BIOME_MODIFICATIONS};
    }

    public static class_2960 id(String name) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }
}

