/*
 * Decompiled with CFR 0.152.
 */
package com.Hileb.teampotato.redirectionor;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Locale;
import nilloader.api.ClassTransformer;
import nilloader.api.ModRemapper;
import nilloader.api.NilLogger;
import nilloader.api.lib.asm.ClassReader;
import nilloader.api.lib.asm.ClassVisitor;
import nilloader.api.lib.asm.ClassWriter;
import nilloader.api.lib.asm.tree.AbstractInsnNode;
import nilloader.api.lib.asm.tree.ClassNode;
import nilloader.api.lib.asm.tree.MethodNode;
import nilloader.api.lib.nanojson.JsonArray;
import nilloader.api.lib.nanojson.JsonObject;
import nilloader.api.lib.nanojson.JsonParser;
import nilloader.api.lib.nanojson.JsonParserException;
import nilloader.api.lib.nanojson.JsonWriter;

public class RedirectionorTransformer
implements ClassTransformer,
Runnable {
    public static final NilLogger LOGGER = NilLogger.get((String)"Redirectionor");
    public static File CONFIG_FILE = null;
    public static boolean generateConfigWhenCrash = true;
    public static boolean printTransformedClasses = false;
    public static boolean isBlock = true;
    public static HashSet<String> contains = new HashSet();
    public static HashSet<String> prefix = new HashSet();

    public RedirectionorTransformer() {
        RedirectionorTransformer.initConfig();
    }

    @Override
    public void run() {
        ModRemapper.setTargetMapping((String)"default");
        ClassTransformer.register((ClassTransformer)this);
    }

    public byte[] transform(String className, byte[] originalData) {
        try {
            if (!RedirectionorTransformer.isAvailable(className, originalData)) {
                return originalData;
            }
            ClassReader classReader = new ClassReader(originalData);
            ClassNode cn = new ClassNode();
            classReader.accept((ClassVisitor)cn, 0);
            for (MethodNode mn : cn.methods) {
                if (!"values".equals(mn.name) || !mn.desc.startsWith("()")) continue;
                ListIterator iterator = mn.instructions.iterator();
                while (iterator.hasNext()) {
                    AbstractInsnNode node = (AbstractInsnNode)iterator.next();
                    int code = node.getOpcode();
                    if (code == 178 || code == 176) continue;
                    iterator.remove();
                }
                if (printTransformedClasses) {
                    LOGGER.info("Redirectionor : " + className);
                }
                ClassWriter classWriter = new ClassWriter(classReader, 0);
                cn.accept((ClassVisitor)classWriter);
                return classWriter.toByteArray();
            }
            return originalData;
        }
        catch (Throwable ignore) {
            return originalData;
        }
    }

    public static boolean isEnum(byte[] clazz) {
        if (clazz == null || clazz.length < 8) {
            return false;
        }
        int constantsCount = RedirectionorTransformer.readUnsignedShort(clazz, 8);
        int passcount = 10;
        for (int i = 1; i < constantsCount; ++i) {
            int size = 0;
            switch (clazz[passcount]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i;
                    break;
                }
                case 1: {
                    size = 3 + RedirectionorTransformer.readUnsignedShort(clazz, passcount + 1);
                    break;
                }
                case 15: {
                    size = 4;
                    break;
                }
                default: {
                    size = 3;
                }
            }
            passcount += size;
        }
        return ((passcount = RedirectionorTransformer.readUnsignedShort(clazz, passcount)) & 0x4000) != 0;
    }

    public static int readUnsignedShort(byte[] b, int index) {
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    public static boolean decode(JsonObject jsonObject) {
        boolean rewrite = false;
        try {
            int i;
            int size;
            if (jsonObject.isBoolean("printTransformedClasses")) {
                printTransformedClasses = jsonObject.getBoolean("printTransformedClasses");
            } else {
                rewrite = true;
            }
            if (jsonObject.getString("type") != null) {
                isBlock = RedirectionorTransformer.setBlocking(jsonObject.getString("type"));
            } else {
                rewrite = true;
            }
            if (jsonObject.getArray("contains") != null) {
                JsonArray contains_ = jsonObject.getArray("contains");
                contains = new HashSet(contains_.size());
                size = contains_.size();
                for (i = 0; i < size; ++i) {
                    contains.add(contains_.getString(i));
                }
            } else {
                rewrite = true;
            }
            if (jsonObject.getArray("prefix") != null) {
                JsonArray prefix_ = jsonObject.getArray("prefix");
                prefix = new HashSet(prefix_.size());
                size = prefix_.size();
                for (i = 0; i < size; ++i) {
                    prefix.add(prefix_.getString(i));
                }
            } else {
                rewrite = true;
            }
            if (jsonObject.isBoolean("generateConfigWhenCrash")) {
                generateConfigWhenCrash = jsonObject.getBoolean("generateConfigWhenCrash");
            } else {
                rewrite = true;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not read the config", e);
        }
        return rewrite;
    }

    public static JsonObject encode() {
        JsonObject json = new JsonObject();
        json.put((Object)"printTransformedClasses", (Object)printTransformedClasses);
        json.put((Object)"type", (Object)(isBlock ? "block" : "allow"));
        JsonArray contains_ = new JsonArray(contains.size());
        contains_.addAll(contains);
        json.put((Object)"contains", (Object)contains_);
        JsonArray prefix_ = new JsonArray(prefix.size());
        prefix_.addAll(prefix);
        json.put((Object)"prefix", (Object)prefix_);
        json.put((Object)"generateConfigWhenCrash", (Object)generateConfigWhenCrash);
        return json;
    }

    public static void save() {
        try (PrintWriter pw = new PrintWriter(CONFIG_FILE, "UTF-8");){
            pw.println(JsonWriter.string((Object)RedirectionorTransformer.encode()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initConfig() {
        File file;
        if (CONFIG_FILE != null) return;
        File gameRunRoot = null;
        File config = new File(gameRunRoot, "config");
        if (!config.exists()) {
            config.mkdir();
        }
        CONFIG_FILE = file = new File(config, "redirectionor_cfg.json");
        if (file.exists()) {
            try {
                JsonObject jsonObject = (JsonObject)JsonParser.object().from(new String(Files.readAllBytes(file.toPath())));
                if (!RedirectionorTransformer.decode(jsonObject)) return;
                RedirectionorTransformer.save();
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read the config", e);
            }
            catch (JsonParserException e) {
                throw new RuntimeException("The Json is bad", e);
            }
        }
        try {
            file.createNewFile();
            RedirectionorTransformer.save();
            return;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create config file", e);
        }
    }

    public static boolean isAvailable(String name, byte[] datas) {
        return datas != null && RedirectionorTransformer.isEnum(datas) && isBlock != (RedirectionorTransformer.isPrefixed(name) || RedirectionorTransformer.isContained(name));
    }

    public static boolean isContained(String name) {
        for (String modid : contains) {
            if (!name.contains(modid)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrefixed(String name) {
        for (String modid : prefix) {
            if (!name.startsWith(modid)) continue;
            return true;
        }
        return false;
    }

    public static boolean setBlocking(String s) {
        if ("block".equals(s.toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        if ("allow".equals(s.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        throw new IllegalArgumentException("unknown type for config/redirectionor_cfg.json :" + s + " it should be \"block\" or \"allow\"");
    }
}

