/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.platform;

import com.bawnorton.neruina.platform.ModLoader;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.ModOrigin;

public final class Platform {
    public static Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static boolean isModLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    public static ModLoader getModLoader() {
        return ModLoader.FABRIC;
    }

    public static String modidFromJar(String jarName) {
        block4: for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            ModMetadata metadata = modContainer.getMetadata();
            ModOrigin origin = modContainer.getOrigin();
            switch (origin.getKind()) {
                case PATH: {
                    for (Path path : origin.getPaths()) {
                        if (!path.endsWith(jarName)) continue;
                        return metadata.getId();
                    }
                    continue block4;
                }
                case NESTED: {
                    String parentLocation = origin.getParentSubLocation();
                    if (parentLocation == null || !parentLocation.endsWith(jarName)) break;
                    return metadata.getId();
                }
            }
        }
        return null;
    }

    public static String getModVersion(String modid) {
        return FabricLoader.getInstance().getModContainer(modid).map(ModContainer::getMetadata).map(modMetadata -> modMetadata.getVersion().getFriendlyString()).orElse("unknown");
    }

    public static String getVersion() {
        return Platform.getModVersion("fabricloader");
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT);
    }
}

