/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.fabric.impl;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.common.api.registry.register.RegisterIngredient;
import net.darkhax.bookshelf.common.api.registry.register.RegisterVillagerTrades;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.BookshelfMod;
import net.darkhax.bookshelf.common.impl.Constants;
import net.darkhax.bookshelf.fabric.impl.data.FabricIngredient;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_3797;
import net.minecraft.class_3852;
import net.minecraft.class_3853;

public class FabricMod
implements ModInitializer {
    public void onInitialize() {
        BookshelfMod.getInstance().init();
        this.registerVillagerTrades();
        this.registerIngredientTypes();
        FabricMod.checkForUpdates();
    }

    private void registerIngredientTypes() {
        Services.CONTENT_PROVIDERS.get().forEach(provider -> {
            RegisterIngredient registry = new RegisterIngredient(provider.contentNamespace(), (id, codec, stream) -> CustomIngredientSerializer.register(FabricIngredient.make(id, codec, stream)));
            provider.registerIngredientTypes(registry);
        });
    }

    private void registerVillagerTrades() {
        List<class_3853.class_1652> rareTrades;
        RegisterVillagerTrades register = new RegisterVillagerTrades();
        Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerTrades(register));
        for (Map.Entry<class_3852, Multimap<Integer, class_3853.class_1652>> professionData : register.getVillagerTrades().entrySet()) {
            Int2ObjectMap professionTrades = class_3853.field_17067.computeIfAbsent(professionData.getKey(), profession -> new Int2ObjectOpenHashMap());
            Iterator iterator = professionData.getValue().keySet().iterator();
            while (iterator.hasNext()) {
                int merchantTier = (Integer)iterator.next();
                ArrayList<class_3853.class_1652> tradesForTier = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])professionTrades.getOrDefault(merchantTier, (Object)new class_3853.class_1652[0])));
                tradesForTier.addAll(professionData.getValue().get((Object)merchantTier));
                professionTrades.put(merchantTier, (Object)tradesForTier.toArray(new class_3853.class_1652[0]));
            }
        }
        List<class_3853.class_1652> commonTrades = register.getCommonWanderingTrades();
        if (!commonTrades.isEmpty()) {
            ArrayList<class_3853.class_1652> tradeData = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])class_3853.field_17724.get(1)));
            tradeData.addAll(commonTrades);
            class_3853.field_17724.put(1, (Object)tradeData.toArray(new class_3853.class_1652[0]));
        }
        if (!(rareTrades = register.getRareWanderingTrades()).isEmpty()) {
            ArrayList<class_3853.class_1652> tradeData = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])class_3853.field_17724.get(2)));
            tradeData.addAll(rareTrades);
            class_3853.field_17724.put(2, (Object)tradeData.toArray(new class_3853.class_1652[0]));
        }
    }

    private static void checkForUpdates() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://updates.blamejared.com/get?n=bookshelf&gv=" + class_3797.field_25319.method_48019() + "&ml=fabric").openConnection();
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                Constants.LOG.warn("Version checker is not available.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

