/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.animation.controller.keyframe;

import java.util.Map;
import java.util.NoSuchElementException;
import mod.azure.azurelibarmor.core.math.IValue;
import mod.azure.azurelibarmor.core.molang.MolangParser;
import mod.azure.azurelibarmor.core.molang.MolangQueries;
import mod.azure.azurelibarmor.core.object.Axis;
import mod.azure.azurelibarmor.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelibarmor.rewrite.animation.controller.AzBoneAnimationQueueCache;
import mod.azure.azurelibarmor.rewrite.animation.controller.AzBoneSnapshotCache;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzAbstractKeyframeExecutor;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzAnimationPoint;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzBoneAnimation;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzBoneAnimationQueue;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzKeyframe;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzKeyframeStack;
import mod.azure.azurelibarmor.rewrite.animation.primitive.AzQueuedAnimation;
import mod.azure.azurelibarmor.rewrite.model.AzBone;
import mod.azure.azurelibarmor.rewrite.model.AzBoneSnapshot;

public class AzKeyframeTransitioner<T>
extends AzAbstractKeyframeExecutor {
    private final AzAnimationController<T> animationController;
    private final AzBoneAnimationQueueCache<T> boneAnimationQueueCache;
    private final AzBoneSnapshotCache boneSnapshotCache;

    public AzKeyframeTransitioner(AzAnimationController<T> animationController, AzBoneAnimationQueueCache<T> boneAnimationQueueCache, AzBoneSnapshotCache boneSnapshotCache) {
        this.animationController = animationController;
        this.boneAnimationQueueCache = boneAnimationQueueCache;
        this.boneSnapshotCache = boneSnapshotCache;
    }

    public void transition(Map<String, AzBone> bones, boolean crashWhenCantFindBone, double adjustedTick) {
        AzQueuedAnimation currentAnimation = this.animationController.currentAnimation();
        float transitionLength = this.animationController.animationProperties().transitionLength();
        MolangParser.INSTANCE.setValue(MolangQueries.ANIM_TIME, () -> 0.0);
        for (AzBoneAnimation boneAnimation : currentAnimation.animation().boneAnimations()) {
            AzBone bone = bones.get(boneAnimation.boneName());
            if (bone == null) {
                if (!crashWhenCantFindBone) continue;
                throw new NoSuchElementException("Could not find bone: " + boneAnimation.boneName());
            }
            AzBoneAnimationQueue queue = this.boneAnimationQueueCache.getOrNull(boneAnimation.boneName());
            AzBoneSnapshot snapshot = this.boneSnapshotCache.getOrNull(boneAnimation.boneName());
            AzKeyframeStack<AzKeyframe<IValue>> rotationKeyframes = boneAnimation.rotationKeyframes();
            AzKeyframeStack<AzKeyframe<IValue>> positionKeyframes = boneAnimation.positionKeyframes();
            AzKeyframeStack<AzKeyframe<IValue>> scaleKeyframes = boneAnimation.scaleKeyframes();
            this.transitionRotation(adjustedTick, rotationKeyframes, queue, transitionLength, snapshot, bone);
            this.transitionPosition(adjustedTick, positionKeyframes, queue, transitionLength, snapshot);
            this.transitionScale(adjustedTick, scaleKeyframes, queue, transitionLength, snapshot);
        }
    }

    private void transitionRotation(double adjustedTick, AzKeyframeStack<AzKeyframe<IValue>> keyframes, AzBoneAnimationQueue queue, double transitionLength, AzBoneSnapshot snapshot, AzBone bone) {
        if (keyframes.xKeyframes().isEmpty()) {
            return;
        }
        AzBoneSnapshot initialSnapshot = bone.getInitialAzSnapshot();
        AzAnimationPoint x = this.getAnimationPointAtTick(keyframes.xKeyframes(), 0.0, true, Axis.X);
        AzAnimationPoint y = this.getAnimationPointAtTick(keyframes.yKeyframes(), 0.0, true, Axis.Y);
        AzAnimationPoint z = this.getAnimationPointAtTick(keyframes.zKeyframes(), 0.0, true, Axis.Z);
        queue.addNextRotation(null, adjustedTick, transitionLength, snapshot, initialSnapshot, x, y, z);
    }

    private void transitionPosition(double adjustedTick, AzKeyframeStack<AzKeyframe<IValue>> keyframes, AzBoneAnimationQueue queue, double transitionLength, AzBoneSnapshot snapshot) {
        if (keyframes.xKeyframes().isEmpty()) {
            return;
        }
        AzAnimationPoint x = this.getAnimationPointAtTick(keyframes.xKeyframes(), 0.0, false, Axis.X);
        AzAnimationPoint y = this.getAnimationPointAtTick(keyframes.yKeyframes(), 0.0, false, Axis.Y);
        AzAnimationPoint z = this.getAnimationPointAtTick(keyframes.zKeyframes(), 0.0, false, Axis.Z);
        queue.addNextPosition(null, adjustedTick, transitionLength, snapshot, x, y, z);
    }

    private void transitionScale(double adjustedTick, AzKeyframeStack<AzKeyframe<IValue>> keyframes, AzBoneAnimationQueue queue, double transitionLength, AzBoneSnapshot snapshot) {
        if (keyframes.xKeyframes().isEmpty()) {
            return;
        }
        AzAnimationPoint x = this.getAnimationPointAtTick(keyframes.xKeyframes(), 0.0, false, Axis.X);
        AzAnimationPoint y = this.getAnimationPointAtTick(keyframes.yKeyframes(), 0.0, false, Axis.Y);
        AzAnimationPoint z = this.getAnimationPointAtTick(keyframes.zKeyframes(), 0.0, false, Axis.Z);
        queue.addNextScale(null, adjustedTick, transitionLength, snapshot, x, y, z);
    }
}

