/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.animation.controller.keyframe;

import java.util.NoSuchElementException;
import mod.azure.azurelibarmor.core.math.IValue;
import mod.azure.azurelibarmor.core.molang.MolangParser;
import mod.azure.azurelibarmor.core.molang.MolangQueries;
import mod.azure.azurelibarmor.core.object.Axis;
import mod.azure.azurelibarmor.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelibarmor.rewrite.animation.controller.AzAnimationControllerTimer;
import mod.azure.azurelibarmor.rewrite.animation.controller.AzBoneAnimationQueueCache;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzAbstractKeyframeExecutor;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzAnimationPoint;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzBoneAnimation;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzBoneAnimationQueue;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzKeyframe;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzKeyframeCallbackHandler;
import mod.azure.azurelibarmor.rewrite.animation.controller.keyframe.AzKeyframeStack;
import mod.azure.azurelibarmor.rewrite.animation.primitive.AzQueuedAnimation;
import org.jetbrains.annotations.NotNull;

public class AzKeyframeExecutor<T>
extends AzAbstractKeyframeExecutor {
    private final AzAnimationController<T> animationController;
    private final AzBoneAnimationQueueCache<T> boneAnimationQueueCache;

    public AzKeyframeExecutor(AzAnimationController<T> animationController, AzBoneAnimationQueueCache<T> boneAnimationQueueCache) {
        this.animationController = animationController;
        this.boneAnimationQueueCache = boneAnimationQueueCache;
    }

    public void execute(@NotNull AzQueuedAnimation currentAnimation, T animatable, boolean crashWhenCantFindBone) {
        AzKeyframeCallbackHandler<T> keyframeCallbackHandler = this.animationController.keyframeManager().keyframeCallbackHandler();
        AzAnimationControllerTimer<T> controllerTimer = this.animationController.controllerTimer();
        float transitionLength = this.animationController.animationProperties().transitionLength();
        double finalAdjustedTick = controllerTimer.getAdjustedTick();
        MolangParser.INSTANCE.setMemoizedValue(MolangQueries.ANIM_TIME, () -> finalAdjustedTick / 20.0);
        for (AzBoneAnimation boneAnimation : currentAnimation.animation().boneAnimations()) {
            AzBoneAnimationQueue boneAnimationQueue = this.boneAnimationQueueCache.getOrNull(boneAnimation.boneName());
            if (boneAnimationQueue == null) {
                if (!crashWhenCantFindBone) continue;
                throw new NoSuchElementException("Could not find bone: " + boneAnimation.boneName());
            }
            AzKeyframeStack<AzKeyframe<IValue>> rotationKeyframes = boneAnimation.rotationKeyframes();
            AzKeyframeStack<AzKeyframe<IValue>> positionKeyframes = boneAnimation.positionKeyframes();
            AzKeyframeStack<AzKeyframe<IValue>> scaleKeyframes = boneAnimation.scaleKeyframes();
            double adjustedTick = controllerTimer.getAdjustedTick();
            this.updateRotation(rotationKeyframes, boneAnimationQueue, adjustedTick);
            this.updatePosition(positionKeyframes, boneAnimationQueue, adjustedTick);
            this.updateScale(scaleKeyframes, boneAnimationQueue, adjustedTick);
        }
        controllerTimer.addToAdjustedTick(transitionLength);
        keyframeCallbackHandler.handle(animatable, controllerTimer.getAdjustedTick());
    }

    private void updateRotation(AzKeyframeStack<AzKeyframe<IValue>> keyframes, AzBoneAnimationQueue queue, double adjustedTick) {
        if (keyframes.xKeyframes().isEmpty()) {
            return;
        }
        AzAnimationPoint x = this.getAnimationPointAtTick(keyframes.xKeyframes(), adjustedTick, true, Axis.X);
        AzAnimationPoint y = this.getAnimationPointAtTick(keyframes.yKeyframes(), adjustedTick, true, Axis.Y);
        AzAnimationPoint z = this.getAnimationPointAtTick(keyframes.zKeyframes(), adjustedTick, true, Axis.Z);
        queue.addRotations(x, y, z);
    }

    private void updatePosition(AzKeyframeStack<AzKeyframe<IValue>> keyframes, AzBoneAnimationQueue queue, double adjustedTick) {
        if (keyframes.xKeyframes().isEmpty()) {
            return;
        }
        AzAnimationPoint x = this.getAnimationPointAtTick(keyframes.xKeyframes(), adjustedTick, false, Axis.X);
        AzAnimationPoint y = this.getAnimationPointAtTick(keyframes.yKeyframes(), adjustedTick, false, Axis.Y);
        AzAnimationPoint z = this.getAnimationPointAtTick(keyframes.zKeyframes(), adjustedTick, false, Axis.Z);
        queue.addPositions(x, y, z);
    }

    private void updateScale(AzKeyframeStack<AzKeyframe<IValue>> keyframes, AzBoneAnimationQueue queue, double adjustedTick) {
        if (keyframes.xKeyframes().isEmpty()) {
            return;
        }
        AzAnimationPoint x = this.getAnimationPointAtTick(keyframes.xKeyframes(), adjustedTick, false, Axis.X);
        AzAnimationPoint y = this.getAnimationPointAtTick(keyframes.yKeyframes(), adjustedTick, false, Axis.Y);
        AzAnimationPoint z = this.getAnimationPointAtTick(keyframes.zKeyframes(), adjustedTick, false, Axis.Z);
        queue.addScales(x, y, z);
    }
}

