/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.animation.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import mod.azure.azurelibarmor.rewrite.animation.AzAnimationContext;
import mod.azure.azurelibarmor.rewrite.animation.AzAnimationTimer;
import mod.azure.azurelibarmor.rewrite.animation.AzAnimatorConfig;
import mod.azure.azurelibarmor.rewrite.animation.AzCachedBoneUpdateUtil;
import mod.azure.azurelibarmor.rewrite.model.AzBakedModel;
import mod.azure.azurelibarmor.rewrite.model.AzBone;
import mod.azure.azurelibarmor.rewrite.model.AzBoneSnapshot;

public class AzBoneCache {
    private AzBakedModel bakedModel = AzBakedModel.EMPTY;
    private final Map<String, AzBoneSnapshot> boneSnapshotsByName = new Object2ObjectOpenHashMap();

    public boolean setActiveModel(AzBakedModel model) {
        boolean willModelChange = !Objects.equals(this.bakedModel, model);
        this.bakedModel = model;
        if (willModelChange) {
            this.snapshot();
        }
        return willModelChange;
    }

    public void update(AzAnimationContext<?> context) {
        AzAnimatorConfig config = context.config();
        AzAnimationTimer timer = context.timer();
        double animTime = timer.getAnimTime();
        Map<String, AzBoneSnapshot> boneSnapshots = this.getBoneSnapshotsByName();
        double resetTickLength = config.boneResetTime();
        for (AzBone bone : this.bakedModel.getBonesByName().values()) {
            AzCachedBoneUpdateUtil.updateCachedBoneRotation(bone, boneSnapshots, animTime, resetTickLength);
            AzCachedBoneUpdateUtil.updateCachedBonePosition(bone, boneSnapshots, animTime, resetTickLength);
            AzCachedBoneUpdateUtil.updateCachedBoneScale(bone, boneSnapshots, animTime, resetTickLength);
        }
        this.resetBoneTransformationMarkers();
    }

    private void resetBoneTransformationMarkers() {
        this.bakedModel.getBonesByName().values().forEach(AzBone::resetStateChanges);
    }

    private void snapshot() {
        this.boneSnapshotsByName.clear();
        for (AzBone bone : this.bakedModel.getBonesByName().values()) {
            this.boneSnapshotsByName.put(bone.getName(), AzBoneSnapshot.copy(bone.getInitialAzSnapshot()));
        }
    }

    public AzBakedModel getBakedModel() {
        return this.bakedModel;
    }

    public Map<String, AzBoneSnapshot> getBoneSnapshotsByName() {
        return this.boneSnapshotsByName;
    }

    public boolean isEmpty() {
        return this.bakedModel.getBonesByName().isEmpty();
    }
}

