/*
 * Decompiled with CFR 0.152.
 */
package com.ecarrascon.carrasconlib.config;

import com.ecarrascon.carrasconlib.GetConfigDir;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.logging.log4j.Logger;

public class LibConfig<T> {
    private final File configFile;
    private T instance;
    private final Class<T> configClass;
    private final Logger logger;
    private final Gson gson;

    public LibConfig(String fileName, Class<T> configClass, Logger logger) {
        this.configFile = new File(GetConfigDir.getConfigDirectory().toFile(), fileName);
        this.configClass = configClass;
        this.logger = logger;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.init();
    }

    private void init() {
        if (!this.configFile.exists()) {
            try {
                this.instance = this.configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.save();
            }
            catch (Exception e) {
                this.logger.error("Failed to create default configuration instance: {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            try (BufferedReader reader = Files.newBufferedReader(this.configFile.toPath());){
                this.instance = this.gson.fromJson((Reader)reader, this.configClass);
            }
            catch (IOException e) {
                this.logger.error("Failed to load configuration file: {}. Using default configuration.", (Object)e.getMessage(), (Object)e);
                try {
                    this.instance = this.configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    this.logger.error("Failed to create default configuration instance: {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
    }

    public T get() {
        return this.instance;
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.configFile.toPath(), new OpenOption[0]);){
            this.gson.toJson(this.instance, (Appendable)writer);
        }
        catch (IOException e) {
            this.logger.error("Error saving configuration file: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

