/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1074;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaxNumberPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public MaxNumberPlaceholder() {
        super("maxnum");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String firstNumber = dps.values.get("first");
        String secondNumber = dps.values.get("second");
        if (firstNumber != null && secondNumber != null) {
            try {
                if (MathUtils.isDouble((String)firstNumber) && MathUtils.isDouble((String)secondNumber)) {
                    double second;
                    double first = Double.parseDouble(firstNumber);
                    return Math.max(first, second = Double.parseDouble(secondNumber)) == first ? firstNumber : secondNumber;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        LOGGER.error("[FANCYMENU] Failed to parse 'Max Number' placeholder: " + dps.placeholderString);
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("first");
        l.add("second");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.placeholders.max_number", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.max_number.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("first", "10");
        values.put("second", "15");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

