/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.gameintro;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenStartingEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ScreenRenderUtils;
import de.keksuccino.fancymenu.util.resource.PlayableResource;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4071;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GameIntroOverlay
extends class_4071 {
    private static final Logger LOGGER = LogManager.getLogger();
    protected class_327 font;
    @NotNull
    protected class_437 fadeTo;
    protected PlayableResource intro;
    protected float opacity;
    protected long start;
    protected boolean fadeToInitialized;
    protected int width;
    protected int height;

    public GameIntroOverlay(@NotNull class_437 fadeTo, @NotNull PlayableResource intro) {
        this.font = class_310.method_1551().field_1772;
        this.opacity = 1.0f;
        this.start = -1L;
        this.fadeToInitialized = false;
        this.fadeTo = Objects.requireNonNull(fadeTo);
        this.intro = Objects.requireNonNull(intro);
        this.intro.waitForReady(5000L);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.width = class_310.method_1551().method_22683().method_4486();
        this.height = class_310.method_1551().method_22683().method_4502();
        if (this.start == -1L) {
            this.start = System.currentTimeMillis();
            this.intro.stop();
            this.intro.play();
        }
        if (this.endOfIntroReached() && !this.fadeToInitialized) {
            this.initFadeToScreen();
        }
        this.tickFadeOut();
        if (this.endOfIntroReached() && (!this.fadeOutIntro() || this.opacity < 0.1f)) {
            this.close();
            return;
        }
        if (this.endOfIntroReached()) {
            ScreenRenderUtils.executeAllPreRenderTasks(graphics, mouseX, mouseY, partial);
            EventHandler.INSTANCE.postEvent(new RenderScreenEvent.Pre(this.fadeTo, graphics, mouseX, mouseY, partial));
            this.fadeTo.method_25394(graphics, mouseX, mouseY, partial);
            EventHandler.INSTANCE.postEvent(new RenderScreenEvent.Post(this.fadeTo, graphics, mouseX, mouseY, partial));
            ScreenRenderUtils.executeAllPostRenderTasks(graphics, mouseX, mouseY, partial);
        } else {
            graphics.method_25294(0, 0, this.width, this.height, DrawableColor.BLACK.getColorInt());
        }
        RenderingUtils.resetShaderColor(graphics);
        this.renderIntro(graphics, mouseX, mouseY, partial);
        this.renderSkipText(graphics, mouseX, mouseY, partial);
    }

    protected void renderIntro(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        PlayableResource playableResource = this.intro;
        if (playableResource instanceof RenderableResource) {
            RenderableResource r = (RenderableResource)((Object)playableResource);
            AspectRatio ratio = r.getAspectRatio();
            int[] size = ratio.getAspectRatioSizeByMinimumSize(this.width, this.height);
            int aspectWidth = size[0];
            int aspectHeight = size[1];
            int x = this.width / 2 - aspectWidth / 2;
            int y = this.height / 2 - aspectHeight / 2;
            class_2960 location = r.getResourceLocation();
            if (location != null) {
                RenderSystem.enableBlend();
                graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
                graphics.method_25290(location, x, y, 0.0f, 0.0f, aspectWidth, aspectHeight, aspectWidth, aspectHeight);
            }
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    protected void renderSkipText(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (FancyMenu.getOptions().gameIntroAllowSkip.getValue().booleanValue()) {
            float scale = 1.3f;
            String customSkipText = FancyMenu.getOptions().gameIntroCustomSkipText.getValue();
            if (!customSkipText.isEmpty() && LocalizationUtils.isLocalizationKey(customSkipText)) {
                customSkipText = class_1074.method_4662((String)customSkipText, (Object[])new Object[0]);
            }
            class_5250 skipComp = customSkipText.isEmpty() ? class_2561.method_43471((String)"fancymenu.game_intro.press_any_key") : class_2561.method_43470((String)customSkipText);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22905(scale, scale, scale);
            RenderSystem.enableBlend();
            RenderingUtils.resetShaderColor(graphics);
            int normalizedWidth = (int)((float)this.width / scale);
            int normalizedHeight = (int)((float)this.height / scale);
            int textX = normalizedWidth / 2 - this.font.method_27525((class_5348)skipComp) / 2;
            int textY = normalizedHeight - 40;
            graphics.method_51439(this.font, (class_2561)skipComp, textX, textY, RenderingUtils.replaceAlphaInColor(DrawableColor.WHITE.getColorInt(), Math.max(0.1f, 0.6f * this.opacity)), false);
            graphics.method_51448().method_22909();
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    protected boolean fadeOutIntro() {
        return FancyMenu.getOptions().gameIntroFadeOut.getValue();
    }

    protected boolean endOfIntroReached() {
        if (this.start == -1L) {
            return false;
        }
        long now = System.currentTimeMillis();
        return this.start + 2000L < now && !this.intro.isPlaying();
    }

    protected void tickFadeOut() {
        if (this.endOfIntroReached() && this.fadeOutIntro()) {
            this.opacity -= 0.02f;
        }
    }

    protected void initFadeToScreen() {
        ScreenCustomization.setIsNewMenu(true);
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(this.fadeTo);
        if (layer != null) {
            layer.resetLayer();
        }
        EventHandler.INSTANCE.postEvent(new InitOrResizeScreenStartingEvent(this.fadeTo, InitOrResizeScreenEvent.InitializationPhase.INIT));
        EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Pre(this.fadeTo, InitOrResizeScreenEvent.InitializationPhase.INIT));
        this.fadeTo.method_25423(class_310.method_1551(), class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());
        EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Post(this.fadeTo, InitOrResizeScreenEvent.InitializationPhase.INIT));
        EventHandler.INSTANCE.postEvent(new InitOrResizeScreenCompletedEvent(this.fadeTo, InitOrResizeScreenEvent.InitializationPhase.INIT));
        this.fadeToInitialized = true;
    }

    protected void close() {
        if (!this.fadeToInitialized) {
            this.initFadeToScreen();
        }
        class_310.method_1551().method_18502(null);
    }

    public void keyPressed(int keycode, int scancode, int modifiers) {
        if (FancyMenu.getOptions().gameIntroAllowSkip.getValue().booleanValue()) {
            this.close();
        }
    }

    public void mouseClicked(int button) {
        if (FancyMenu.getOptions().gameIntroAllowSkip.getValue().booleanValue()) {
            this.close();
        }
    }
}

