/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.animationcontroller;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerHandler;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationKeyframe;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class AnimationControllerElement
extends AbstractElement {
    @NotNull
    public List<AnimationKeyframe> keyframes = new ArrayList<AnimationKeyframe>();
    @NotNull
    public List<TargetElement> targetElements = new ArrayList<TargetElement>();
    public boolean loop = false;
    public boolean offsetMode = false;
    public boolean ignoreSize = false;
    public boolean ignorePosition = false;

    public AnimationControllerElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (AnimationControllerElement.isEditor()) {
            if (this.shouldRender()) {
                int x = this.getAbsoluteX();
                int y = this.getAbsoluteY();
                int w = this.getAbsoluteWidth();
                int h = this.getAbsoluteHeight();
                RenderSystem.enableBlend();
                graphics.method_51739(class_1921.method_51785(), x, y, x + w, y + h, this.inEditorColor.getColorInt());
                graphics.method_44379(x, y, x + w, y + h);
                class_327 class_3272 = class_310.method_1551().field_1772;
                class_2561 class_25612 = this.getDisplayName();
                int n = x + w / 2;
                int n2 = y + h / 2;
                Objects.requireNonNull(class_310.method_1551().field_1772);
                graphics.method_27534(class_3272, class_25612, n, n2 - 9 / 2, -1);
                graphics.method_44380();
            }
        } else {
            this.targetElements.forEach(targetElement -> {
                if (this.shouldRender()) {
                    if (AnimationControllerHandler.wasAnimatedInThePast(targetElement.targetElementId) && AnimationControllerHandler.isFinished(targetElement.targetElementId) && !AnimationControllerHandler.isAnimating(targetElement.targetElementId)) {
                        targetElement.animationApplied = true;
                    } else {
                        AbstractElement target;
                        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getActiveLayer();
                        if (layer != null && (target = layer.getElementByInstanceIdentifier(targetElement.targetElementId)) != null) {
                            targetElement.animationApplied = AnimationControllerHandler.applyAnimation(this, target);
                        }
                    }
                } else if (AnimationControllerHandler.wasAnimatedInThePast(targetElement.targetElementId) && !AnimationControllerHandler.isFinished(targetElement.targetElementId)) {
                    targetElement.animationApplied = false;
                }
            });
        }
    }

    public List<AnimationKeyframe> getKeyframes() {
        return new ArrayList<AnimationKeyframe>(this.keyframes);
    }

    public static class TargetElement {
        public String targetElementId;
        public boolean animationApplied = false;

        public TargetElement() {
        }

        public TargetElement(String targetElementId) {
            this.targetElementId = targetElementId;
        }
    }
}

