/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.handler;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.visualworkbench.handler.BlockConversionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_773;
import org.jetbrains.annotations.Nullable;

public class BlockModelHandler {
    private static final Supplier<Map<class_1091, class_1091>> MODEL_LOCATIONS = Suppliers.memoize(() -> (Map)BlockConversionHandler.getBlockConversions().entrySet().stream().flatMap(entry -> BlockModelHandler.convertAllBlockStates((class_2248)entry.getValue(), (class_2248)entry.getKey()).entrySet().stream()).collect(class_156.method_664()));

    public static void onLoadComplete() {
        for (Map.Entry entry : BlockConversionHandler.getBlockConversions().entrySet()) {
            class_1921 renderType = ClientAbstractions.INSTANCE.getRenderType((class_2248)entry.getKey());
            ClientAbstractions.INSTANCE.registerRenderType((class_2248)entry.getValue(), renderType);
        }
    }

    public static EventResultHolder<class_1100> onModifyUnbakedModel(class_1091 modelLocation, Supplier<class_1100> unbakedModel, Function<class_1091, class_1100> modelGetter, BiConsumer<class_2960, class_1100> modelAdder) {
        if (MODEL_LOCATIONS.get().containsKey(modelLocation)) {
            return EventResultHolder.interrupt((Object)modelGetter.apply(MODEL_LOCATIONS.get().get(modelLocation)));
        }
        return EventResultHolder.pass();
    }

    private static Map<class_1091, class_1091> convertAllBlockStates(class_2248 oldBlock, class_2248 newBlock) {
        HashMap modelLocations = Maps.newHashMap();
        for (class_2680 oldBlockState : oldBlock.method_9595().method_11662()) {
            class_2680 newBlockState = BlockModelHandler.convertBlockState((class_2689<class_2248, class_2680>)newBlock.method_9595(), oldBlockState);
            modelLocations.put(class_773.method_3340((class_2680)oldBlockState), class_773.method_3340((class_2680)newBlockState));
        }
        return modelLocations;
    }

    private static class_2680 convertBlockState(class_2689<class_2248, class_2680> newStateDefinition, class_2680 oldBlockState) {
        class_2680 newBlockState = (class_2680)newStateDefinition.method_11664();
        for (Map.Entry entry : oldBlockState.method_11656().entrySet()) {
            newBlockState = BlockModelHandler.setBlockStateValue((class_2769)entry.getKey(), (Comparable)entry.getValue(), arg_0 -> newStateDefinition.method_11663(arg_0), newBlockState);
        }
        return newBlockState;
    }

    private static <T extends Comparable<T>, V extends T> class_2680 setBlockStateValue(class_2769<?> oldProperty, Comparable<?> oldValue, Function<String, @Nullable class_2769<?>> propertyGetter, class_2680 blockState) {
        class_2769<?> newProperty = propertyGetter.apply(oldProperty.method_11899());
        if (newProperty != null) {
            return (class_2680)blockState.method_11657(newProperty, oldValue);
        }
        return blockState;
    }
}

