/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ChatUtil {
    public static class_5250 createFormattedMessage(String prefix, String message, class_124 ... format) {
        String finalMessage = (prefix != null ? prefix : "") + message;
        return class_2561.method_43470((String)finalMessage).method_27695(format);
    }

    public static class_5250 createFormattedTranslatableMessage(String prefix, String translationKey, Object[] args, class_124 ... format) {
        String finalPrefix = prefix != null ? prefix : "";
        class_5250 translatableMessage = class_2561.method_43469((String)translationKey, (Object[])args);
        return class_2561.method_43470((String)finalPrefix).method_10852((class_2561)translatableMessage).method_27695(format);
    }

    public static void sendChatMessage(class_1657 player, class_5250 message) {
        if (player.method_37908().field_9236) {
            player.method_43496((class_2561)message);
        }
    }

    public static void sendChatMessage(class_1657 player, String prefix, String message, class_124 ... format) {
        ChatUtil.sendChatMessage(player, ChatUtil.createFormattedMessage(prefix, message, format));
    }

    public static void addServerChatMessage(class_1657 player, class_2561 message) {
        if (!player.method_37908().field_9236) {
            player.method_43496(message);
        }
    }

    public static void addServerChatMessage(class_1657 player, String prefix, String message, class_124 ... format) {
        ChatUtil.addServerChatMessage(player, (class_2561)ChatUtil.createFormattedMessage(prefix, message, format));
    }

    public static String blockPosToString(class_2338 pos) {
        return pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260();
    }

    public static void sendStatusMessage(class_1657 player, String prefix, String message, class_124 ... format) {
        player.method_7353((class_2561)ChatUtil.createFormattedMessage(prefix, message, format), true);
    }

    public static void sendFeedback(CommandContext<class_2168> context, String prefix, String message, class_124 ... format) {
        ((class_2168)context.getSource()).method_9226(() -> ChatUtil.createFormattedMessage(prefix, message, format), false);
    }

    public static void sendColoredMessage(class_1657 player, String message, class_124 color) {
        class_5250 coloredMessage = ChatUtil.createFormattedMessage("", message, new class_124[0]).method_27692(color);
        player.method_43496((class_2561)coloredMessage);
    }

    public static void sendErrorMessage(class_1657 player, String message) {
        ChatUtil.sendColoredMessage(player, message, class_124.field_1061);
    }

    public static void sendSuccessMessage(class_1657 player, String message) {
        ChatUtil.sendColoredMessage(player, message, class_124.field_1060);
    }

    public static void sendWarningMessage(class_1657 player, String message) {
        ChatUtil.sendColoredMessage(player, message, class_124.field_1054);
    }

    public static void broadcastMessage(Iterable<class_1657> players, String message) {
        for (class_1657 player : players) {
            ChatUtil.sendChatMessage(player, "", message, new class_124[0]);
        }
    }

    public static void broadcastServerMessage(Iterable<class_1657> players, String message) {
        for (class_1657 player : players) {
            ChatUtil.addServerChatMessage(player, "", message, new class_124[0]);
        }
    }

    public static void broadcastFormattedMessage(Iterable<class_1657> players, String prefix, String message, class_124 ... format) {
        for (class_1657 player : players) {
            ChatUtil.addServerChatMessage(player, prefix, message, format);
        }
    }

    public static void sendPositionalMessage(class_1657 player, String prefix, class_2338 pos) {
        String posString = ChatUtil.blockPosToString(pos);
        ChatUtil.sendChatMessage(player, prefix, "Position: " + posString, class_124.field_1080);
    }

    public static void logMessageToConsole(String prefix, String message, class_124 formatting) {
        class_5250 consoleMessage = ChatUtil.createFormattedMessage(prefix, message, formatting);
        System.out.println(consoleMessage.getString());
    }
}

