/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.records;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_2338;

public record PlayerProfileData(UUID playerId, String playerName, int level, double experience, double health, double maxHealth, double armor, List<class_1799> inventory, class_2338 lastKnownPosition, List<String> achievements) {
    public double getExperienceProgress() {
        int expForCurrentLevel = this.getXpForLevel(this.level);
        int expForNextLevel = this.getXpForLevel(this.level + 1);
        return (this.experience - (double)expForCurrentLevel) / (double)(expForNextLevel - expForCurrentLevel);
    }

    public boolean hasAchievement(String achievement) {
        return this.achievements.contains(achievement);
    }

    public void addAchievement(String achievement) {
        if (!this.hasAchievement(achievement)) {
            this.achievements.add(achievement);
        }
    }

    public int getItemCount(String itemName) {
        return this.inventory.stream().filter(itemStack -> itemStack.method_7909().method_8389().toString().equals(itemName)).mapToInt(class_1799::method_7947).sum();
    }

    public double calculateArmorRating() {
        return this.armor + this.inventory.stream().filter(itemStack -> itemStack.method_7909() instanceof class_1738).mapToDouble(itemStack -> ((class_1738)itemStack.method_7909()).method_7687()).sum();
    }

    private int getXpForLevel(int level) {
        if (level <= 15) {
            return level * level + 6 * level;
        }
        if (level <= 30) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    @Override
    public String toString() {
        return this.playerName + " [Level: " + this.level + ", Health: " + this.health + "/" + this.maxHealth + "]";
    }
}

