/*
 * Decompiled with CFR 0.152.
 */
package com.lne_paladins.item;

import com.lne_paladins.LNE_Paladins_Mod;
import com.lne_paladins.config.TweaksConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import more_rpg_loot.item.Group;
import net.fabric_extras.shield_api.item.CustomShieldItem;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_9285;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ShieldConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.Tiers;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainerHelper;

public class LNEShields {
    public static final ArrayList<Entry> entries = new ArrayList();
    public static class_2960 elder_guardian_shield_spell = class_2960.method_60655((String)"lne_paladins", (String)"elder_guardian_shield");
    public static class_2960 ender_dragon_shield_spell = class_2960.method_60655((String)"lne_paladins", (String)"ender_dragon_shield");
    public static class_2960 glacial_shield_spell = class_2960.method_60655((String)"lne_paladins", (String)"glacial_shield");
    public static class_2960 wither_shield_spell = class_2960.method_60655((String)"lne_paladins", (String)"wither_shield");
    private static final String GENERIC_ARMOR_TOUGHNESS = "minecraft:generic.armor_toughness";
    private static final String GENERIC_MAX_HEALTH = "generic.max_health";
    private static final String GENERIC_ATTACK_DAMAGE = "generic.attack_damage";
    private static final String GENERIC_ATTACK_SPEED = "generic.attack_speed";
    public static final String DAMAGE_REFLECT = "more_rpg_classes:damage_reflect_modifier";
    private static final int durability = 4032;

    private static Supplier<class_1856> ingredient(String idString, boolean requirement, class_1792 fallback) {
        class_2960 id = class_2960.method_60654((String)idString);
        if (requirement) {
            return () -> class_1856.method_8091((class_1935[])new class_1935[]{fallback});
        }
        return () -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            class_1792 ingredient = item != null ? item : fallback;
            return class_1856.method_8091((class_1935[])new class_1935[]{ingredient});
        };
    }

    public static Entry shield(String name, Supplier<class_1856> repair, List<AttributeModifier> attributes, int durability) {
        Entry entry = new Entry(class_2960.method_60655((String)"lne_paladins", (String)name), repair, attributes, durability);
        entry.lootProperties = Equipment.LootProperties.of((int)5);
        entries.add(entry);
        return entry;
    }

    public static void register(Map<String, ShieldConfig> configs) {
        if (!((TweaksConfig)LNE_Paladins_Mod.tweaksConfig.value).disable_special_lne_weapons) {
            LNEShields.shield("ender_dragon_shield", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_27063}), List.of(new AttributeModifier(GENERIC_ATTACK_SPEED, 0.05f, class_1322.class_1323.field_6330), new AttributeModifier(GENERIC_MAX_HEALTH, 6.0f, class_1322.class_1323.field_6328)), 4032).spell(ender_dragon_shield_spell);
            LNEShields.shield("elder_guardian_shield", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8662}), List.of(new AttributeModifier(DAMAGE_REFLECT, 0.35f, class_1322.class_1323.field_6330), new AttributeModifier(GENERIC_MAX_HEALTH, 6.0f, class_1322.class_1323.field_6328)), 4032).spell(elder_guardian_shield_spell);
            LNEShields.shield("glacial_shield", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8426}), List.of(new AttributeModifier(GENERIC_ARMOR_TOUGHNESS, 1.0f, class_1322.class_1323.field_6328), new AttributeModifier(GENERIC_MAX_HEALTH, 6.0f, class_1322.class_1323.field_6328)), 4032).spell(glacial_shield_spell);
            LNEShields.shield("wither_shield", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8606}), List.of(new AttributeModifier(GENERIC_ATTACK_DAMAGE, 0.05f, class_1322.class_1323.field_6330), new AttributeModifier(GENERIC_MAX_HEALTH, 6.0f, class_1322.class_1323.field_6328)), 4032).spell(wither_shield_spell);
        }
        int netheriteTier = Tiers.unsafe((String)"netherite");
        ArrayList<CustomShieldItem> shields = new ArrayList<CustomShieldItem>();
        for (Entry entry : entries) {
            ShieldConfig config = configs.get(entry.id.toString());
            if (config == null) {
                config = new ShieldConfig();
                config.durability = entry.durability;
                config.attributes = entry.attributes;
                configs.put(entry.id.toString(), config);
            }
            ArrayList<class_3545> shieldAttributes = new ArrayList<class_3545>();
            for (class_9285.class_9287 modifier : Weapon.attributesFrom((List)config.attributes).comp_2393()) {
                shieldAttributes.add(new class_3545((Object)modifier.comp_2395(), (Object)modifier.comp_2396()));
            }
            class_1792.class_1793 settings = new class_1792.class_1793().method_7895(config.durability);
            int tier = Tiers.unsafe((class_2960)entry.id());
            if (tier >= netheriteTier) {
                settings.method_24359();
            }
            if (entry.rarity != class_1814.field_8906) {
                settings.method_7894(entry.rarity);
            }
            if (entry.spells != null) {
                settings.method_57349(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForShield(entry.spells));
            }
            CustomShieldItem shield = new CustomShieldItem(class_3417.field_14862, entry.repair, shieldAttributes, settings);
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.id, (Object)shield);
            shields.add(shield);
        }
        ItemGroupEvents.modifyEntriesEvent((class_5321)Group.RPG_LOOT_KEY).register(content -> {
            for (class_1792 shield : shields) {
                content.method_45421((class_1935)shield);
            }
        });
    }

    public static final class Entry {
        private final class_2960 id;
        private final Supplier<class_1856> repair;
        private final List<AttributeModifier> attributes;
        private final int durability;
        public class_1814 rarity = class_1814.field_8903;
        public List<class_2960> spells = null;
        public Equipment.LootProperties lootProperties = Equipment.LootProperties.EMPTY;

        public Entry(class_2960 id, Supplier<class_1856> repair, List<AttributeModifier> attributes, int durability) {
            this.id = id;
            this.repair = repair;
            this.attributes = attributes;
            this.durability = durability;
        }

        public class_2960 id() {
            return this.id;
        }

        public Supplier<class_1856> repair() {
            return this.repair;
        }

        public List<AttributeModifier> attributes() {
            return this.attributes;
        }

        public int durability() {
            return this.durability;
        }

        public Entry spell(class_2960 spellId) {
            this.spells = List.of(spellId);
            return this;
        }
    }
}

