/*
 * Decompiled with CFR 0.152.
 */
package net.relics_rpgs.spell;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1294;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.relics_rpgs.spell.RelicEffects;
import net.relics_rpgs.spell.RelicSounds;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.entity.SpellEntityPredicates;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelicSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    private static final float T1_USE_EFFECT_DURATION = 10.0f;
    private static final float T1_PROC_EFFECT_DURATION = 6.0f;
    private static final float T1_USE_EFFECT_COOLDOWN = 60.0f;
    private static final float T1_PROC_EFFECT_COOLDOWN = 45.0f;
    private static final float T1_PROC_CHANCE = 0.05f;
    private static final float T2_USE_EFFECT_DURATION = 10.0f;
    private static final float T2_PROC_EFFECT_DURATION = 8.0f;
    private static final float T2_USE_EFFECT_COOLDOWN = 60.0f;
    private static final float T2_PROC_EFFECT_COOLDOWN = 45.0f;
    private static final float T2_PROC_CHANCE = 0.06f;
    private static final float T3_TRANCE_CHANCE = 0.1f;
    private static final float T3_TRANCE_DURATION = 10.0f;
    private static final float T3_TRANCE_COOLDOWN = 45.0f;
    private static final float T3_PERK_CC_DURATION = 2.0f;
    private static final float T3_PERK_CC_COOLDOWN = 20.0f;
    private static final float T4_USE_EFFECT_DURATION = 15.0f;
    private static final float T4_USE_EFFECT_COOLDOWN = 90.0f;
    private static final float T4_AREA_RANGE = 15.0f;
    private static final float T4_ZONE_RANGE = 3.0f;
    public static Entry lesser_use_damage = RelicSpells.add(RelicSpells.lesser_use_damage());
    public static Entry lesser_use_dex = RelicSpells.add(RelicSpells.lesser_use_dex());
    public static Entry lesser_use_ranged = RelicSpells.add(RelicSpells.lesser_use_ranged());
    public static Entry lesser_use_health = RelicSpells.add(RelicSpells.lesser_use_health());
    public static Entry lesser_use_spell_power = RelicSpells.add(RelicSpells.lesser_use_spell_power());
    public static Entry lesser_use_spell_haste = RelicSpells.add(RelicSpells.lesser_use_spell_haste());
    public static Entry lesser_proc_spell_crit = RelicSpells.add(RelicSpells.lesser_proc_spell_crit());
    public static Entry lesser_proc_crit_damage = RelicSpells.add(RelicSpells.lesser_proc_crit_damage());
    public static Entry lesser_proc_arcane_fire = RelicSpells.add(RelicSpells.lesser_proc_arcane_fire());
    public static Entry lesser_proc_frost_healing = RelicSpells.add(RelicSpells.lesser_proc_frost_healing());
    public static Entry medium_proc_attack_damage = RelicSpells.add(RelicSpells.medium_proc_attack_damage());
    public static Entry medium_proc_attack_speed = RelicSpells.add(RelicSpells.medium_proc_attack_speed());
    public static Entry medium_proc_ranged_damage = RelicSpells.add(RelicSpells.medium_proc_ranged_damage());
    public static Entry medium_proc_defense = RelicSpells.add(RelicSpells.medium_proc_defense());
    public static Entry medium_proc_spell_power = RelicSpells.add(RelicSpells.medium_proc_spell_power());
    public static Entry medium_proc_spell_haste = RelicSpells.add(RelicSpells.medium_proc_spell_haste());
    public static Entry medium_use_arcane_power = RelicSpells.add(RelicSpells.medium_use_arcane_power());
    public static Entry medium_use_fire_power = RelicSpells.add(RelicSpells.medium_use_fire_power());
    public static Entry medium_use_frost_power = RelicSpells.add(RelicSpells.medium_use_frost_power());
    public static Entry medium_use_healing_power = RelicSpells.add(RelicSpells.medium_use_healing_power());
    public static Entry greater_perk_roll_damage = RelicSpells.add(RelicSpells.greater_perk_roll_damage());
    public static Entry greater_perk_melee_stun = RelicSpells.add(RelicSpells.greater_perk_melee_stun());
    public static Entry greater_perk_spell_stun = RelicSpells.add(RelicSpells.greater_perk_spell_stun());
    public static Entry greater_perk_ranged_levitate = RelicSpells.add(RelicSpells.greater_perk_ranged_levitate());
    public static Entry greater_perk_defense_block = RelicSpells.add(RelicSpells.greater_perk_defense_block());
    public static Entry greater_perk_heal_cleanse = RelicSpells.add(RelicSpells.greater_perk_heal_cleanse());
    public static Entry greater_proc_physical_trance = RelicSpells.add(RelicSpells.greater_proc_physical_trance());
    public static Entry greater_proc_spell_trance = RelicSpells.add(RelicSpells.greater_proc_spell_trance());
    public static Entry greater_perk_heal_danger = RelicSpells.add(RelicSpells.greater_perk_heal_danger());
    public static Entry greater_proc_defense_danger = RelicSpells.add(RelicSpells.greater_proc_defense_danger());
    public static Entry superior_use_area_attack_damage = RelicSpells.add(RelicSpells.superior_use_area_attack_damage());
    public static Entry superior_use_area_defense_health = RelicSpells.add(RelicSpells.superior_use_area_defense_health());
    public static Entry superior_use_zone_spell_power = RelicSpells.add(RelicSpells.superior_use_zone_spell_power());
    public static Entry superior_use_zone_healing_taken = RelicSpells.add(RelicSpells.superior_use_zone_healing_taken());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 7;
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        return spell;
    }

    private static Spell passiveSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 7;
        spell.type = Spell.Type.PASSIVE;
        spell.passive = new Spell.Passive();
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        return spell;
    }

    private static Spell.Impact createEffectImpact(String effectIdString, float duration) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        buff.action.status_effect = new Spell.Impact.Action.StatusEffect();
        buff.action.status_effect.effect_id = effectIdString;
        buff.action.status_effect.duration = duration;
        return buff;
    }

    private static void configureCooldown(Spell spell, float duration) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        if (spell.cost.cooldown == null) {
            spell.cost.cooldown = new Spell.Cost.Cooldown();
        }
        spell.cost.cooldown.duration = duration;
    }

    @NotNull
    private static ParticleBatch lesserActivateParticles(SpellEngineParticles.MagicParticleFamily family, int count) {
        return RelicSpells.lesserActivateParticles(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)family, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), count);
    }

    @NotNull
    private static ParticleBatch lesserActivateParticles(String particleId, int count) {
        return new ParticleBatch(particleId, ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, (float)count, 0.14f, 0.15f);
    }

    private static Entry lesser_use_damage() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"lesser_use_damage");
        String description = "Use: Increases attack damage by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.LESSER_ATTACK_DAMAGE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.SHARPEN.id().toString());
        spell.release.particles = new ParticleBatch[]{RelicSpells.lesserActivateParticles(SpellEngineParticles.WHITE, 25)};
        Spell.Impact buff = RelicSpells.createEffectImpact(effect.id.toString(), 10.0f);
        spell.impacts = List.of(buff);
        spell.cost = new Spell.Cost();
        spell.cost.cooldown = new Spell.Cost.Cooldown();
        spell.cost.cooldown.duration = 60.0f;
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry lesser_use_dex() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"lesser_use_dex");
        String description = "Use: Increases melee and ranged attack speed by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.LESSER_ATTACKS_SPEED;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.MEDAL_USE.id().toString());
        spell.release.particles = new ParticleBatch[]{RelicSpells.lesserActivateParticles(SpellEngineParticles.FROST, 25)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 10.0f));
        RelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry lesser_use_ranged() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"lesser_use_ranged");
        String description = "Use: Increases ranged attack damage by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.LESSER_RANGED_DAMAGE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_RANGED;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.EAGLE_BOOST.id().toString());
        spell.release.particles = new ParticleBatch[]{RelicSpells.lesserActivateParticles(SpellEngineParticles.NATURE, 25)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 10.0f));
        RelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry lesser_use_health() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"lesser_use_health");
        String description = "Use: Heals you for {heal_percent} of your max health.";
        String title = "Sip";
        SpellTooltip.DescriptionMutator mutator = args -> {
            String modifiedDescription = args.description();
            Spell spell = (Spell)args.spellEntry().comp_349();
            Spell.Impact.Action.Heal heal = ((Spell.Impact)spell.impacts.get((int)0)).action.heal;
            if (heal != null) {
                modifiedDescription = modifiedDescription.replace("{heal_percent}", SpellTooltip.percent((float)heal.spell_power_coefficient));
            }
            return modifiedDescription;
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.release.sound = new Sound(RelicSounds.POTION_GENERIC.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch("spell_engine:magic_nature_impact_decelerate", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 10.0f, 0.14f, 0.15f, 0.0f, -0.2f)};
        Spell.Impact heal = new Spell.Impact();
        heal.attribute = class_5134.field_23716.method_55840();
        heal.action = new Spell.Impact.Action();
        heal.action.type = Spell.Impact.Action.Type.HEAL;
        heal.action.heal = new Spell.Impact.Action.Heal();
        heal.action.heal.spell_power_coefficient = 0.2f;
        spell.impacts = List.of(heal);
        RelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry lesser_use_spell_power() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"lesser_use_spell_power");
        String description = "Use: Increases spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.LESSER_SPELL_POWER;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = SpellSchools.ARCANE;
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{RelicSpells.lesserActivateParticles(SpellEngineParticles.WHITE, 25)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 10.0f));
        RelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry lesser_use_spell_haste() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"lesser_use_spell_haste");
        String description = "Use: Increases spell haste by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.LESSER_SPELL_HASTE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = SpellSchools.ARCANE;
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(RelicSounds.SPELL_HASTE_ACTIVATE_1.id().toString());
        spell.release.particles = new ParticleBatch[]{RelicSpells.lesserActivateParticles(SpellEngineParticles.HOLY, 25)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 10.0f));
        RelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry lesser_proc_spell_crit() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"lesser_proc_spell_crit");
        String description = "On spell hit: {trigger_chance} chance to increase spell critical chance by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.LESSER_SPELL_CRIT;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = SpellSchools.ARCANE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.05f;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_ANY;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.archetype = SpellSchool.Archetype.MAGIC;
        spell.passive.triggers = List.of(trigger);
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{RelicSpells.lesserActivateParticles(SpellEngineParticles.HOLY, 25)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 6.0f));
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry lesser_proc_crit_damage() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"lesser_proc_crit_damage");
        String description = "On spell hit: Spell critical strikes have {trigger_chance} chance to increase spell critical damage by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.LESSER_PROC_CRIT_DAMAGE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = SpellSchools.ARCANE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.5f;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.archetype = SpellSchool.Archetype.MAGIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        spell.passive.triggers = List.of(trigger);
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{RelicSpells.lesserActivateParticles(SpellEngineParticles.HOLY, 25)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 6.0f));
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry lesser_proc_arcane_fire() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"lesser_proc_arcane_fire");
        String description = "On spell hit: {trigger_chance} chance to increase arcane and fire spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.LESSER_POWER_ARCANE_FIRE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = SpellSchools.ARCANE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.05f;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_ANY;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.archetype = SpellSchool.Archetype.MAGIC;
        spell.passive.triggers = List.of(trigger);
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{RelicSpells.lesserActivateParticles(SpellEngineParticles.ARCANE, 12), RelicSpells.lesserActivateParticles(SpellEngineParticles.flame_spark.id().toString(), 12)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 6.0f));
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry lesser_proc_frost_healing() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"lesser_proc_frost_healing");
        String description = "On spell hit: {trigger_chance} chance to increase frost and healing spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.LESSER_POWER_FROST_HEALING;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.05f;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_ANY;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.archetype = SpellSchool.Archetype.MAGIC;
        spell.passive.triggers = List.of(trigger);
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{RelicSpells.lesserActivateParticles(SpellEngineParticles.FROST, 12), RelicSpells.lesserActivateParticles(SpellEngineParticles.HOLY, 12)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 6.0f));
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static ParticleBatch[] mediumActivateParticlesSphere(SpellEngineParticles.MagicParticleFamily family, int count) {
        return RelicSpells.mediumActivateParticlesSphere(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)family, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), count);
    }

    private static ParticleBatch[] mediumActivateParticlesSphere(String particleId, int count) {
        return new ParticleBatch[]{new ParticleBatch(particleId, ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, (float)count, 0.14f, 0.15f), new ParticleBatch(particleId, ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, (float)count, 0.24f, 0.25f)};
    }

    private static ParticleBatch[] mediumActivateParticlesPipe(SpellEngineParticles.MagicParticleFamily family, int count) {
        return RelicSpells.mediumActivateParticlesPipe(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)family, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), count);
    }

    private static ParticleBatch[] mediumActivateParticlesPipe(String particleId, int count) {
        return new ParticleBatch[]{new ParticleBatch(particleId, ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.CENTER, (float)count, 0.15f, 0.15f), new ParticleBatch(particleId, ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.CENTER, (float)count, 0.3f, 0.3f)};
    }

    private static Entry medium_proc_attack_damage() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"medium_proc_attack_damage");
        String description = "On melee hit: {trigger_chance} chance to increase attack damage by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.MEDIUM_ATTACK_DAMAGE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.06f;
        trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        spell.passive.triggers = List.of(trigger);
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.MELEE_ACTIVATE_1.id());
        spell.release.particles = RelicSpells.mediumActivateParticlesSphere(SpellEngineParticles.WHITE, 25);
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 8.0f));
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_proc_attack_speed() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"medium_proc_attack_speed");
        String description = "On hit: {trigger_chance_1} chance to increase melee and ranged attack speed by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.MEDIUM_ATTACKS_SPEED;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Spell.Trigger melee_trigger = new Spell.Trigger();
        melee_trigger.chance = 0.06f;
        melee_trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        Spell.Trigger ranged_trigger = new Spell.Trigger();
        ranged_trigger.chance = 0.06f;
        ranged_trigger.type = Spell.Trigger.Type.ARROW_IMPACT;
        spell.passive.triggers = List.of(melee_trigger, ranged_trigger);
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.BLOODLUST_ACTIVATE.id());
        spell.release.particles = RelicSpells.mediumActivateParticlesSphere(SpellEngineParticles.FROST, 25);
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 8.0f));
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_proc_ranged_damage() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"medium_proc_ranged_damage");
        String description = "On arrow hit: {trigger_chance} chance to increase ranged attack damage by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.MEDIUM_RANGED_DAMAGE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_RANGED;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.06f;
        trigger.type = Spell.Trigger.Type.ARROW_IMPACT;
        spell.passive.triggers = List.of(trigger);
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.BOW_STRING_ACTIVATE.id());
        spell.release.particles = RelicSpells.mediumActivateParticlesSphere(SpellEngineParticles.NATURE, 25);
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 8.0f));
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_proc_defense() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"medium_proc_defense");
        String description = "On damage taken: {trigger_chance} chance to increase armor toughness by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.MEDIUM_DEFENSE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.12f;
        trigger.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        spell.passive.triggers = List.of(trigger);
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.DEFENSE_ACTIVATE_1.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.RAGE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.IMPACT, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.15f, 0.15f), new ParticleBatch(SpellEngineParticles.shield_small.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.15f, 0.15f)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 8.0f));
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_proc_spell_power() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"medium_proc_spell_power");
        String description = "On spell hit: {trigger_chance} chance to increase spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.MEDIUM_SPELL_POWER;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = SpellSchools.ARCANE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.06f;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.archetype = SpellSchool.Archetype.MAGIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        spell.passive.triggers = List.of(trigger);
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.SPELL_POWER_ACTIVATE_2.id());
        spell.release.particles = RelicSpells.mediumActivateParticlesSphere(SpellEngineParticles.WHITE, 50);
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 8.0f));
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_proc_spell_haste() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"medium_proc_spell_haste");
        String description = "On spell hit: {trigger_chance} chance to increase spell haste by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.MEDIUM_SPELL_HASTE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = SpellSchools.ARCANE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.06f;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.archetype = SpellSchool.Archetype.MAGIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        spell.passive.triggers = List.of(trigger);
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.SPELL_HASTE_ACTIVATE_2.id().toString());
        spell.release.particles = RelicSpells.mediumActivateParticlesPipe(SpellEngineParticles.HOLY, 50);
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 8.0f));
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_use_arcane_power() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"medium_use_arcane_power");
        String description = "Use: Increases arcane spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.MEDIUM_ARCANE_POWER;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = SpellSchools.ARCANE;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.ARCANE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.ASCEND).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.08f, 0.08f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.ARCANE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.24f, 0.25f)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 10.0f));
        RelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_use_fire_power() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"medium_use_fire_power");
        String description = "Use: Increases fire spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.MEDIUM_FIRE_POWER;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = SpellSchools.FIRE;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame_medium_a.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.1f, 0.1f), new ParticleBatch(SpellEngineParticles.flame_spark.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.12f, 0.12f)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 10.0f));
        RelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_use_frost_power() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"medium_use_frost_power");
        String description = "Use: Increases frost spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.MEDIUM_FROST_POWER;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = SpellSchools.FROST;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.14f, 0.15f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.FROST, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.24f, 0.25f)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 10.0f));
        RelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_use_healing_power() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"medium_use_healing_power");
        String description = "Use: Increases healing spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.MEDIUM_HEALING_POWER;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.HOLY, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.ASCEND).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.08f, 0.08f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.HOLY, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.24f, 0.25f)};
        spell.impacts = List.of(RelicSpells.createEffectImpact(effect.id.toString(), 10.0f));
        RelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry greater_perk_roll_damage() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"greater_perk_roll_damage");
        String title = "Lightning Roll";
        String description = "Rolling conjures a small discharge of lightning around you, dealing {damage} damage to nearby enemies.";
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = SpellSchools.LIGHTNING;
        spell.range = 3.0f;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.ROLL;
        spell.passive.triggers = List.of(trigger);
        spell.target = new Spell.Target();
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.release.sound = new Sound(RelicSounds.LIGHTNING_IMPACT_SMALL.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch("spell_engine:electric_arc_a", ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, null, 15.0f, 0.01f, 0.05f, 0.0f, spell.range), new ParticleBatch("spell_engine:electric_arc_b", ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, null, 15.0f, 0.01f, 0.05f, 0.0f, spell.range)};
        Spell.Impact damage = new Spell.Impact();
        damage.action = new Spell.Impact.Action();
        damage.action.type = Spell.Impact.Action.Type.DAMAGE;
        damage.action.damage = new Spell.Impact.Action.Damage();
        damage.action.min_power = 6.0f;
        damage.action.max_power = 12.0f;
        spell.impacts = List.of(damage);
        RelicSpells.configureCooldown(spell, 10.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_perk_melee_stun() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"greater_perk_melee_stun");
        String title = "Stunning Strikes";
        String description = "On melee hit: {trigger_chance} chance to stun the target and nearby enemies for {effect_duration} seconds.";
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        trigger.chance = 0.1f;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact stun = RelicSpells.createEffectImpact(RelicEffects.STUN.id.toString(), 2.0f);
        stun.sound = new Sound(RelicSounds.STUN_GENERIC.id().toString());
        spell.impacts = List.of(stun);
        spell.area_impact = new Spell.AreaImpact();
        spell.area_impact.radius = 2.0f;
        RelicSpells.configureCooldown(spell, 20.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_perk_spell_stun() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"greater_perk_spell_stun");
        String title = "Disruption";
        String description = "On spell hit: {trigger_chance} chance to stun the target and nearby enemies for {effect_duration} seconds.";
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = SpellSchools.ARCANE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.1f;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact stun = RelicSpells.createEffectImpact(RelicEffects.STUN.id.toString(), 2.0f);
        stun.sound = new Sound(RelicSounds.STUN_GENERIC.id().toString());
        spell.impacts = List.of(stun);
        spell.area_impact = new Spell.AreaImpact();
        spell.area_impact.radius = 2.0f;
        RelicSpells.configureCooldown(spell, 20.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_perk_ranged_levitate() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"greater_perk_ranged_levitate");
        String title = "Levitation";
        String description = "On arrow hit: {trigger_chance} chance to levitate the target and nearby enemies for {effect_duration} seconds.";
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_RANGED;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.12f;
        trigger.type = Spell.Trigger.Type.ARROW_IMPACT;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact levitate = RelicSpells.createEffectImpact(((class_5321)class_1294.field_5902.method_40230().get()).method_29177().toString(), 2.0f);
        levitate.sound = new Sound(RelicSounds.LEVITATE_GENERIC.id().toString());
        levitate.action.status_effect.amplifier = 3;
        levitate.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.NATURE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 50.0f, 0.15f, 0.5f)};
        spell.impacts = List.of(levitate);
        spell.area_impact = new Spell.AreaImpact();
        spell.area_impact.radius = 2.0f;
        RelicSpells.configureCooldown(spell, 20.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_perk_defense_block() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"greater_perk_defense_block");
        String title = "Wardstone";
        String description = "Blocking with a shield heals your by {heal}.";
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.SHIELD_BLOCK;
        spell.passive.triggers = List.of(trigger);
        Spell.Impact heal = new Spell.Impact();
        heal.action = new Spell.Impact.Action();
        heal.action.min_power = 2.0f;
        heal.action.type = Spell.Impact.Action.Type.HEAL;
        heal.action.heal = new Spell.Impact.Action.Heal();
        heal.action.heal.spell_power_coefficient = 1.0f;
        heal.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.HOLY, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.IMPACT, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.15f, 0.2f)};
        heal.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_IMPACT_1.id());
        spell.impacts = List.of(heal);
        RelicSpells.configureCooldown(spell, 4.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_perk_heal_cleanse() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"greater_perk_healing_cleanse");
        String title = "Purification";
        String description = "Healing spells have a {trigger_chance} chance to remove a harmful effect from the target.";
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.5f;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.HEAL.toString();
        Spell.TargetCondition condition = new Spell.TargetCondition();
        condition.entity_predicate_id = SpellEntityPredicates.HAS_BAD_EFFECT.id().toString();
        trigger.target_conditions = List.of(condition);
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact cleanse = new Spell.Impact();
        cleanse.action = new Spell.Impact.Action();
        cleanse.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        cleanse.action.status_effect = new Spell.Impact.Action.StatusEffect();
        cleanse.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.REMOVE;
        cleanse.action.status_effect.remove = new Spell.Impact.Action.StatusEffect.Remove();
        cleanse.action.status_effect.remove.id = "!" + class_1294.field_50116.method_55840();
        cleanse.action.status_effect.remove.selector = Spell.Impact.Action.StatusEffect.Remove.Selector.RANDOM;
        cleanse.action.status_effect.remove.select_beneficial = false;
        cleanse.sound = new Sound(RelicSounds.HOLY_WATER_IMPACT.id());
        cleanse.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.FROST, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.15f, 0.15f), new ParticleBatch("dripping_water", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.15f, 0.25f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.HOLY, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.IMPACT, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 15.0f, 0.3f, 0.3f)};
        spell.impacts = List.of(cleanse);
        RelicSpells.configureCooldown(spell, 20.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_proc_physical_trance() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"greater_proc_physical_trance");
        String description = "On hit: {trigger_chance_1} chance to enter battle trance, increasing melee and ranged attack speed by {bonus}. Stacking up to {effect_amplifier_cap} times, lasting for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.GREATER_PHYSICAL_TRANCE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        float triggerChance = 0.1f;
        Spell.Trigger passiveMeleeTrigger = new Spell.Trigger();
        passiveMeleeTrigger.chance = triggerChance;
        passiveMeleeTrigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        Spell.Trigger passiveRangedTrigger = new Spell.Trigger();
        passiveRangedTrigger.chance = triggerChance;
        passiveRangedTrigger.type = Spell.Trigger.Type.ARROW_IMPACT;
        spell.passive.triggers = List.of(passiveMeleeTrigger, passiveRangedTrigger);
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        Spell.Trigger stashMeleeTrigger = new Spell.Trigger();
        stashMeleeTrigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        stashMeleeTrigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        Spell.Trigger stashRangedTrigger = new Spell.Trigger();
        stashRangedTrigger.type = Spell.Trigger.Type.ARROW_IMPACT;
        stashRangedTrigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.deliver.stash_effect.triggers = List.of(stashMeleeTrigger, stashRangedTrigger);
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.BLOODLUST_ACTIVATE.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.RAGE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.IMPACT, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 25.0f, 0.15f, 0.15f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.RAGE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.IMPACT, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 50.0f, 0.3f, 0.3f)};
        Spell.Impact buff = RelicSpells.createEffectImpact(effect.id.toString(), 10.0f);
        buff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        buff.action.status_effect.amplifier = 1;
        buff.action.status_effect.amplifier_cap = 9;
        buff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(buff);
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry greater_proc_spell_trance() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"greater_proc_spell_trance");
        String description = "On spell hit: {trigger_chance_1} chance to enter magic trance, increasing spell haste by {bonus}. Stacking up to {effect_amplifier_cap} times, lasting for {effect_duration} seconds.";
        Effects.Entry effect = RelicEffects.GREATER_SPELL_TRANCE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = SpellSchools.ARCANE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.1f;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.archetype = SpellSchool.Archetype.MAGIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        spell.passive.triggers = List.of(trigger);
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.id = effect.id.toString().toString();
        spell.deliver.stash_effect.consume = 0;
        Spell.Trigger stashTrigger = new Spell.Trigger();
        stashTrigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        stashTrigger.spell = new Spell.Trigger.SpellCondition();
        stashTrigger.spell.archetype = SpellSchool.Archetype.MAGIC;
        stashTrigger.impact = new Spell.Trigger.ImpactCondition();
        stashTrigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        spell.deliver.stash_effect.triggers = List.of(stashTrigger);
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.SPELL_POWER_ACTIVATE_3.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.FROST, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 50.0f, 0.15f, 0.15f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.FROST, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 50.0f, 0.3f, 0.3f)};
        Spell.Impact buff = RelicSpells.createEffectImpact(effect.id.toString(), 10.0f);
        buff.action.apply_to_caster = true;
        buff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        buff.action.status_effect.amplifier = 1;
        buff.action.status_effect.amplifier_cap = 9;
        buff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(buff);
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry greater_perk_heal_danger() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"greater_perk_heal_danger");
        String title = "Desperation";
        float health_threshold = 0.5f;
        String description = "Healing a target below {health_threshold} health, receives additional {heal} healing.";
        SpellTooltip.DescriptionMutator mutator = args -> args.description().replace("{health_threshold}", SpellTooltip.percent((float)health_threshold));
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        Spell.Trigger trigger = new Spell.Trigger();
        Spell.TargetCondition healthCondition = new Spell.TargetCondition();
        healthCondition.health_percent_below = health_threshold;
        trigger.target_conditions = List.of(healthCondition);
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.HEAL.toString();
        spell.passive.triggers = List.of(trigger);
        Spell.Impact heal = new Spell.Impact();
        heal.action = new Spell.Impact.Action();
        heal.action.min_power = 10.0f;
        heal.action.type = Spell.Impact.Action.Type.HEAL;
        heal.action.heal = new Spell.Impact.Action.Heal();
        heal.action.heal.spell_power_coefficient = 0.3f;
        heal.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.NATURE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.45f, 0.7f)};
        heal.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_IMPACT_3.id());
        spell.impacts = List.of(heal);
        RelicSpells.configureCooldown(spell, 5.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry greater_proc_defense_danger() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"greater_perk_defense_danger");
        Effects.Entry effect = RelicEffects.GREATER_DEFENSE_ARMOR;
        String title = effect.title;
        float health_threshold = 0.4f;
        String description = "Taking damage below {health_threshold} health, increases armor by {bonus} for {effect_duration} seconds.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{health_threshold}", SpellTooltip.percent((float)health_threshold)).replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.release.sound = new Sound(RelicSounds.DEFENSE_ACTIVATE_2.id().toString());
        Spell.Trigger trigger = new Spell.Trigger();
        Spell.TargetCondition healthCondition = new Spell.TargetCondition();
        healthCondition.health_percent_below = health_threshold;
        trigger.caster_conditions = List.of(healthCondition);
        trigger.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        Spell.Impact buff = RelicSpells.createEffectImpact(effect.id.toString(), 10.0f);
        buff.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.WHITE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.55f, 0.8f), new ParticleBatch(SpellEngineParticles.shield_small.id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 15.0f, 0.2f, 0.2f)};
        spell.impacts = List.of(buff);
        RelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static ParticleBatch areaSpellCircle(SpellEngineParticles.MagicParticleFamily family, float speed) {
        return new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)family, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 60.0f, speed, speed);
    }

    private static Entry superior_use_area_attack_damage() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"superior_use_area_attack_damage");
        Effects.Entry effect = RelicEffects.SUPERIOR_ATTACK_DAMAGE;
        String title = effect.title;
        String description = "Use: Increases size, melee and ranged attack damage of nearby allies by {bonus} for {effect_duration} seconds.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.range = 15.0f;
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.include_caster = true;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = Sound.withRandomness((class_2960)RelicSounds.HORN_ACTIVATE.id(), (float)0.0f);
        spell.release.particles = new ParticleBatch[]{RelicSpells.areaSpellCircle(SpellEngineParticles.HOLY, 0.8f), RelicSpells.areaSpellCircle(SpellEngineParticles.HOLY, 1.2f)};
        Spell.Impact buff = RelicSpells.createEffectImpact(effect.id.toString(), 15.0f);
        spell.impacts = List.of(buff);
        RelicSpells.configureCooldown(spell, 90.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry superior_use_area_defense_health() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"superior_use_area_defense_health");
        Effects.Entry effect = RelicEffects.SUPERIOR_DEFENSE_HEALTH;
        String title = effect.title;
        String description = "Use: Increases maximum health of nearby allies by {bonus} for {effect_duration} seconds.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 15.0f;
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.include_caster = true;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.HEART_OF_BEAST_ACTIVATE.id().toString());
        spell.release.particles = new ParticleBatch[]{RelicSpells.areaSpellCircle(SpellEngineParticles.RAGE, 0.8f), RelicSpells.areaSpellCircle(SpellEngineParticles.RAGE, 1.2f)};
        Spell.Impact heal = new Spell.Impact();
        heal.action = new Spell.Impact.Action();
        heal.action.type = Spell.Impact.Action.Type.HEAL;
        heal.action.heal = new Spell.Impact.Action.Heal();
        heal.attribute = class_5134.field_23716.method_55840();
        heal.action.heal.spell_power_coefficient = 0.33f;
        heal.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_IMPACT_3.id());
        Spell.Impact buff = RelicSpells.createEffectImpact(effect.id.toString(), 15.0f);
        buff.particles = new ParticleBatch[]{new ParticleBatch("heart", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 5.0f, 0.75f, 1.5f, 0.0f, 0.0f)};
        spell.impacts = List.of(buff, heal);
        RelicSpells.configureCooldown(spell, 90.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static ParticleBatch[] zoneParticles(SpellEngineParticles.MagicParticleFamily family) {
        return new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)family, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.FLOAT).id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, null, 15.0f, 0.05f, 0.1f, 0.0f, 0.0f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)family, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.ASCEND).id().toString(), ParticleBatch.Shape.PIPE, ParticleBatch.Origin.FEET, null, 5.0f, 0.1f, 0.2f, 0.0f, 0.0f)};
    }

    private static Entry superior_use_zone_spell_power() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"superior_use_zone_spell_power");
        Effects.Entry effect = RelicEffects.SUPERIOR_SPELL_POWER;
        String title = effect.title;
        String description = "Use: Conjures a powerful circle, lasting {cloud_duration} seconds. While standing in this circle, the caster gains {bonus} spell power.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = SpellSchools.ARCANE;
        spell.range = 0.0f;
        spell.deliver.type = Spell.Delivery.Type.CLOUD;
        Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
        cloud.volume.radius = 3.0f;
        cloud.time_to_live_seconds = 15.0f;
        cloud.client_data.particles = RelicSpells.zoneParticles(SpellEngineParticles.WHITE);
        cloud.presence_sound = new Sound(RelicSounds.MAGIC_ZONE_PRESENCE.id());
        spell.deliver.clouds = List.of(cloud);
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.SPELL_ZONE_ACTIVATE.id().toString());
        spell.release.particles = new ParticleBatch[]{RelicSpells.areaSpellCircle(SpellEngineParticles.WHITE, 0.6f)};
        Spell.Impact buff = RelicSpells.createEffectImpact(effect.id.toString(), 1.0f);
        spell.impacts = List.of(buff);
        RelicSpells.configureCooldown(spell, 90.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry superior_use_zone_healing_taken() {
        class_2960 id = class_2960.method_60655((String)"relics_rpgs", (String)"superior_use_zone_healing_taken");
        Effects.Entry effect = RelicEffects.SUPERIOR_HEALING_TAKEN;
        String title = effect.title;
        String description = "Use: Conjures a healing circle, {cloud_radius} blocks, lasting {cloud_duration} seconds. While standing in this circle, allies receives {bonus} more healing.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (class_1322.class_1323)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = RelicSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 0.0f;
        spell.deliver.type = Spell.Delivery.Type.CLOUD;
        Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
        cloud.volume.radius = 3.0f;
        cloud.time_to_live_seconds = 15.0f;
        cloud.client_data.particles = RelicSpells.zoneParticles(SpellEngineParticles.FROST);
        cloud.presence_sound = new Sound(RelicSounds.MAGIC_ZONE_PRESENCE.id());
        spell.deliver.clouds = List.of(cloud);
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.HEALING_ZONE_ACTIVATE.id().toString());
        spell.release.particles = new ParticleBatch[]{RelicSpells.areaSpellCircle(SpellEngineParticles.FROST, 0.6f)};
        Spell.Impact buff = RelicSpells.createEffectImpact(effect.id.toString(), 1.0f);
        spell.impacts = List.of(buff);
        RelicSpells.configureCooldown(spell, 90.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    public record Entry(class_2960 id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

