/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.kit;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.commands.CommandUtils;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.kit.Kit;
import dev.ftb.mods.ftbessentials.kit.KitManager;
import dev.ftb.mods.ftbessentials.util.BlockUtil;
import dev.ftb.mods.ftbessentials.util.DurationInfo;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.InventoryUtil;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import joptsimple.internal.Strings;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class KitCommand
implements FTBCommand {
    public static final SimpleCommandExceptionType NOT_LOOKING_AT_BLOCK = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbessentials.kit.not_looking_at_block"));
    public static final SimpleCommandExceptionType NO_ITEMS_TO_ADD = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbessentials.kit.no_items"));
    public static final SimpleCommandExceptionType NOT_ENOUGH_SPACE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbessentials.kit.not_enough_space"));
    public static final DynamicCommandExceptionType NO_SUCH_KIT = new DynamicCommandExceptionType(kitName -> class_2561.method_43469((String)"ftbessentials.kit.no_such_kit", (Object[])new Object[]{kitName}));
    public static final DynamicCommandExceptionType NO_KIT_PERMISSION = new DynamicCommandExceptionType(kitName -> class_2561.method_43469((String)"ftbessentials.kit.no_permission", (Object[])new Object[]{kitName}));
    public static final DynamicCommandExceptionType UNKNOWN_PLAYER_ID = new DynamicCommandExceptionType(playerId -> class_2561.method_43469((String)"ftbessentials.unknown_player_id", (Object[])new Object[]{playerId}));
    public static final Dynamic2CommandExceptionType ONE_TIME_ONLY = new Dynamic2CommandExceptionType((kitName, playerName) -> class_2561.method_43469((String)"ftbessentials.kit.one_time_only", (Object[])new Object[]{kitName, playerName}));
    public static final Dynamic2CommandExceptionType ON_COOLDOWN = new Dynamic2CommandExceptionType((kitName, remaining) -> class_2561.method_43469((String)"ftbessentials.kit.on_cooldown", (Object[])new Object[]{kitName, remaining}));
    public static final DynamicCommandExceptionType ALREADY_EXISTS = new DynamicCommandExceptionType(kitName -> class_2561.method_43469((String)"ftbessentials.kit.already_exists", (Object[])new Object[]{kitName}));

    @Override
    public boolean enabled() {
        return FTBEConfig.KIT.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<class_2168>> register() {
        return List.of((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"kit").requires(CommandUtils.isGamemaster())).then(class_2170.method_9247((String)"create_from_player_inv").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommand.createKitFromPlayer((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "", false))).then(class_2170.method_9244((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestCooldowns(builder)).executes(ctx -> KitCommand.createKitFromPlayer((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"), false)))))).then(class_2170.method_9247((String)"create_from_player_hotbar").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommand.createKitFromPlayer((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "", true))).then(class_2170.method_9244((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestCooldowns(builder)).executes(ctx -> KitCommand.createKitFromPlayer((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"), true)))))).then(class_2170.method_9247((String)"create_from_block_inv").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommand.createKitFromBlock((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), ""))).then(class_2170.method_9244((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestCooldowns(builder)).executes(ctx -> KitCommand.createKitFromBlock((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"))))))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.deleteKit((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"list").executes(ctx -> KitCommand.listKits((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"show").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.showKit((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.giveKit((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), class_2186.method_9312((CommandContext)ctx, (String)"players"))))))).then(class_2170.method_9247((String)"put_in_block_inv").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.putKitInBlockInv((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(class_2170.method_9247((String)"cooldown").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).then(class_2170.method_9244((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestCooldowns(builder)).executes(ctx -> KitCommand.modifyCooldown((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"))))))).then(class_2170.method_9247((String)"reset_cooldown").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.resetCooldowns((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> KitCommand.resetCooldowns((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), class_2186.method_9315((CommandContext)ctx, (String)"player"))))).then(class_2170.method_9244((String)"id", (ArgumentType)class_5242.method_27643()).executes(ctx -> KitCommand.resetCooldowns((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), class_5242.method_27645((CommandContext)ctx, (String)"id"))))))).then(class_2170.method_9247((String)"set_autogrant").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).then(class_2170.method_9244((String)"grant", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> KitCommand.modifyAutogrant((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), BoolArgumentType.getBool((CommandContext)ctx, (String)"grant")))))));
    }

    private static int putKitInBlockInv(class_2168 source, String kitName) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_3965 res = BlockUtil.getFocusedBlock(player, 5.5).orElseThrow(() -> ((SimpleCommandExceptionType)NOT_LOOKING_AT_BLOCK).create());
        Kit kit = KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        if (!InventoryUtil.putItemsInInventory(kit.getItems(), player.method_37908(), res.method_17777(), res.method_17780())) {
            throw NOT_ENOUGH_SPACE.create();
        }
        source.method_9226(() -> class_2561.method_43469((String)"ftbessentials.kit.added_items", (Object[])new Object[]{kitName}).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestKits(SuggestionsBuilder builder) {
        return KitCommand.suggestKits(null, builder);
    }

    static CompletableFuture<Suggestions> suggestKits(@Nullable class_3222 player, SuggestionsBuilder builder) {
        List<String> list = KitManager.getInstance().allKits().stream().filter(kit -> kit.playerCanGetKit(player)).map(Kit::getKitName).toList();
        return class_2172.method_9265(list, (SuggestionsBuilder)builder);
    }

    private static int createKitFromPlayer(class_2168 source, String name, String cooldown, boolean hotbarOnly) throws CommandSyntaxException {
        long secs = DurationInfo.getSeconds(cooldown);
        KitManager.getInstance().createFromPlayerInv(name, source.method_9207(), secs, hotbarOnly);
        source.method_9226(() -> class_2561.method_43469((String)"ftbessentials.kit.created", (Object[])new Object[]{name}).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int createKitFromBlock(class_2168 source, String name, String cooldown) throws CommandSyntaxException {
        long secs = DurationInfo.getSeconds(cooldown);
        class_3222 player = source.method_9207();
        class_3965 res = BlockUtil.getFocusedBlock(player, 5.5).orElseThrow(() -> ((SimpleCommandExceptionType)NOT_LOOKING_AT_BLOCK).create());
        KitManager.getInstance().createFromBlockInv(name, player.method_37908(), res.method_17777(), res.method_17780(), secs);
        source.method_9226(() -> class_2561.method_43469((String)"ftbessentials.kit.created", (Object[])new Object[]{name}).method_27692(class_124.field_1054), false);
        return 1;
    }

    static int giveKit(class_2168 source, String name, Collection<class_3222> players) throws CommandSyntaxException {
        if (!source.method_9259(2) && players.size() == 1 && source.method_44023() != null && players.contains(source.method_44023()) && !Kit.checkPermissionNode(source.method_44023(), name)) {
            throw NO_KIT_PERMISSION.create((Object)name);
        }
        for (class_3222 player : players) {
            KitManager.getInstance().giveKitToPlayer(name, player);
        }
        source.method_9226(() -> class_2561.method_43469((String)"ftbessentials.kit.gave_to_players", (Object[])new Object[]{name, players.size()}).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int listKits(class_2168 source) {
        Collection<Kit> kits = KitManager.getInstance().allKits();
        source.method_9226(() -> class_2561.method_43469((String)"ftbessentials.kit.count", (Object[])new Object[]{kits.size()}).method_27692(class_124.field_1075), false);
        kits.stream().sorted(Comparator.comparing(Kit::getKitName)).forEach(kit -> source.method_9226(() -> class_2561.method_43470((String)("\u2022 " + kit.getKitName())).method_27696(class_2583.field_24360.method_10977(class_124.field_1054).method_10958(new class_2558(class_2558.class_2559.field_11750, "/kit show " + kit.getKitName()))), false));
        return 1;
    }

    private static int showKit(class_2168 source, String kitName) throws CommandSyntaxException {
        Kit kit = KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        source.method_9226(() -> class_2561.method_43470((String)Strings.repeat((char)'-', (int)40)).method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43469((String)"ftbessentials.kit_name", (Object[])new Object[]{class_2561.method_43470((String)kit.getKitName()).method_27692(class_124.field_1054)}).method_27692(class_124.field_1075), false);
        if (kit.getCooldown() > 0L) {
            source.method_9226(() -> class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43469((String)"ftbessentials.kit.cooldown", (Object[])new Object[]{class_2561.method_43470((String)TimeUtils.prettyTimeString((long)kit.getCooldown())).method_27692(class_124.field_1054)})).method_27692(class_124.field_1075), false);
        } else if (kit.getCooldown() == 0L) {
            source.method_9226(() -> class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43471((String)"ftbessentials.kit.cooldown.none")).method_27692(class_124.field_1075), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43471((String)"ftbessentials.kit.one_time")).method_27692(class_124.field_1075), false);
        }
        if (kit.isAutoGrant()) {
            source.method_9226(() -> class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43471((String)"ftbessentials.kit.autogranted")).method_27692(class_124.field_1075), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43471((String)"ftbessentials.kit.items")).method_27692(class_124.field_1075), false);
        for (class_1799 stack : kit.getItems()) {
            source.method_9226(() -> class_2561.method_43470((String)"  \u2022 ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(stack.method_7947() + " x ")).method_27692(class_124.field_1068)).method_10852(stack.method_7954()), false);
        }
        return 1;
    }

    private static int deleteKit(class_2168 source, String kitName) throws CommandSyntaxException {
        KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        KitManager.getInstance().deleteKit(kitName);
        source.method_9226(() -> class_2561.method_43469((String)"ftbessentials.kit.deleted", (Object[])new Object[]{kitName}).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int modifyAutogrant(class_2168 source, String kitName, boolean grant) throws CommandSyntaxException {
        Kit kit = KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        KitManager.getInstance().addKit(kit.withAutoGrant(grant), true);
        source.method_9226(() -> class_2561.method_43469((String)"ftbessentials.kit.autogrant_modified", (Object[])new Object[]{kitName, grant}).method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int modifyCooldown(class_2168 source, String kitName, String cooldown) throws CommandSyntaxException {
        Kit kit = KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        long secs = DurationInfo.getSeconds(cooldown);
        KitManager.getInstance().addKit(kit.withCooldown(secs), true);
        class_5250 newTime = secs < 0L ? class_2561.method_43471((String)"ftbessentials.kit.one_time") : class_2561.method_43470((String)TimeUtils.prettyTimeString((long)secs));
        source.method_9226(() -> KitCommand.lambda$modifyCooldown$56(kitName, (class_2561)newTime), false);
        return 1;
    }

    private static int resetCooldowns(class_2168 source, String name, class_3222 player) throws CommandSyntaxException {
        return KitCommand.resetCooldowns(source, name, player.method_5667());
    }

    private static int resetCooldowns(class_2168 source, String kitName, UUID playerId) throws CommandSyntaxException {
        KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        if (!FTBEPlayerData.playerExists(playerId)) {
            throw UNKNOWN_PLAYER_ID.create((Object)playerId);
        }
        return FTBEPlayerData.getOrCreate(source.method_9211(), playerId).map(data -> {
            data.setLastKitUseTime(kitName, 0L);
            source.method_9226(() -> class_2561.method_43469((String)"ftbessentials.kit.cooldown_reset", (Object[])new Object[]{kitName, playerId}).method_27692(class_124.field_1054), false);
            return 1;
        }).orElse(0);
    }

    private static int resetCooldowns(class_2168 source, String kitName) throws CommandSyntaxException {
        KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        if (KitManager.getInstance().get(kitName).isPresent()) {
            FTBEPlayerData.cleanupKitCooldowns(kitName);
            source.method_9226(() -> class_2561.method_43469((String)"ftbessentials.kit.cooldown_reset_all", (Object[])new Object[]{kitName}).method_27692(class_124.field_1054), false);
            return 1;
        }
        return 0;
    }

    private static /* synthetic */ class_2561 lambda$modifyCooldown$56(String kitName, class_2561 newTime) {
        return class_2561.method_43469((String)"ftbessentials.kit.cooldown_modified", (Object[])new Object[]{kitName, newTime}).method_27692(class_124.field_1054);
    }
}

