/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.chat;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbessentials.commands.CommandUtils;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.DurationInfo;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class MuteCommand
implements FTBCommand {
    @Override
    public boolean enabled() {
        return FTBEConfig.MUTE.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<class_2168>> register() {
        return List.of((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mute").requires(FTBEConfig.MUTE.enabledAndOp())).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.mute((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), ""))).then(class_2170.method_9244((String)"until", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> CommandUtils.suggestDurations(builder)).executes(context -> this.mute((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"until"))))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unmute").requires(FTBEConfig.MUTE.enabledAndOp())).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.unmute((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))));
    }

    private int mute(class_2168 source, class_3222 player, String duration) throws CommandSyntaxException {
        DurationInfo info = DurationInfo.fromString(duration);
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            data.setMuted(true);
            FTBEWorldData.instance.setMuteTimeout(player, info.until());
            class_5250 msg = class_2561.method_43469((String)"ftbessentials.muted.muted", (Object[])new Object[]{player.method_5476(), source.method_9223(), info.desc()});
            this.notifyMuting(source, (class_1657)player, (class_2561)msg);
            return 1;
        }).orElse(0);
    }

    private int unmute(class_2168 source, class_3222 player) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            data.setMuted(false);
            FTBEWorldData.instance.setMuteTimeout(player, -1L);
            this.notifyMuting(source, (class_1657)player, (class_2561)class_2561.method_43469((String)"ftbessentials.muted.unmuted", (Object[])new Object[]{player.method_5476(), source.method_9223()}));
            return 1;
        }).orElse(0);
    }

    private void notifyMuting(class_2168 source, class_1657 target, class_2561 msg) {
        source.method_9211().method_3760().method_14571().forEach(p -> {
            if (p.method_5687(2) || p == target) {
                p.method_7353(msg, false);
            }
        });
        if (!source.method_43737()) {
            source.method_9226(() -> msg, true);
        }
    }
}

