/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.guardvillagers.common.entity.goal;

import dev.sterner.guardvillagers.common.entity.GuardEntity;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1753;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;

public class RangedBowAttackPassiveGoal<T extends GuardEntity>
extends class_1352 {
    private final T actor;
    private final double speed;
    private final float squaredRange;
    private final int attackInterval;
    private int cooldown = 0;
    private int targetSeeingTicker = 0;
    private int combatTicks = -1;
    private boolean movingToLeft = false;
    private boolean backward = false;
    private final Map<class_2960, Integer> spellCooldowns = new HashMap<class_2960, Integer>();
    private boolean spellFired;
    private int windUpTicks;
    private int channelTicksLeft;
    private int castingDelayTicks;
    private boolean isChanneled;
    private class_2960 currentSpellId;
    private class_6880<Spell> cachedSpellEntry;

    public RangedBowAttackPassiveGoal(T actor, double speed, int attackInterval, float range) {
        this.actor = actor;
        this.speed = speed;
        this.attackInterval = attackInterval;
        this.squaredRange = range * range;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        return this.actor.method_5968() != null && this.isHoldingBow();
    }

    public boolean method_6266() {
        return this.method_6264() || !this.actor.method_5942().method_6357();
    }

    public void method_6269() {
        this.actor.method_19540(true);
    }

    public void method_6270() {
        this.actor.method_19540(false);
        this.actor.method_6021();
        this.spellCooldowns.replaceAll((id, time) -> Math.max(time - 1, 0));
    }

    private boolean isHoldingBow() {
        return this.actor.method_6047().method_7909() instanceof class_1753;
    }

    private float getScaledSpellChance() {
        double rangedDamage = 0.0;
        Optional rangedAttrEntryOpt = class_7923.field_41190.method_55841(class_2960.method_60655((String)"ranged_weapon", (String)"damage"));
        if (rangedAttrEntryOpt.isPresent()) {
            class_6880 rangedAttrEntry = (class_6880)rangedAttrEntryOpt.get();
            if (this.actor.method_6127().method_45331(rangedAttrEntry)) {
                rangedDamage = this.actor.method_45325(rangedAttrEntry);
            }
        }
        double minChance = 0.05;
        double maxChance = 0.15;
        double maxDamage = 10.0;
        double chance = minChance + Math.min(rangedDamage, maxDamage) / maxDamage * (maxChance - minChance);
        return (float)chance;
    }

    public void method_6268() {
        boolean hasSeenRecently;
        class_1309 target = this.actor.method_5968();
        if (target == null || !target.method_5805()) {
            return;
        }
        double distanceSq = this.actor.method_5858((class_1297)target);
        boolean canSee = this.actor.method_5985().method_6369((class_1297)target);
        boolean bl = hasSeenRecently = this.targetSeeingTicker > 0;
        if (canSee != hasSeenRecently) {
            this.targetSeeingTicker = 0;
        }
        int n = this.targetSeeingTicker = canSee ? (this.targetSeeingTicker = this.targetSeeingTicker + 1) : (this.targetSeeingTicker = this.targetSeeingTicker - 1);
        if (distanceSq > (double)this.squaredRange || this.targetSeeingTicker < 20) {
            this.actor.method_5942().method_6335((class_1297)target, this.speed);
            this.combatTicks = -1;
        } else {
            this.actor.method_5942().method_6340();
            ++this.combatTicks;
        }
        if (this.combatTicks >= 20) {
            if (this.actor.method_59922().method_43057() < 0.3f) {
                boolean bl2 = this.movingToLeft = !this.movingToLeft;
            }
            if (this.actor.method_59922().method_43057() < 0.3f) {
                this.backward = !this.backward;
            }
            this.combatTicks = 0;
        }
        if (this.combatTicks > -1) {
            if (distanceSq > (double)(this.squaredRange * 0.75f)) {
                this.backward = false;
            } else if (distanceSq < (double)(this.squaredRange * 0.25f)) {
                this.backward = true;
            }
            this.actor.method_5962().method_6243(this.backward ? -0.5f : 0.5f, this.movingToLeft ? 0.5f : -0.5f);
        }
        this.actor.method_5951((class_1297)target, 30.0f, 30.0f);
        this.actor.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        this.spellCooldowns.replaceAll((id, time) -> Math.max(time - 1, 0));
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        class_2960 spellId = this.getBowSpellId();
        if (this.actor.method_6115()) {
            int useTime = this.actor.method_6048();
            if (canSee && useTime >= 30) {
                Optional spellOpt;
                this.actor.method_6021();
                float spellChance = this.getScaledSpellChance();
                if (spellId != null && !this.isSpellOnCooldown(spellId) && this.actor.method_59922().method_43057() < spellChance && (spellOpt = SpellRegistry.from((class_1937)this.actor.method_37908()).method_55841(spellId)).isPresent()) {
                    this.cachedSpellEntry = (class_6880)spellOpt.get();
                    Spell spell = (Spell)this.cachedSpellEntry.comp_349();
                    this.currentSpellId = spellId;
                    this.windUpTicks = this.getWindUpTicks(spell);
                    this.isChanneled = this.isSpellChanneled(spell);
                    this.channelTicksLeft = this.getChannelDuration(spell);
                    this.castingDelayTicks = 0;
                    this.spellFired = false;
                    this.castSpell(target, spell, this.cachedSpellEntry);
                    this.spellCooldowns.put(spellId, 10);
                    this.cooldown = 0;
                    return;
                }
                this.actor.method_7105(target, class_1753.method_7722((int)useTime));
            }
        } else if (this.cooldown <= 0 && this.targetSeeingTicker >= -60) {
            ((GuardEntity)((Object)this.actor)).method_6019(class_1268.field_5808);
        }
    }

    private void castSpell(class_1309 target, Spell spell, class_6880<Spell> spellEntry) {
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(SpellPower.getSpellPower((SpellSchool)spell.school, this.actor)).channeled(this.isChanneled ? 1.0f : 0.0f).position(this.actor.method_33571()).target(SpellHelper.focusMode((Spell)spell)).distance(1.0f);
        switch (String.valueOf(spell.deliver.type).toUpperCase()) {
            case "PROJECTILE": {
                int totalProjectiles = 1 + spell.deliver.projectile.launch_properties.extra_launch_count;
                for (int i = 0; i < totalProjectiles; ++i) {
                    Spell.ProjectileData.Perks perks = spell.deliver.projectile.projectile.perks != null ? spell.deliver.projectile.projectile.perks.copy() : new Spell.ProjectileData.Perks();
                    class_243 launchPos = SpellHelper.launchPoint(this.actor);
                    class_243 direction = target.method_33571().method_1020(launchPos).method_1029();
                    float yawOffset = 0.0f;
                    if (spell.deliver.projectile.direction_offsets != null && i < spell.deliver.projectile.direction_offsets.length) {
                        yawOffset = spell.deliver.projectile.direction_offsets[i].yaw;
                    }
                    class_243 rotatedDirection = this.rotateYaw(direction, yawOffset);
                    SpellProjectile projectile = new SpellProjectile(this.actor.method_37908(), this.actor, launchPos.field_1352, launchPos.field_1351, launchPos.field_1350, SpellProjectile.Behaviour.FLY, spellEntry, context, perks);
                    projectile.method_7485(rotatedDirection.field_1352, rotatedDirection.field_1351, rotatedDirection.field_1350, spell.deliver.projectile.launch_properties.velocity, spell.deliver.projectile.projectile.divergence);
                    projectile.range = spell.range;
                    this.actor.method_37908().method_8649((class_1297)projectile);
                }
                this.playSpellSound(spell);
                break;
            }
            case "METEOR": {
                SpellHelper.fallProjectile((class_1937)this.actor.method_37908(), this.actor, (class_1297)target, (class_243)target.method_19538(), spellEntry, (SpellHelper.ImpactContext)context);
                this.playSpellSound(spell);
                break;
            }
            case "DIRECT": {
                SpellHelper.performImpacts((class_1937)this.actor.method_37908(), this.actor, (class_1297)target, this.actor, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)context);
                this.playSpellSound(spell);
            }
        }
    }

    private class_243 rotateYaw(class_243 vec, float degrees) {
        double radians = Math.toRadians(degrees);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double x = vec.field_1352 * cos - vec.field_1350 * sin;
        double z = vec.field_1352 * sin + vec.field_1350 * cos;
        return new class_243(x, vec.field_1351, z);
    }

    private class_2960 getBowSpellId() {
        return ((GuardEntity)((Object)this.actor)).getBowSkill() != null && !((GuardEntity)((Object)this.actor)).getBowSkill().equals("none") ? class_2960.method_12829((String)((GuardEntity)((Object)this.actor)).getBowSkill()) : null;
    }

    private boolean isSpellOnCooldown(class_2960 spellId) {
        return this.spellCooldowns.getOrDefault(spellId, 0) > 0;
    }

    private boolean isSpellChanneled(Spell spell) {
        return spell.active != null && spell.active.cast != null && spell.active.cast.channel_ticks > 0;
    }

    private int getWindUpTicks(Spell spell) {
        return spell.active != null && spell.active.cast != null ? (int)(spell.active.cast.duration * 20.0f) : 20;
    }

    private int getChannelDuration(Spell spell) {
        return spell.active != null && spell.active.cast != null ? spell.active.cast.channel_ticks : 0;
    }

    private int getCooldownTicks(Spell spell) {
        return spell.cost != null && spell.cost.cooldown != null ? (int)(spell.cost.cooldown.duration * 20.0f) : 20;
    }

    private void playSpellSound(Spell spell) {
        class_2960 soundId;
        if (spell.release != null && spell.release.sound != null && (soundId = class_2960.method_12829((String)spell.release.sound.id())) != null) {
            class_3414 sound = (class_3414)class_7923.field_41172.method_10223(soundId);
            this.actor.method_37908().method_8396(null, this.actor.method_24515(), sound, class_3419.field_15251, 1.0f, 1.0f);
        }
    }
}

