/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.pickup;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundFilterSettingsPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class AutoPickupWidget
extends UpgradeWidgetBase<AutoPickupUpgrade> {
    private final FilterButton<AutoPickupWidget> whitelistButton;
    private final FilterButton<AutoPickupWidget> objectButton;
    private final FilterButton<AutoPickupWidget> ignoreModeButton;
    private static final List<class_2561> WHITELIST_TOOLTIPS = List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_allow"), class_2561.method_43471((String)"screen.travelersbackpack.filter_block"), class_2561.method_43471((String)"screen.travelersbackpack.filter_match_contents"));
    private static final List<class_2561> OBJECT_TOOLTIPS = List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_item"), class_2561.method_43471((String)"screen.travelersbackpack.filter_modid"));
    private static final List<class_2561> IGNORE_MODE_TOOLTIPS = List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_match_components"), class_2561.method_43471((String)"screen.travelersbackpack.filter_ignore_components"));

    public AutoPickupWidget(BackpackScreen screen, AutoPickupUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 0), "screen.travelersbackpack.pickup_upgrade");
        this.whitelistButton = new FilterButton<AutoPickupWidget>(this, upgrade.getFilter().get(0), ButtonStates.ALLOW, new Point(pos.x() + 6, pos.y() + 22));
        this.objectButton = new FilterButton<AutoPickupWidget>(this, upgrade.getFilter().get(1), ButtonStates.OBJECT_TYPE, new Point(pos.x() + 6 + 18, pos.y() + 22));
        this.ignoreModeButton = new FilterButton<AutoPickupWidget>(this, upgrade.getFilter().get(2), ButtonStates.IGNORE_MODE, new Point(pos.x() + 6 + 36, pos.y() + 22));
    }

    @Override
    public void renderBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, x, y, mouseX, mouseY);
        this.renderMatchContentsSlotOverlay(guiGraphics, ((AutoPickupUpgrade)this.upgrade).getFilter(), 0, 2, TravelersBackpackConfig.getConfig().backpackUpgrades.pickupUpgradeSettings.filterSlotCount);
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isTabOpened()) {
            this.whitelistButton.renderButton(guiGraphics, mouseX, mouseY);
            this.objectButton.renderButton(guiGraphics, mouseX, mouseY);
            this.ignoreModeButton.renderButton(guiGraphics, mouseX, mouseY);
        }
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isTabOpened()) {
            if (this.whitelistButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), WHITELIST_TOOLTIPS.get(this.whitelistButton.getCurrentState()), mouseX, mouseY);
            }
            if (this.objectButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), OBJECT_TOOLTIPS.get(this.objectButton.getCurrentState()), mouseX, mouseY);
            }
            if (this.ignoreModeButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), IGNORE_MODE_TOOLTIPS.get(this.ignoreModeButton.getCurrentState()), mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.isTabOpened() && this.isBackpackOwner()) {
            if (this.whitelistButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer(new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.objectButton.getCurrentState()), Integer.valueOf(this.ignoreModeButton.getCurrentState()))));
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.objectButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer(new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.objectButton.getCurrentState()), Integer.valueOf(this.ignoreModeButton.getCurrentState()))));
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.ignoreModeButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer(new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.objectButton.getCurrentState()), Integer.valueOf(this.ignoreModeButton.getCurrentState()))));
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }
}

