/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import com.tiviacz.travelersbackpack.network.ServerboundFilterSettingsPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class FeedingWidget
extends UpgradeWidgetBase<FeedingUpgrade> {
    private final FilterButton<FeedingWidget> whitelistButton;
    private final FilterButton<FeedingWidget> hungerModeButton;
    private final FilterButton<FeedingWidget> ignoreEffectModeButton;
    private static final List<class_2561> WHITELIST_TOOLTIPS = List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_allow"), class_2561.method_43471((String)"screen.travelersbackpack.filter_block"));
    private static final List<class_2561> HUNGER_MODE_TOOLTIPS = List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_always_eat"), class_2561.method_43471((String)"screen.travelersbackpack.filter_half_nutrition"), class_2561.method_43471((String)"screen.travelersbackpack.filter_full_nutrition"));
    private static final List<class_2561> IGNORE_MODE_TOOLTIPS = List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_block_bad_effects"), class_2561.method_43471((String)"screen.travelersbackpack.filter_allow_bad_effects"));

    public FeedingWidget(BackpackScreen screen, FeedingUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 0), "screen.travelersbackpack.feeding_upgrade");
        this.whitelistButton = new FilterButton<FeedingWidget>(this, upgrade.getFilter().get(0), ButtonStates.ALLOW_FEEDING, new Point(pos.x() + 6, pos.y() + 22));
        this.hungerModeButton = new FilterButton<FeedingWidget>(this, upgrade.getFilter().get(1), ButtonStates.HUNGER_MODE, new Point(pos.x() + 6 + 18, pos.y() + 22));
        this.ignoreEffectModeButton = new FilterButton<FeedingWidget>(this, upgrade.getFilter().get(2), ButtonStates.IGNORE_EFFECT_MODE, new Point(pos.x() + 6 + 36, pos.y() + 22));
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isTabOpened()) {
            this.whitelistButton.renderButton(guiGraphics, mouseX, mouseY);
            this.hungerModeButton.renderButton(guiGraphics, mouseX, mouseY);
            this.ignoreEffectModeButton.renderButton(guiGraphics, mouseX, mouseY);
        }
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isTabOpened()) {
            if (this.whitelistButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), WHITELIST_TOOLTIPS.get(this.whitelistButton.getCurrentState()), mouseX, mouseY);
            }
            if (this.hungerModeButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), HUNGER_MODE_TOOLTIPS.get(this.hungerModeButton.getCurrentState()), mouseX, mouseY);
            }
            if (this.ignoreEffectModeButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.method_51438(((BackpackScreen)this.screen).getFont(), IGNORE_MODE_TOOLTIPS.get(this.ignoreEffectModeButton.getCurrentState()), mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.isTabOpened() && this.isBackpackOwner()) {
            if (this.whitelistButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer(new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.hungerModeButton.getCurrentState()), Integer.valueOf(this.ignoreEffectModeButton.getCurrentState()))));
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.hungerModeButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer(new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.hungerModeButton.getCurrentState()), Integer.valueOf(this.ignoreEffectModeButton.getCurrentState()))));
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.ignoreEffectModeButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer(new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.hungerModeButton.getCurrentState()), Integer.valueOf(this.ignoreEffectModeButton.getCurrentState()))));
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }
}

