/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.world;

import com.sonicether.soundphysics.world.ClientLevelProxy;
import com.sonicether.soundphysics.world.ClonedLevelChunk;
import com.sonicether.soundphysics.world.ClonedLevelHeightAccessor;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_631;
import net.minecraft.class_638;

public class ClonedClientLevel
implements ClientLevelProxy {
    private final ClonedLevelHeightAccessor heightAccessor;
    private final HashMap<class_1923, ClonedLevelChunk> clonedLevelChunks;
    private final class_2338 clonedLevelOrigin;
    private final long clonedLevelTick;

    public ClonedClientLevel(class_638 level, class_2338 origin, long tick, int range) {
        class_631 cache = level.method_2935();
        ClonedLevelHeightAccessor heightAccessor = new ClonedLevelHeightAccessor((class_1937)level);
        HashMap<class_1923, ClonedLevelChunk> cachedLevelChunks = new HashMap<class_1923, ClonedLevelChunk>();
        class_1923 originChunkPos = new class_1923(origin.method_10263() >> 4, origin.method_10260() >> 4);
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                class_1923 chunkPos = new class_1923(originChunkPos.field_9181 + x, originChunkPos.field_9180 + z);
                class_2818 chunk = cache.method_12126(chunkPos.field_9181, chunkPos.field_9180, false);
                if (chunk == null) continue;
                ClonedLevelChunk clonedChunk = new ClonedLevelChunk((class_1937)level, chunkPos, chunk.method_12006());
                cachedLevelChunks.put(chunkPos, clonedChunk);
            }
        }
        this.heightAccessor = heightAccessor;
        this.clonedLevelOrigin = origin;
        this.clonedLevelTick = tick;
        this.clonedLevelChunks = cachedLevelChunks;
    }

    public class_2338 getOrigin() {
        return this.clonedLevelOrigin;
    }

    public long getTick() {
        return this.clonedLevelTick;
    }

    public ClonedLevelChunk getChunk(int x, int z) {
        class_1923 chunkPos = new class_1923(x, z);
        return this.clonedLevelChunks.get(chunkPos);
    }

    public class_2680 method_8320(@Nonnull class_2338 blockPos) {
        if (this.method_31606(blockPos)) {
            return class_2246.field_10243.method_9564();
        }
        class_1923 chunkPos = new class_1923(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4);
        ClonedLevelChunk levelChunk = this.clonedLevelChunks.get(chunkPos);
        if (levelChunk == null) {
            return class_2246.field_10243.method_9564();
        }
        return levelChunk.method_8320(blockPos);
    }

    public class_3610 method_8316(@Nonnull class_2338 blockPos) {
        if (this.method_31606(blockPos)) {
            return class_3612.field_15906.method_15785();
        }
        class_1923 chunkPos = new class_1923(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4);
        ClonedLevelChunk levelChunk = this.clonedLevelChunks.get(chunkPos);
        if (levelChunk == null) {
            return class_3612.field_15906.method_15785();
        }
        return levelChunk.method_8316(blockPos);
    }

    public int method_31605() {
        return this.heightAccessor.method_31605();
    }

    public int method_31607() {
        return this.heightAccessor.method_31607();
    }

    public class_2586 method_8321(@Nonnull class_2338 blockPos) {
        class_1923 chunkPos = new class_1923(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4);
        ClonedLevelChunk levelChunk = this.clonedLevelChunks.get(chunkPos);
        if (levelChunk == null) {
            return null;
        }
        return levelChunk.method_8321(blockPos);
    }
}

