/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.server.world.gen.feature.coveredrock;

import com.github.thedeathlycow.frostiful.registry.tag.FBlockTags;
import com.github.thedeathlycow.frostiful.server.world.gen.feature.coveredrock.CoveredRockFeatureConfig;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6796;

public class CoveredRockFeature
extends class_3031<CoveredRockFeatureConfig> {
    public CoveredRockFeature(Codec<CoveredRockFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<CoveredRockFeatureConfig> context) {
        Optional<class_2338> origin = this.lookForGround(context);
        if (origin.isPresent()) {
            class_2338 placeAt = origin.get();
            class_5819 random = context.method_33654();
            for (int i = 0; i < 3; ++i) {
                this.placeRock(context, placeAt);
                int delta = 2;
                placeAt = placeAt.method_10069(-1 + random.method_43048(delta), -random.method_43048(delta), -1 + random.method_43048(delta));
            }
            return true;
        }
        return false;
    }

    private void placeRock(class_5821<CoveredRockFeatureConfig> context, class_2338 origin) {
        class_2680 current;
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        CoveredRockFeatureConfig config = (CoveredRockFeatureConfig)context.method_33656();
        int dx = config.size().sizeX().method_35008(random);
        int dy = config.size().sizeY().method_35008(random);
        int dz = config.size().sizeZ().method_35008(random);
        float maxSquareDistance = class_3532.method_27285((float)((float)(dx + dy + dz) / 3.0f + 0.5f));
        class_2338 from = origin.method_10069(-dx, -dy, -dz);
        class_2338 to = origin.method_10069(dx, dy == 0 ? 1 : dy, dz);
        for (class_2338 pos : class_2338.method_10097((class_2338)from, (class_2338)to)) {
            current = world.method_8320(pos);
            if (!(pos.method_10262((class_2382)origin) < (double)maxSquareDistance) || current.method_26164(FBlockTags.COVERED_ROCKS_CANNOT_REPLACE)) continue;
            class_2680 baseState = config.base().method_23455(random, pos);
            world.method_8652(pos, baseState, 3);
        }
        from = from.method_10069(-1, -1, -1);
        to = to.method_10069(1, 1, 1);
        for (class_2338 pos : class_2338.method_10097((class_2338)from, (class_2338)to)) {
            current = world.method_8320(pos);
            if (!this.isCoveringReplaceable(current) || !(random.method_43057() < config.placeCoveringChance())) continue;
            this.tryPlaceCovering(context, pos);
        }
    }

    private void tryPlaceCovering(class_5821<CoveredRockFeatureConfig> context, class_2338 origin) {
        CoveredRockFeatureConfig config = (CoveredRockFeatureConfig)context.method_33656();
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        ((class_6796)config.coveringFeature().comp_349()).method_39644(world, context.method_33653(), random, origin);
    }

    private Optional<class_2338> lookForGround(class_5821<CoveredRockFeatureConfig> context) {
        class_5281 world = context.method_33652();
        class_2338 current = context.method_33655();
        while (current.method_10264() > world.method_31607() + 3) {
            if (!world.method_22347(current.method_10074()) && this.canPlaceAtPos(world, current)) {
                return Optional.of(current);
            }
            current = current.method_10074();
        }
        return Optional.empty();
    }

    private boolean canPlaceAtPos(class_5281 world, class_2338 pos) {
        class_2680 below = world.method_8320(pos);
        return CoveredRockFeature.method_23396((class_2680)below) || CoveredRockFeature.method_23395((class_2680)below);
    }

    private boolean isCoveringReplaceable(class_2680 state) {
        return state.method_26215() || state.method_26164(FBlockTags.COVERED_ROCK_COVERING_REPLACEABLE);
    }
}

