/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.entity.component;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class SnowAccumulationComponent
implements Component,
ServerTickingComponent {
    private static final class_1322 SOAKED_MODIFIER = new class_1322(Frostiful.id("soaked_cold_vulnerability"), -1.0, class_1322.class_1323.field_6331);
    private static final String KEY = "snow_accumulation";
    private final class_1309 provider;
    private int snowAccumulation = 0;
    private boolean appliedSoakedModifiers = false;

    public SnowAccumulationComponent(class_1309 provider) {
        this.provider = provider;
    }

    public static SnowAccumulationComponent get(class_1309 provider) {
        return (SnowAccumulationComponent)FComponents.SNOW_ACCUMULATION.get((Object)provider);
    }

    public void serverTick() {
        if (this.isBeingSnowedOn()) {
            this.addSnowAccumulation();
        } else {
            this.meltSnowAccumulation();
        }
        if (Frostiful.getConfig().environmentConfig.applyEnvironmentPenaltyWhenWet()) {
            this.applySoakedEnvironmentFrostResistancePenalty();
        }
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.snowAccumulation = tag.method_10573(KEY, 3) ? tag.method_10550(KEY) : 0;
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (this.snowAccumulation > 0) {
            tag.method_10569(KEY, this.snowAccumulation);
        }
    }

    public boolean isBeingSnowedOn() {
        class_2338 pos;
        class_1937 world = this.provider.method_37908();
        return SnowAccumulationComponent.hasSnow(world, pos = this.provider.method_24515()) || SnowAccumulationComponent.hasSnow(world, class_2338.method_49637((double)pos.method_10263(), (double)this.provider.method_5829().field_1325, (double)pos.method_10260()));
    }

    public static boolean hasSnow(class_1937 world, class_2338 pos) {
        if (!world.method_8419()) {
            return false;
        }
        if (!world.method_8311(pos)) {
            return false;
        }
        if (world.method_8598(class_2902.class_2903.field_13197, pos).method_10264() > pos.method_10264()) {
            return false;
        }
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        return biome.method_48162(pos) == class_1959.class_1963.field_9383;
    }

    public void meltSnowAccumulation() {
        if (this.snowAccumulation > 0) {
            --this.snowAccumulation;
            this.provider.thermoo$addWetTicks(2);
        }
    }

    private void addSnowAccumulation() {
        if (this.snowAccumulation < Frostiful.getConfig().environmentConfig.getMaxSnowAccumulationTicks()) {
            ++this.snowAccumulation;
        }
    }

    private void applySoakedEnvironmentFrostResistancePenalty() {
        class_1324 envFrostResistance;
        boolean wet = this.provider.thermoo$isWet();
        if (wet && !this.appliedSoakedModifiers && !this.provider.thermoo$ignoresFrigidWater()) {
            class_1324 envFrostResistance2 = this.provider.method_5996(ThermooAttributes.ENVIRONMENT_FROST_RESISTANCE);
            if (envFrostResistance2 != null) {
                envFrostResistance2.method_26835(SOAKED_MODIFIER);
                this.appliedSoakedModifiers = true;
                Frostiful.LOGGER.debug("Applied soaked env frost resistance penalty");
            }
        } else if (!wet && this.appliedSoakedModifiers && (envFrostResistance = this.provider.method_5996(ThermooAttributes.ENVIRONMENT_FROST_RESISTANCE)) != null) {
            envFrostResistance.method_6202(SOAKED_MODIFIER);
            this.appliedSoakedModifiers = false;
            Frostiful.LOGGER.debug("Removed soaked env frost resistance penalty");
        }
    }
}

