/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.client.registry;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.client.model.IceSkateModel;
import com.github.thedeathlycow.frostiful.client.registry.FEntityModelLayers;
import com.github.thedeathlycow.frostiful.client.render.entity.BiterEntityRenderer;
import com.github.thedeathlycow.frostiful.client.render.entity.ChillagerEntityRenderer;
import com.github.thedeathlycow.frostiful.client.render.entity.FrostSpellEntityRenderer;
import com.github.thedeathlycow.frostiful.client.render.entity.FrostologerEntityRenderer;
import com.github.thedeathlycow.frostiful.client.render.entity.GlacialArrowEntityRenderer;
import com.github.thedeathlycow.frostiful.client.render.entity.ThrownIcicleEntityRenderer;
import com.github.thedeathlycow.frostiful.client.render.feature.IceSkateFeatureRenderer;
import com.github.thedeathlycow.frostiful.registry.FEntityTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.minecraft.class_1007;
import net.minecraft.class_6344;
import net.minecraft.class_877;
import net.minecraft.class_908;
import net.minecraft.class_909;
import net.minecraft.class_953;

@Environment(value=EnvType.CLIENT)
public class FEntityRenderers {
    public static void initialize() {
        Frostiful.LOGGER.debug("Initialized Frostiful entity renderers");
        EntityRendererRegistry.register(FEntityTypes.GLACIAL_ARROW, GlacialArrowEntityRenderer::new);
        EntityRendererRegistry.register(FEntityTypes.FROST_SPELL, FrostSpellEntityRenderer::new);
        EntityRendererRegistry.register(FEntityTypes.FROSTOLOGER, FrostologerEntityRenderer::new);
        EntityRendererRegistry.register(FEntityTypes.CHILLAGER, ChillagerEntityRenderer::new);
        EntityRendererRegistry.register(FEntityTypes.BITER, BiterEntityRenderer::new);
        EntityRendererRegistry.register(FEntityTypes.PACKED_SNOWBALL, class_953::new);
        EntityRendererRegistry.register(FEntityTypes.THROWN_ICICLE, ThrownIcicleEntityRenderer::new);
        EntityRendererRegistry.register(FEntityTypes.FREEZING_WIND, class_6344::new);
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
            if (entityRenderer instanceof class_909) {
                class_909 bipedEntityRenderer = (class_909)entityRenderer;
                registrationHelper.register(new IceSkateFeatureRenderer(bipedEntityRenderer, new IceSkateModel(context.method_32167(FEntityModelLayers.ICE_SKATES))));
            } else if (entityRenderer instanceof class_1007) {
                class_1007 playerEntityRenderer = (class_1007)entityRenderer;
                registrationHelper.register(new IceSkateFeatureRenderer(playerEntityRenderer, new IceSkateModel(context.method_32167(FEntityModelLayers.ICE_SKATES))));
            } else if (entityRenderer instanceof class_877) {
                class_877 armorStandEntityRenderer = (class_877)entityRenderer;
                registrationHelper.register(new IceSkateFeatureRenderer(armorStandEntityRenderer, new IceSkateModel(context.method_32167(FEntityModelLayers.ICE_SKATES))));
            } else if (entityRenderer instanceof class_908) {
                class_908 giantEntityRenderer = (class_908)entityRenderer;
                registrationHelper.register(new IceSkateFeatureRenderer(giantEntityRenderer, new IceSkateModel(context.method_32167(FEntityModelLayers.ICE_SKATES))));
            }
        });
    }

    private FEntityRenderers() {
    }
}

