/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.mixin;

import java.util.List;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.Difficulty;
import net.dungeon_difficulty.logic.DifficultyHandler;
import net.dungeon_difficulty.logic.PatternMatching;
import net.dungeon_difficulty.util.LanguageUtil;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
public abstract class ServerWorldMixin {
    @Unique
    private static final int ANNOUNCEMENT_MEMORY = 2;

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void pre_tick(CallbackInfo ci) {
        class_3218 world = (class_3218)this;
        Config.Announcement config = ((Config)DungeonDifficulty.config.value).announcement;
        if (!config.enabled) {
            return;
        }
        int check_interval = config.check_interval_seconds * 20;
        for (class_3222 player : world.method_18456()) {
            if (player.method_7325()) continue;
            List<Difficulty.Announcement> previousAnnouncements = ((DifficultyHandler)player).getLastDifficultyAnnouncements();
            if ((player.field_6012 + player.method_5628()) % check_interval != 0) continue;
            PatternMatching.LocationData locationData = PatternMatching.LocationData.create(world, player.method_24515());
            PatternMatching.DifficultySearchResult difficultyResult = PatternMatching.getDifficultyResult(locationData, null, PatternMatching.ScalingGoal.ENTITY, world);
            if (difficultyResult != null && difficultyResult.difficulty().isValid()) {
                this.announce(difficultyResult, player);
                continue;
            }
            if (previousAnnouncements.contains(Difficulty.Announcement.EMPTY)) continue;
            previousAnnouncements.add(Difficulty.Announcement.EMPTY);
            if (previousAnnouncements.size() <= config.history_size) continue;
            previousAnnouncements.removeFirst();
        }
    }

    @Unique
    private void announce(PatternMatching.DifficultySearchResult difficultyResult, class_3222 player) {
        Difficulty difficulty = difficultyResult.difficulty();
        PatternMatching.LocationData locationData = difficultyResult.locationData();
        ((DifficultyHandler)player).getLastDifficultyAnnouncements();
        Difficulty.Announcement announcement = new Difficulty.Announcement(difficulty, player.field_6012, locationData.dimensionId(), difficultyResult.matchId());
        List<Difficulty.Announcement> announcements = ((DifficultyHandler)player).getLastDifficultyAnnouncements();
        for (Difficulty.Announcement previous : announcements) {
            if (!previous.equals(announcement)) continue;
            return;
        }
        announcements.add(announcement);
        Config.Announcement config = ((Config)DungeonDifficulty.config.value).announcement;
        if (announcements.size() > config.history_size) {
            announcements.removeFirst();
        }
        String title = "Dungeon";
        if (difficultyResult.match() != null) {
            PatternMatching.LocationData.Match match = difficultyResult.match();
            if (match.matchingStructure() != null) {
                class_2960 id = ((class_5321)match.matchingStructure().method_40230().get()).method_29177();
                title = LanguageUtil.translateId("structure", id.toString());
            } else if (match.matchingBiome() != null && match.matchingBiome().method_40230().isPresent()) {
                class_2960 id = ((class_5321)match.matchingBiome().method_40230().get()).method_29177();
                title = LanguageUtil.translateId("biome", id.toString());
            }
        } else {
            class_6880<class_1959> biome = difficultyResult.locationData().biome().biomeEntry();
            if (biome.method_40230().isPresent()) {
                class_2960 id = ((class_5321)biome.method_40230().get()).method_29177();
                title = LanguageUtil.translateId("biome", id.toString());
            }
        }
        player.field_13987.method_14364((class_2596)new class_5904((class_2561)class_2561.method_43471((String)title)));
        player.field_13987.method_14364((class_2596)new class_5903((class_2561)class_2561.method_43471((String)difficulty.typeTranslationKey()).method_27693(" " + difficulty.level())));
    }
}

