/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.mixin;

import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.MathHelper;
import net.dungeon_difficulty.logic.PatternMatching;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1569;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1917.class})
public class MobSpawnerLogicMixin {
    @Shadow
    private int field_9157;
    @Shadow
    private int field_9149;
    @Shadow
    private int field_9160;
    @Shadow
    private int field_9151;
    @Shadow
    private int field_9150;
    @Shadow
    private int field_9158;
    @Shadow
    private class_1952 field_9155;
    private boolean initialized = false;
    private static String modifiedKey = "modified_by_" + DungeonDifficulty.MODID;

    @Inject(method={"serverTick"}, at={@At(value="HEAD")})
    private void pre_serverTick(class_3218 world, class_2338 pos, CallbackInfo ci) {
        if (!this.initialized) {
            if (this.field_9155 == null || this.field_9155.method_38093() == null || this.field_9155.method_38093().method_10545(modifiedKey)) {
                return;
            }
            try {
                String entityId = this.field_9155.method_38093().method_10558("id");
                class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(class_2960.method_60654((String)entityId));
                class_1297 testEntity = entityType.method_5883((class_1937)world);
                boolean isMonster = testEntity instanceof class_1569;
                PatternMatching.EntityData entityData = new PatternMatching.EntityData(entityId, isMonster);
                PatternMatching.LocationData locationData = PatternMatching.LocationData.create(world, pos);
                PatternMatching.SpawnerScaleResult scaling = PatternMatching.getModifiersForSpawner(locationData, entityData, world);
                this.scaleSpawner(scaling);
                this.initialized = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void scaleSpawner(PatternMatching.SpawnerScaleResult scaling) {
        float spawnRange = 0.0f;
        float spawnCount = 0.0f;
        float maxNearbyEntities = 0.0f;
        float minSpawnDelay = 0.0f;
        float maxSpawnDelay = 0.0f;
        float requiredPlayerRange = 0.0f;
        for (Config.SpawnerModifier modifier : scaling.modifiers()) {
            spawnRange += (float)scaling.level() * modifier.spawn_range_multiplier;
            spawnCount += (float)scaling.level() * modifier.spawn_count_multiplier;
            maxNearbyEntities += (float)scaling.level() * modifier.max_nearby_entities_multiplier;
            minSpawnDelay += (float)scaling.level() * modifier.min_spawn_delay_multiplier;
            maxSpawnDelay += (float)scaling.level() * modifier.max_spawn_delay_multiplier;
            requiredPlayerRange += (float)scaling.level() * modifier.required_player_range_multiplier;
        }
        this.field_9157 = MathHelper.clamp(Math.round((float)this.field_9157 * (1.0f + spawnRange)), 0, 100);
        this.field_9149 = MathHelper.clamp(Math.round((float)this.field_9149 * (1.0f + spawnCount)), 1, 20);
        this.field_9160 = MathHelper.clamp(Math.round((float)this.field_9160 * (1.0f + maxNearbyEntities)), 0, 40);
        this.field_9151 = MathHelper.clamp(Math.round((float)this.field_9151 * (1.0f + minSpawnDelay)), 10, 20000);
        this.field_9150 = MathHelper.clamp(Math.round((float)this.field_9150 * (1.0f + maxSpawnDelay)), 20, 20000);
        this.field_9158 = MathHelper.clamp(Math.round((float)this.field_9158 * (1.0f + requiredPlayerRange)), 1, 200);
        if (scaling.modifiers().size() > 0) {
            this.field_9155.method_38093().method_10556(modifiedKey, true);
        }
    }
}

