/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.Difficulty;
import net.dungeon_difficulty.logic.DifficultyTypes;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class PatternMatching {
    public static final String TAG_PREFIX = "#";
    public static final String REGEX_PREFIX = "~";

    private static boolean isInsideStructure(class_3218 world, class_2338 pos, class_3449 structureStart) {
        if (structureStart.method_16657()) {
            return structureStart.method_14969().method_14662((class_2382)pos);
        }
        return false;
    }

    public static ItemScaleResult getModifiersForItem(LocationData locationData, ItemData itemData, class_3218 world) {
        ArrayList<Config.AttributeModifier> attributeModifiers = new ArrayList<Config.AttributeModifier>();
        DifficultySearchResult result = PatternMatching.getDifficultyResult(locationData, itemData.lootTableId(), ScalingGoal.LOOT, world);
        int level = 0;
        if (result != null && result.difficulty() != null) {
            Difficulty difficulty = result.difficulty();
            level = difficulty.rewardLevel();
            Config.Rewards rewards = difficulty.type().rewards;
            if (rewards != null) {
                List<Config.ItemModifier> itemModifiers = null;
                switch (itemData.kind.ordinal()) {
                    case 0: {
                        itemModifiers = rewards.armor;
                        break;
                    }
                    case 1: {
                        itemModifiers = rewards.weapons;
                    }
                }
                if (itemModifiers != null) {
                    for (Config.ItemModifier entry : itemModifiers) {
                        if (!itemData.matches(entry.item_matches)) continue;
                        attributeModifiers.addAll(Arrays.asList(entry.attributes));
                    }
                }
            }
        }
        return new ItemScaleResult(attributeModifiers, level);
    }

    public static EntityScaleResult getAttributeModifiersForEntity(LocationData locationData, EntityData entityData, class_3218 world) {
        ArrayList<Config.AttributeModifier> attributeModifiers = new ArrayList<Config.AttributeModifier>();
        Difficulty difficulty = PatternMatching.getDifficulty(locationData, world);
        int level = 0;
        float experienceMultiplier = 0.0f;
        if (difficulty != null && (level = difficulty.entityLevel()) != 0) {
            for (Config.EntityModifier modifier : PatternMatching.getModifiersForEntity(difficulty.type().entities, entityData)) {
                attributeModifiers.addAll(Arrays.asList(modifier.attributes));
                experienceMultiplier += modifier.experience_multiplier;
            }
        }
        return new EntityScaleResult(attributeModifiers, level, experienceMultiplier);
    }

    public static SpawnerScaleResult getModifiersForSpawner(LocationData locationData, EntityData entityData, class_3218 world) {
        ArrayList<Config.SpawnerModifier> spawnerModifiers = new ArrayList<Config.SpawnerModifier>();
        Difficulty difficulty = PatternMatching.getDifficulty(locationData, world);
        int level = 0;
        if (difficulty != null && (level = difficulty.entityLevel()) != 0) {
            for (Config.EntityModifier modifier : PatternMatching.getModifiersForEntity(difficulty.type().entities, entityData)) {
                if (modifier.spawners == null) continue;
                spawnerModifiers.add(modifier.spawners);
            }
        }
        return new SpawnerScaleResult(spawnerModifiers, level);
    }

    public static List<Config.EntityModifier> getModifiersForEntity(List<Config.EntityModifier> definitions, EntityData entityData) {
        ArrayList<Config.EntityModifier> entityModifiers = new ArrayList<Config.EntityModifier>();
        for (Config.EntityModifier entityModifier : definitions) {
            if (!entityData.matches(entityModifier.entity_matches)) continue;
            entityModifiers.add(entityModifier);
        }
        return entityModifiers;
    }

    @Nullable
    public static Difficulty getDifficulty(LocationData locationData, class_3218 world) {
        return PatternMatching.getDifficulty(locationData, null, world);
    }

    @Nullable
    public static Difficulty getDifficulty(LocationData locationData, @Nullable class_2960 sourceId, class_3218 world) {
        DifficultySearchResult result = PatternMatching.getDifficultyResult(locationData, sourceId, ScalingGoal.ENTITY, world);
        if (result != null) {
            return result.difficulty();
        }
        return null;
    }

    @Nullable
    public static DifficultySearchResult getDifficultyResult(LocationData locationData, @Nullable class_2960 sourceId, ScalingGoal scalingGoal, class_3218 world) {
        for (Config.Dimension dimension : ((Config)DungeonDifficulty.config.value).dimensions) {
            if (!locationData.matches(dimension.world_matches)) continue;
            Difficulty dimensionDifficulty = PatternMatching.findDifficulty(dimension.difficulty);
            if (dimension.zones != null) {
                DifficultySearchResult entityDifficulty;
                DifficultySearchResult result;
                DifficultySearchResult zoneResult = null;
                for (Config.Zone zone : dimension.zones) {
                    Difficulty zoneDifficulty;
                    LocationData.Match match = locationData.matches(zone.zone_matches, world);
                    if (!match.matches() || (zoneDifficulty = PatternMatching.findDifficulty(zone.difficulty)) == null || !zoneDifficulty.isValid()) continue;
                    zoneResult = new DifficultySearchResult(zoneDifficulty, locationData, match);
                    break;
                }
                if ((result = PatternMatching.chooseHigherDifficulty(zoneResult, entityDifficulty = PatternMatching.matchEntityDifficulty(locationData, sourceId, scalingGoal, dimension.entities))) != null) {
                    return result;
                }
            }
            if (dimensionDifficulty == null || !dimensionDifficulty.isValid()) continue;
            return new DifficultySearchResult(dimensionDifficulty, locationData, null);
        }
        return null;
    }

    private static DifficultySearchResult chooseHigherDifficulty(@Nullable DifficultySearchResult a, @Nullable DifficultySearchResult b) {
        int bLevel;
        if (a == null && b == null) {
            return null;
        }
        int aLevel = a != null ? a.difficulty().level() : -100;
        int n = bLevel = b != null ? b.difficulty().level() : -100;
        if (aLevel >= bLevel) {
            return a;
        }
        return b;
    }

    @Nullable
    private static DifficultySearchResult matchEntityDifficulty(LocationData locationData, @Nullable class_2960 sourceId, ScalingGoal scalingGoal, List<Config.EntityMatcher> matchers) {
        if (sourceId != null) {
            for (Config.EntityMatcher entityMatcher : matchers) {
                switch (scalingGoal.ordinal()) {
                    case 0: {
                        Optional entityTypeEntry;
                        if (entityMatcher.entity_type == null || (entityTypeEntry = class_7923.field_41177.method_55841(sourceId)).isEmpty() || !PatternMatching.universalMatch((class_6880)entityTypeEntry.get(), class_7924.field_41266, entityMatcher.entity_type)) break;
                        Difficulty difficulty = PatternMatching.findDifficulty(entityMatcher.difficulty);
                        return new DifficultySearchResult(difficulty, locationData, null);
                    }
                    case 1: {
                        if (entityMatcher.loot_table == null || !PatternMatching.regexMatches(sourceId.toString(), entityMatcher.loot_table)) break;
                        Difficulty difficulty = PatternMatching.findDifficulty(entityMatcher.difficulty);
                        return new DifficultySearchResult(difficulty, locationData, null);
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private static Difficulty findDifficulty(Config.DifficultyReference reference) {
        if (reference == null) {
            return null;
        }
        String name = reference.name;
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (Config.DifficultyType entry : DifficultyTypes.resolved) {
            if (!name.equals(entry.name)) continue;
            int rewardLevel = reference.reward_level != null ? reference.reward_level : reference.level;
            int entityLevel = reference.entity_level != null ? reference.entity_level : reference.level;
            return new Difficulty(entry, reference.level, entityLevel, rewardLevel);
        }
        return null;
    }

    public static boolean matches(String subject, @Nullable String nullableRegex) {
        if (subject == null) {
            subject = "";
        }
        if (nullableRegex == null || nullableRegex.isEmpty()) {
            return true;
        }
        Pattern pattern = Pattern.compile(nullableRegex, 2);
        Matcher matcher = pattern.matcher(subject);
        return matcher.find();
    }

    public static <T> boolean universalMatch(class_6880<T> entry, class_5321<class_2378<T>> registryKey, @Nullable String pattern) {
        if (pattern == null) {
            return true;
        }
        if (pattern.startsWith(TAG_PREFIX)) {
            class_6862 tag = class_6862.method_40092(registryKey, (class_2960)class_2960.method_60654((String)pattern.substring(1)));
            return entry.method_40220(tag);
        }
        String id = ((class_5321)entry.method_40230().get()).method_29177().toString();
        if (pattern.startsWith(REGEX_PREFIX)) {
            return PatternMatching.regexMatches(id, pattern.substring(1));
        }
        return id.equals(pattern);
    }

    public static <T> boolean universalMatchNoTag(class_6880<T> entry, class_5321<class_2378<T>> registryKey, @Nullable String pattern) {
        if (pattern == null) {
            return true;
        }
        if (pattern.startsWith(TAG_PREFIX)) {
            class_6862 tag = class_6862.method_40092(registryKey, (class_2960)class_2960.method_60654((String)pattern.substring(1)));
            return entry.method_40220(tag);
        }
        String id = ((class_5321)entry.method_40230().get()).method_29177().toString();
        return PatternMatching.regexMatches(id, pattern);
    }

    public static boolean regexMatches(String subject, String regex) {
        if (subject == null) {
            return false;
        }
        if (regex == null || regex.isEmpty() || regex.equals("*") || subject.equals(regex)) {
            return true;
        }
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(subject);
        return matcher.find();
    }

    public record ItemData(ItemKind kind, class_2960 lootTableId, String itemId, String rarity) {
        public boolean matches(Config.ItemModifier.Filters filters) {
            if (filters == null) {
                return true;
            }
            boolean result = PatternMatching.matches(this.itemId, filters.item_id_regex) && PatternMatching.matches(this.lootTableId.toString(), filters.loot_table_regex) && PatternMatching.matches(this.rarity, filters.rarity_regex);
            return result;
        }
    }

    public static enum ScalingGoal {
        ENTITY,
        LOOT;

    }

    public record LocationData(String dimensionId, class_2338 position, BiomeData biome) {
        public static LocationData create(class_3218 world, class_2338 position) {
            String dimensionId = world.method_27983().method_29177().toString();
            BiomeData biome = null;
            if (position != null) {
                biome = new BiomeData((class_6880<class_1959>)world.method_23753(position));
            }
            return new LocationData(dimensionId, position, biome);
        }

        public boolean matches(Config.Dimension.Filters filters) {
            if (filters == null) {
                return true;
            }
            boolean result = PatternMatching.matches(this.dimensionId, filters.dimension_regex);
            return result;
        }

        public Match matches(Config.Zone.Filters filters, @Nullable class_3218 world) {
            if (filters == null || this.biome == null) {
                return Match.trueMatch();
            }
            boolean result = false;
            if (world == null) {
                return Match.falseMatch();
            }
            class_5455.class_6890 registries = world.method_8503().method_30611();
            Scope matchScope = Scope.DIMENSION;
            class_6880<class_1959> matchingBiome = null;
            if (filters.biome == null || filters.biome.isEmpty()) {
                result = true;
            } else if (PatternMatching.universalMatch(this.biome.biomeEntry, class_7924.field_41236, filters.biome)) {
                result = true;
                matchingBiome = this.biome.biomeEntry;
                matchScope = Scope.BIOME;
            }
            class_6880.class_6883 matchingStructure = null;
            if (result && filters.structure != null && !filters.structure.isEmpty()) {
                result = false;
                class_2378 registry = registries.method_30530(class_7924.field_41246);
                List structureStartsUnfiltered = world.method_27056().method_41035(new class_1923(this.position), s -> true);
                for (class_3449 structureStart : structureStartsUnfiltered) {
                    class_6880.class_6883 entry = registry.method_40265(registry.method_10206((Object)structureStart.method_16656())).orElse(null);
                    if (entry == null || !PatternMatching.universalMatch(entry, class_7924.field_41246, filters.structure) || !PatternMatching.isInsideStructure(world, this.position, structureStart)) continue;
                    matchingStructure = entry;
                    matchScope = Scope.STRUCTURE;
                    result = true;
                    break;
                }
            }
            return new Match(result, matchScope, matchingBiome, (class_6880<class_3195>)matchingStructure);
        }

        public record Match(boolean matches, Scope scope, @Nullable class_6880<class_1959> matchingBiome, @Nullable class_6880<class_3195> matchingStructure) {
            public static Match trueMatch() {
                return new Match(true, Scope.DIMENSION, null, null);
            }

            public static Match falseMatch() {
                return new Match(false, Scope.DIMENSION, null, null);
            }

            @Nullable
            public class_2960 id() {
                if (this.matchingBiome != null) {
                    return ((class_5321)this.matchingBiome.method_40230().get()).method_29177();
                }
                if (this.matchingStructure != null) {
                    return ((class_5321)this.matchingStructure.method_40230().get()).method_29177();
                }
                return null;
            }
        }

        public static enum Scope {
            DIMENSION,
            BIOME,
            STRUCTURE;

        }
    }

    public record DifficultySearchResult(Difficulty difficulty, LocationData locationData, LocationData.Match match) {
        @Nullable
        public class_2960 matchId() {
            return this.match != null ? this.match.id() : null;
        }
    }

    public static enum ItemKind {
        ARMOR,
        WEAPONS;

    }

    public record ItemScaleResult(List<Config.AttributeModifier> modifiers, int level) {
    }

    public record EntityData(String entityId, boolean isHostile) {
        public static EntityData create(class_1309 entity) {
            String entityId = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
            boolean isHostile = entity instanceof class_1569;
            return new EntityData(entityId, isHostile);
        }

        public boolean matches(Config.EntityModifier.Filters filters) {
            if (filters == null) {
                return true;
            }
            boolean matchesAttitude = true;
            if (filters.attitude != null) {
                switch (filters.attitude) {
                    case FRIENDLY: {
                        matchesAttitude = !this.isHostile;
                        break;
                    }
                    case HOSTILE: {
                        matchesAttitude = this.isHostile;
                        break;
                    }
                    case ANY: {
                        matchesAttitude = true;
                    }
                }
            }
            boolean result = matchesAttitude && PatternMatching.matches(this.entityId, filters.entity_id_regex);
            return result;
        }
    }

    public record EntityScaleResult(List<Config.AttributeModifier> modifiers, int level, float experienceMultiplier) {
    }

    public record SpawnerScaleResult(List<Config.SpawnerModifier> modifiers, int level) {
    }

    public record Location(Config.EntityModifier[] entities, Config.Rewards rewards) {
    }

    public record BiomeData(class_6880<class_1959> biomeEntry) {
    }
}

