/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.config;

import java.util.List;
import java.util.Random;
import org.jetbrains.annotations.Nullable;

public class Config {
    public Meta meta = new Meta(this);
    public Announcement announcement = new Announcement();
    public PerPlayerDifficulty per_player_difficulty;
    public List<DifficultyType> difficulty_types = List.of();
    public Dimension[] dimensions;

    public class Meta {
        public boolean sanitize_config = true;
        public Double rounding_unit = 0.5;
        public boolean merge_item_modifiers = true;

        public Meta(Config this$0) {
        }
    }

    public static class Announcement {
        public boolean enabled = true;
        public int check_interval_seconds = 5;
        public int history_size = 2;
    }

    public static class SpawnerModifier {
        public float spawn_range_multiplier = 0.0f;
        public float spawn_count_multiplier = 0.0f;
        public float max_nearby_entities_multiplier = 0.0f;
        public float min_spawn_delay_multiplier = 0.0f;
        public float max_spawn_delay_multiplier = 0.0f;
        public float required_player_range_multiplier = 0.0f;
    }

    public static class AttributeModifier {
        public String attribute;
        public Operation operation = Operation.MULTIPLY_BASE;
        public float randomness = 0.0f;
        public float value = 0.0f;
        private static Random rng = new Random();

        public AttributeModifier() {
        }

        public AttributeModifier(String attribute, float value) {
            this.attribute = attribute;
            this.value = value;
        }

        public float randomizedValue(int level) {
            float value = this.value * (float)level;
            return this.randomness > 0.0f ? rng.nextFloat(value - this.randomness, value + this.randomness) : value;
        }
    }

    public static class ItemModifier {
        public Filters item_matches = new Filters();
        public AttributeModifier[] attributes = new AttributeModifier[0];

        public static class Filters {
            public String item_id_regex = ".*";
            public String loot_table_regex = ".*";
            public String rarity_regex = ".*";
        }
    }

    public static class EntityModifier {
        public Filters entity_matches = new Filters();
        public AttributeModifier[] attributes = new AttributeModifier[0];
        public SpawnerModifier spawners = null;
        public float experience_multiplier = 0.0f;

        public static class Filters {
            public Attitude attitude = Attitude.ANY;
            public String entity_id_regex = ".*";

            public static enum Attitude {
                FRIENDLY,
                HOSTILE,
                ANY;

            }
        }
    }

    public static enum Operation {
        ADDITION,
        MULTIPLY_BASE;

    }

    public static class EntityMatcher {
        public String entity_type = null;
        public String loot_table = null;
        public DifficultyReference difficulty;
    }

    public static class Zone {
        public Filters zone_matches = new Filters();
        public DifficultyReference difficulty;

        public static class Filters {
            @Nullable
            public String biome = null;
            @Nullable
            public String structure = null;
        }
    }

    public static class Dimension {
        public Filters world_matches = new Filters();
        public DifficultyReference difficulty;
        public List<Zone> zones = List.of();
        public List<EntityMatcher> entities = List.of();

        public static class Filters {
            public String dimension_regex = ".*";
        }
    }

    public static class DifficultyReference {
        public String name;
        public int level = 0;
        public Integer entity_level;
        public Integer reward_level;

        public DifficultyReference() {
        }

        public DifficultyReference(String name, int level) {
            this.name = name;
            this.level = level;
        }
    }

    public static class Rewards {
        public String name;
        public List<ItemModifier> armor = List.of();
        public List<ItemModifier> weapons = List.of();
    }

    public static class DifficultyType {
        public String name;
        public String parent;
        @Nullable
        public String translation_code;
        public List<EntityModifier> entities = List.of();
        public Rewards rewards = new Rewards();

        public DifficultyType() {
        }

        public DifficultyType(String name) {
            this.name = name;
        }
    }

    public static class PerPlayerDifficulty {
        public boolean enabled = true;
        public Counting counting = Counting.EVERYWHERE;
        public EntityModifier[] entities = new EntityModifier[0];

        public static enum Counting {
            EVERYWHERE,
            DIMENSION;

        }
    }
}

