/*
 * Decompiled with CFR 0.152.
 */
package com.mythicmetalsdecorations.blocks.chest;

import com.mythicmetalsdecorations.blocks.chest.MythicChestBlockEntity;
import com.mythicmetalsdecorations.blocks.chest.MythicChests;
import com.mythicmetalsdecorations.screen.MythicChestScreenHandler;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_124;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2618;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4732;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class MythicChestBlock
extends class_2281
implements class_3737 {
    private final int size;
    private final String name;
    public static final class_2753 FACING;
    public static final class_2754<class_2745> CHEST_TYPE;
    public static final class_2746 WATERLOGGED;
    public static final class_4732.class_3923<MythicChestBlockEntity, MythicChest> CHEST_RETRIEVER;

    public MythicChestBlock(String name, class_4970.class_2251 settings, Supplier<class_2591<? extends class_2595>> supplier, int inventorySize) {
        super(settings, supplier);
        this.size = inventorySize;
        this.name = name;
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof MythicChestBlockEntity) {
            ((MythicChestBlockEntity)blockEntity).method_31671();
        }
    }

    public static class_2350 getFacing(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return state.method_11654(CHEST_TYPE) == class_2745.field_12574 ? direction.method_10170() : direction.method_10160();
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MythicChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? MythicChestBlock.method_31618(type, MythicChests.MYTHIC_CHEST_BLOCK_ENTITY_TYPE, MythicChestBlockEntity::clientTick) : null;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236) {
            world.method_39279(pos, (class_2248)this, 0);
            final MythicChest chest = (MythicChest)this.method_24167(state, world, pos, false).apply(CHEST_RETRIEVER);
            if (chest != null) {
                player.method_17355((class_3908)new ExtendedScreenHandlerFactory<Integer>(){

                    public Integer getScreenOpeningData(class_3222 player) {
                        return chest.inventory.method_5439();
                    }

                    public class_2561 method_5476() {
                        return chest.name;
                    }

                    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                        if (!chest.canOpen.test(player)) {
                            return null;
                        }
                        chest.lootGenerator.accept(player);
                        return new MythicChestScreenHandler(syncId, inv, chest.inventory);
                    }
                });
            }
        }
        return class_1269.field_5812;
    }

    public int getSize() {
        return this.size;
    }

    public class_4732.class_4734<? extends MythicChestBlockEntity> method_24167(class_2680 state, class_1937 world, class_2338 pos, boolean ignoreBlocked) {
        BiPredicate<class_1936, class_2338> fallbackTester = ignoreBlocked ? (w, p) -> false : class_2281::method_9756;
        return class_4732.method_24173(MythicChests.MYTHIC_CHEST_BLOCK_ENTITY_TYPE, class_2281::method_24169, MythicChestBlock::getFacing, (class_2753)FACING, (class_2680)state, (class_1936)world, (class_2338)pos, fallbackTester);
    }

    public String getChestName() {
        return this.name;
    }

    public static class_4732.class_3923<class_2595, Float2FloatFunction> getAnimationProgressRetriever(final class_2618 progress) {
        return new class_4732.class_3923<class_2595, Float2FloatFunction>(){

            public Float2FloatFunction getFromBoth(class_2595 chestBlockEntity, class_2595 chestBlockEntity2) {
                return tickDelta -> Math.max(chestBlockEntity.method_11274(tickDelta), chestBlockEntity2.method_11274(tickDelta));
            }

            public Float2FloatFunction getFrom(class_2595 chestBlockEntity) {
                return arg_0 -> ((class_2595)chestBlockEntity).method_11274(arg_0);
            }

            public Float2FloatFunction getFallback() {
                return arg_0 -> ((class_2618)progress).method_11274(arg_0);
            }
        };
    }

    public class_2561 getChestTooltip() {
        return class_2561.method_43469((String)"tooltip.mythicmetals_decorations.chest_size", (Object[])new Object[]{this.getSize()}).method_27692(class_124.field_1080);
    }

    static {
        CHEST_RETRIEVER = new class_4732.class_3923<MythicChestBlockEntity, MythicChest>(){

            public MythicChest getFromBoth(MythicChestBlockEntity first, MythicChestBlockEntity second) {
                class_2561 name = first.method_16914() ? first.method_5797() : (second.method_16914() ? second.method_5797() : class_2561.method_43469((String)"text.mythicmetals_decorations.large_chest", (Object[])new Object[]{second.method_11010().method_26204().method_9518()}));
                return new MythicChest((class_1263)new class_1258((class_1263)first, (class_1263)second), name, player -> first.method_17489((class_1657)player) && second.method_17489((class_1657)player), player -> {
                    first.method_54873((class_1657)player);
                    second.method_54873((class_1657)player);
                });
            }

            public MythicChest getFrom(MythicChestBlockEntity chest) {
                return new MythicChest((class_1263)chest, (class_2561)(chest.method_16914() ? chest.method_5797() : chest.method_11010().method_26204().method_9518()), arg_0 -> ((MythicChestBlockEntity)chest).method_17489(arg_0), arg_0 -> ((MythicChestBlockEntity)chest).method_54873(arg_0));
            }

            public MythicChest getFallback() {
                return null;
            }
        };
        FACING = class_2383.field_11177;
        CHEST_TYPE = class_2741.field_12506;
        WATERLOGGED = class_2741.field_12508;
    }

    public record MythicChest(class_1263 inventory, class_2561 name, Predicate<class_1657> canOpen, Consumer<class_1657> lootGenerator) {
    }
}

