/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.world.wind;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.config.ServerConfig;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.hangglider.world.wind.generator.OpenSimplexNoise;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class WindHelper {
    private static final OpenSimplexNoise NOISE_GENERATOR = new OpenSimplexNoise();

    public static void applyWind(class_1657 player, class_1799 itemStack) {
        ServerConfig config = (ServerConfig)HangGlider.CONFIG.get(ServerConfig.class);
        if (!config.wind.allowWind) {
            return;
        }
        double windGustSize = config.wind.gustSize;
        double windFrequency = config.wind.frequency;
        double windRainingMultiplier = config.wind.rainingMultiplier;
        double windSpeedMultiplier = config.wind.speedMultiplier;
        double windHeightMultiplier = config.wind.heightMultiplier;
        double windOverallPower = config.wind.overallPower;
        double noise = NOISE_GENERATOR.eval(player.method_23317() / windGustSize, player.method_23321() / windGustSize);
        double d = player.method_37908().method_8419() ? windRainingMultiplier * windFrequency : windFrequency;
        double velocity = Math.sqrt(Math.pow(player.method_18798().field_1352, 2.0) + Math.pow(player.method_18798().field_1350, 2.0));
        double speedStabilized = (noise *= d) * 1.0 / (velocity * windSpeedMultiplier + 1.0);
        double height = player.method_23318() < 256.0 ? player.method_23318() / 256.0 * windHeightMultiplier : windHeightMultiplier;
        double wind = speedStabilized * height;
        double additionalDamagePercentage = itemStack.method_7986() ? config.wind.durabilityMultiplier * ((double)itemStack.method_7919() / (double)itemStack.method_7936()) : 0.0;
        wind *= 1.0 + additionalDamagePercentage;
        wind *= windOverallPower;
        player.method_36456((float)((double)player.method_36454() + (wind *= PlayerGlidingHelper.getGliderMaterialSettings((class_1799)itemStack).windModifier)));
    }
}

