/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.client;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.client.handler.ElytraEquippedHandler;
import fuzs.hangglider.client.handler.FovModifierHandler;
import fuzs.hangglider.client.handler.GlidingCameraHandler;
import fuzs.hangglider.client.handler.GlidingCrouchHandler;
import fuzs.hangglider.client.init.ModClientRegistry;
import fuzs.hangglider.client.model.GliderModel;
import fuzs.hangglider.client.renderer.entity.layers.GliderLayer;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.hangglider.init.ModRegistry;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelPropertiesContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LivingEntityRenderLayersContext;
import fuzs.puzzleslib.api.client.event.v1.ClientTickEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ComputeFovModifierCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderGuiCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.ComputeCameraAnglesCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderHandEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderPlayerEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_591;
import net.minecraft.class_742;

public class HangGliderClient
implements ClientModConstructor {
    public static final class_2960 ITEM_PROPERTY_DEPLOYED = HangGlider.id("deployed");
    public static final class_2960 ITEM_PROPERTY_BROKEN = HangGlider.id("broken");

    public void onConstructMod() {
        HangGliderClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ComputeFovModifierCallback.EVENT.register(FovModifierHandler::onComputeFovModifier);
        ClientTickEvents.END.register(GlidingCameraHandler::onEndClientTick);
        ClientTickEvents.END.register(ElytraEquippedHandler.INSTANCE::onClientTick$End);
        RenderGuiCallback.EVENT.register(ElytraEquippedHandler.INSTANCE::onRenderGui);
        RenderPlayerEvents.BEFORE.register(GlidingCrouchHandler::onRenderPlayer$Pre);
        RenderPlayerEvents.AFTER.register(GlidingCrouchHandler::onRenderPlayer$Post);
        RenderHandEvents.MAIN_HAND.register(GlidingCameraHandler::onRenderHand);
        RenderHandEvents.OFF_HAND.register(GlidingCameraHandler::onRenderHand);
        ComputeCameraAnglesCallback.EVENT.register(GlidingCameraHandler::onComputeCameraRoll);
    }

    public void onClientSetup() {
        GliderLayer.registerGliderTexture((class_1792)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.comp_349(), HangGlider.id("textures/models/glider/reinforced_hang_glider.png"));
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(ModClientRegistry.GLIDER, GliderModel::createLayer);
    }

    public void onRegisterItemModelProperties(ItemModelPropertiesContext context) {
        context.registerItemProperty(ITEM_PROPERTY_DEPLOYED, (itemStack, clientLevel, livingEntity, i) -> {
            class_1657 player;
            return livingEntity instanceof class_1657 && PlayerGlidingHelper.getGliderInHand(player = (class_1657)livingEntity) == itemStack ? 1.0f : 0.0f;
        }, new class_1935[]{(class_1935)ModRegistry.HANG_GLIDER_ITEM.comp_349(), (class_1935)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.comp_349()});
        context.registerItemProperty(ITEM_PROPERTY_BROKEN, (itemStack, clientLevel, livingEntity, i) -> !PlayerGlidingHelper.isValidGlider(itemStack) ? 1.0f : 0.0f, new class_1935[]{(class_1935)ModRegistry.HANG_GLIDER_ITEM.comp_349(), (class_1935)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.comp_349()});
    }

    public void onRegisterLivingEntityRenderLayers(LivingEntityRenderLayersContext context) {
        context.registerRenderLayer(class_1299.field_6097, (renderLayerParent, context1) -> new GliderLayer((class_3883<class_742, class_591<class_742>>)renderLayerParent, context1.method_32170()));
    }
}

