/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AwningBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SuppAdditionalPlacement;
import net.mehvahdjukaar.supplementaries.common.items.CannonBoatItem;
import net.mehvahdjukaar.supplementaries.common.items.FlagItem;
import net.mehvahdjukaar.supplementaries.common.items.PresentItem;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.BuzzierBeesCompat;
import net.mehvahdjukaar.supplementaries.integration.CaveEnhancementsCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4174;
import net.minecraft.class_4970;
import net.minecraft.class_9307;
import net.minecraft.class_9334;

public class RegUtils {
    protected static final class_4970.class_4973 NEVER = (state, reader, pos) -> false;

    public static void initDynamicRegistry() {
        BlockSetAPI.addDynamicItemRegistration(RegUtils::registerSignPostItems, WoodType.class);
        BlockSetAPI.addDynamicItemRegistration(RegUtils::registerCannonBoatItems, WoodType.class);
    }

    public static void registerAdditionalPlacements() {
        AdditionalItemPlacementsAPI.registerSimplePlacement((class_1792)ModRegistry.PANCAKE_ITEM.get(), (class_2248)ModRegistry.PANCAKE.get());
        if (CommonConfigs.Tweaks.PLACEABLE_STICKS.get().booleanValue()) {
            AdditionalItemPlacementsAPI.registerPlacement((class_1792)class_1802.field_8600, (AdditionalItemPlacement)new SuppAdditionalPlacement(ModRegistry.STICK_BLOCK.get()));
        }
        if (CommonConfigs.Tweaks.PLACEABLE_RODS.get().booleanValue()) {
            AdditionalItemPlacementsAPI.registerPlacement((class_1792)class_1802.field_8894, (AdditionalItemPlacement)new SuppAdditionalPlacement(ModRegistry.BLAZE_ROD_BLOCK.get()));
        }
        if (CommonConfigs.Tweaks.PLACEABLE_GUNPOWDER.get().booleanValue()) {
            AdditionalItemPlacementsAPI.registerPlacement((class_1792)class_1802.field_8054, (AdditionalItemPlacement)new SuppAdditionalPlacement(ModRegistry.GUNPOWDER_BLOCK.get()));
        }
        if (CommonConfigs.Tools.LUNCH_BOX_PLACEABLE.get().booleanValue()) {
            AdditionalItemPlacementsAPI.registerPlacement((class_1792)ModRegistry.LUNCH_BASKET_ITEM.get(), (AdditionalItemPlacement)new AdditionalItemPlacement(ModRegistry.LUNCH_BASKET.get()){

                public class_1269 overrideUseOn(class_1838 pContext, class_4174 foodProperties) {
                    if (!pContext.method_8036().method_21823()) {
                        return class_1269.field_5811;
                    }
                    return super.overrideUseOn(pContext, foodProperties);
                }
            });
        }
    }

    public static <T extends class_1792> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((class_2960)Supplementaries.res(name), sup);
    }

    public static <T extends class_2591<E>, E extends class_2586> Supplier<T> regTile(String name, Supplier<T> sup) {
        return RegHelper.registerBlockEntityType((class_2960)Supplementaries.res(name), sup);
    }

    public static <T extends class_2248> RegSupplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((class_2960)Supplementaries.res(name), sup);
    }

    public static <T extends class_2248> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory) {
        return RegUtils.regWithItem(name, blockFactory, new class_1792.class_1793());
    }

    public static <T extends class_2248> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, class_1792.class_1793 properties) {
        RegSupplier<T> block = RegUtils.regBlock(name, blockFactory);
        RegUtils.regBlockItem(name, block, properties);
        return block;
    }

    public static RegSupplier<class_1747> regBlockItem(String name, Supplier<? extends class_2248> blockSup, class_1792.class_1793 properties) {
        return RegHelper.registerItem((class_2960)Supplementaries.res(name), () -> new class_1747((class_2248)blockSup.get(), properties));
    }

    public static Map<class_1767, Supplier<class_2248>> registerCandleHolders(class_2960 baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        class_4970.class_2251 prop = class_4970.class_2251.method_9637().method_9634().method_50012(class_3619.field_15971).method_22488().method_9618().method_9626(class_2498.field_17734);
        RegSupplier block = RegHelper.registerBlockWithItem((class_2960)baseName, () -> new CandleHolderBlock(null, prop));
        map.put(null, block);
        for (class_1767 color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName.method_12832() + "_" + color.method_7792();
            RegSupplier coloredBlock = RegHelper.registerBlockWithItem((class_2960)baseName.method_45136(name), () -> new CandleHolderBlock(color, prop));
            map.put(color, coloredBlock);
        }
        ModRegistry.ALL_CANDLE_HOLDERS.addAll(map.values());
        if (CompatHandler.BUZZIER_BEES) {
            BuzzierBeesCompat.registerCandle(baseName);
        }
        if (CompatHandler.CAVE_ENHANCEMENTS) {
            CaveEnhancementsCompat.registerCandle(baseName);
        }
        return map;
    }

    public static Map<class_1767, Supplier<class_2248>> registerFlags(String baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        for (class_1767 color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.method_7792();
            RegSupplier<class_2248> block = RegUtils.regBlock(name, () -> new FlagBlock(color, class_4970.class_2251.method_9637().method_50013().method_31710(color.method_7794()).method_9632(1.0f).method_22488().method_9626(class_2498.field_11547)));
            map.put(color, block);
            RegUtils.regItem(name, () -> new FlagItem((class_2248)block.get(), new class_1792.class_1793().method_57349(class_9334.field_49619, (Object)class_9307.field_49404).method_7889(16)));
        }
        return map;
    }

    public static Map<class_1767, Supplier<class_2248>> registerPresents(String baseName, BiFunction<class_1767, class_4970.class_2251, class_2248> presentFactory, BiFunction<class_2248, class_1792.class_1793, PresentItem> itemFactory) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        RegSupplier<class_2248> block = RegUtils.regBlock(baseName, () -> (class_2248)presentFactory.apply(null, class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_50012(class_3619.field_15971).method_9632(0.5f).method_9626((class_2498)ModSounds.PRESENT)));
        map.put(null, block);
        RegUtils.regItem(baseName, () -> (PresentItem)((Object)((Object)itemFactory.apply((class_2248)block.get(), new class_1792.class_1793()))));
        for (class_1767 color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.method_7792();
            RegSupplier<class_2248> bb = RegUtils.regBlock(name, () -> (class_2248)presentFactory.apply(color, class_4970.class_2251.method_9637().method_31710(color.method_7794()).method_50012(class_3619.field_15971).method_9632(0.5f).method_9626((class_2498)ModSounds.PRESENT)));
            map.put(color, bb);
            RegUtils.regItem(name, () -> (PresentItem)((Object)((Object)itemFactory.apply((class_2248)bb.get(), new class_1792.class_1793()))));
        }
        return map;
    }

    private static void registerSignPostItems(Registrator<class_1792> event, Collection<WoodType> woodTypes) {
        for (WoodType wood : woodTypes) {
            String name = wood.getVariantId("way_sign");
            SignPostItem item = new SignPostItem(ModRegistry.WAY_SIGN_WALL.get(), new class_1792.class_1793().method_7889(16), wood);
            wood.addChild("supplementaries:way_sign", (Object)item);
            event.register(Supplementaries.res(name), (Object)item);
            ModRegistry.WAY_SIGN_ITEMS.put(wood, item);
        }
    }

    private static void registerCannonBoatItems(Registrator<class_1792> event, Collection<WoodType> woodTypes) {
        for (WoodType wood : woodTypes) {
            if (wood.getItemOfThis("boat") == null) {
                return;
            }
            String name = wood.getVariantId("cannon_boat");
            CannonBoatItem item = new CannonBoatItem(new class_1792.class_1793().method_7889(1), wood);
            wood.addChild("supplementaries:cannon_boat", (Object)item);
            event.register(Supplementaries.res(name), (Object)item);
            ModRegistry.CANNON_BOAT_ITEMS.put(wood, item);
        }
    }

    public static Map<class_1767, Supplier<class_2248>> registerAwnings(String baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        RegSupplier<class_2248> defAwning = RegUtils.regBlock(baseName, () -> new AwningBlock(null, class_4970.class_2251.method_9637().method_50013().method_31710(class_3620.field_15986).method_9632(1.0f).method_51370().method_22488().method_9626(class_2498.field_11543)));
        map.put(null, defAwning);
        RegUtils.regItem(baseName, () -> new class_1747((class_2248)defAwning.get(), new class_1792.class_1793()));
        for (class_1767 color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.method_7792();
            RegSupplier<class_2248> block = RegUtils.regBlock(name, () -> new AwningBlock(color, class_4970.class_2251.method_9637().method_50013().method_31710(color.method_7794()).method_9632(1.0f).method_51370().method_22488().method_9626(class_2498.field_11543)));
            map.put(color, block);
            RegUtils.regItem(name, () -> new class_1747((class_2248)block.get(), new class_1792.class_1793()));
        }
        return map;
    }
}

