/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import io.netty.buffer.ByteBuf;
import net.mehvahdjukaar.moonlight.api.misc.StreamCodecMapRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public interface SlotReference {
    public static final Empty EMPTY = new Empty();
    public static final StreamCodecMapRegistry<SlotReference> REGISTRY = (StreamCodecMapRegistry)class_156.method_656(() -> {
        StreamCodecMapRegistry m = new StreamCodecMapRegistry("slot_reference");
        m.register("hand", Hand.CODEC);
        m.register("inv", Inv.CODEC);
        m.register("empty", Empty.CODEC);
        m.register("eq_slot", EqSlot.CODEC);
        m.register("quiver", Quiver.CODEC);
        return m;
    });
    public static final class_9139<class_2540, SlotReference> STREAM_CODEC = REGISTRY.getStreamCodec().method_56440(SlotReference::getCodec, c -> c);

    default public class_1792 getItem(class_1309 player) {
        return this.get(player).method_7909();
    }

    public class_1799 get(class_1309 var1);

    public static SlotReference hand(class_1268 pUsedHand) {
        return new Hand(pUsedHand);
    }

    public static SlotReference slot(class_1304 equipmentSlot) {
        return new EqSlot(equipmentSlot);
    }

    public static SlotReference inv(int invSlot) {
        return new Inv(invSlot);
    }

    @NotNull
    public static SlotReference quiver(IQuiverEntity e) {
        return Quiver.INSTANCE;
    }

    default public boolean isEmpty() {
        return this == EMPTY;
    }

    public class_9139<? super class_9129, ? extends SlotReference> getCodec();

    public record Hand(class_1268 hand) implements SlotReference
    {
        public static final class_9139<class_2540, Hand> CODEC = Utils.enumStreamCodec(class_1268.class).method_56432(Hand::new, Hand::hand);

        @Override
        public class_1799 get(class_1309 player) {
            return player.method_5998(this.hand);
        }

        public class_9139<class_2540, Hand> getCodec() {
            return CODEC;
        }
    }

    public record EqSlot(class_1304 slot) implements SlotReference
    {
        public static final class_9139<class_2540, EqSlot> CODEC = Utils.enumStreamCodec(class_1304.class).method_56432(EqSlot::new, EqSlot::slot);

        @Override
        public class_1799 get(class_1309 player) {
            return player.method_6118(this.slot);
        }

        public class_9139<class_2540, EqSlot> getCodec() {
            return CODEC;
        }
    }

    public record Inv(int invSlot) implements SlotReference
    {
        public static final class_9139<ByteBuf, Inv> CODEC = class_9135.field_49675.method_56432(Inv::new, Inv::invSlot);

        @Override
        public class_1799 get(class_1309 player) {
            return player.method_32318(this.invSlot).method_32327();
        }

        public class_9139<ByteBuf, Inv> getCodec() {
            return CODEC;
        }
    }

    public record Quiver() implements SlotReference
    {
        private static final Quiver INSTANCE = new Quiver();
        private static final class_9139<class_2540, Quiver> CODEC = class_9139.method_56431((Object)INSTANCE);

        @Override
        public class_1799 get(class_1309 player) {
            if (player instanceof class_1657) {
                class_1657 p = (class_1657)player;
                return QuiverItem.findActiveQuiver((class_1309)p);
            }
            return class_1799.field_8037;
        }

        public class_9139<class_2540, Quiver> getCodec() {
            return CODEC;
        }
    }

    public record Empty() implements SlotReference
    {
        public static final class_9139<ByteBuf, Empty> CODEC = class_9139.method_56431((Object)EMPTY);

        @Override
        public class_1799 get(class_1309 player) {
            return class_1799.field_8037;
        }

        public class_9139<ByteBuf, Empty> getCodec() {
            return CODEC;
        }
    }
}

