/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.TrappedPresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TrappedPresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.misc.IMovingBlockSource;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1676;
import net.minecraft.class_1684;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2601;
import net.minecraft.class_2669;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PearlMarker
extends class_1297 {
    private Pair<class_1684, class_239> event = null;
    private final List<class_1684> pearls = new ArrayList<class_1684>();
    private static final class_2940<class_2338> TELEPORT_POS = class_2945.method_12791(PearlMarker.class, (class_2941)class_2943.field_13324);

    public PearlMarker(class_1937 worldIn) {
        super(ModEntities.PEARL_MARKER.get(), worldIn);
        this.method_5875(true);
        this.method_5684(true);
    }

    public PearlMarker(class_1299<PearlMarker> type, class_1937 level) {
        super(type, level);
        this.method_5648(true);
        this.method_5875(true);
        this.method_5684(true);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(TELEPORT_POS, (Object)this.method_24515());
    }

    public boolean method_5643(class_1282 pSource, float pAmount) {
        return false;
    }

    protected void method_5749(class_2487 pCompound) {
    }

    protected void method_5652(class_2487 pCompound) {
    }

    public void method_5768() {
        this.method_31472();
    }

    public void method_5773() {
        class_2338 pos;
        class_2680 state;
        super.method_5670();
        this.pearls.removeIf(class_1297::method_31481);
        boolean dead = this.pearls.isEmpty();
        class_1937 level = this.method_37908();
        if (!dead && !PearlMarker.isValidBlock(state = level.method_8320(pos = this.method_24515()))) {
            class_2669 p;
            class_2669 piston = null;
            boolean didOffset = false;
            class_2586 tile = level.method_8321(pos);
            if (tile instanceof class_2669 && PearlMarker.isValidBlock((p = (class_2669)tile).method_11495())) {
                piston = p;
            } else {
                for (class_2350 d : class_2350.values()) {
                    class_2669 p2;
                    class_2338 offPos = pos.method_10093(d);
                    tile = level.method_8321(offPos);
                    if (!(tile instanceof class_2669) || !PearlMarker.isValidBlock((p2 = (class_2669)tile).method_11495())) continue;
                    piston = p2;
                    break;
                }
            }
            if (piston != null) {
                class_2350 dir = piston.method_11506();
                this.method_5784(class_1313.field_6310, new class_243((double)dir.method_10148() * 0.33, (double)dir.method_10164() * 0.33, (double)dir.method_10165() * 0.33));
                didOffset = true;
            }
            boolean bl = dead = !didOffset;
        }
        if (dead && !level.field_9236) {
            this.method_31472();
        }
    }

    @NotNull
    private static boolean isValidBlock(class_2680 p) {
        class_2248 b = p.method_26204();
        return b instanceof class_2315 || b instanceof CannonBlock || b instanceof TrappedPresentBlock;
    }

    private void removePearl(class_1684 pearl) {
        this.pearls.remove(pearl);
    }

    public void addPearl(class_1684 pearl) {
        this.pearls.add(pearl);
    }

    public void method_5859(double pX, double pY, double pZ) {
        if (this.event != null) {
            class_239 trace = (class_239)this.event.getSecond();
            class_1684 pearl = (class_1684)this.event.getFirst();
            if (trace instanceof class_3965) {
                class_3965 hitResult = (class_3965)trace;
                class_1937 level = this.method_37908();
                class_2338 fromPos = this.method_24515();
                class_2680 state = level.method_8320(fromPos);
                class_2586 blockEntity = level.method_8321(fromPos);
                if (PearlMarker.isValidBlockEntity(blockEntity)) {
                    class_2350 direction = hitResult.method_17780();
                    class_2338 toPos = hitResult.method_17777().method_10093(direction);
                    if (level.method_8320(toPos).method_45474()) {
                        class_2487 nbt = blockEntity.method_38244((class_7225.class_7874)level.method_30349());
                        blockEntity.method_11012();
                        class_2680 newState = PearlMarker.getLandingState(state, toPos, direction, level);
                        if (level.method_8501(fromPos, class_2246.field_10124.method_9564()) && level.method_8501(toPos, newState)) {
                            newState.method_26181(level, toPos, level.method_8320(toPos.method_10074()).method_26204(), toPos.method_10074(), true);
                            class_2586 dstEntity = level.method_8321(toPos);
                            if (PearlMarker.isValidBlockEntity(dstEntity)) {
                                dstEntity.method_58690(nbt, (class_7225.class_7874)level.method_30349());
                            }
                            class_2498 type = state.method_26231();
                            level.method_8396(null, toPos, type.method_10598(), class_3419.field_15245, (type.method_10597() + 1.0f) / 2.0f, type.method_10599() * 0.8f);
                        }
                    }
                    NetworkHelper.sendToAllClientPlayersTrackingEntity((class_1297)this, (class_8710)new ClientBoundParticlePacket(fromPos.method_46558(), ClientBoundParticlePacket.Kind.PEARL_TELEPORT, 0, toPos.method_46558()));
                    super.method_5859((double)toPos.method_10263() + 0.5, (double)toPos.method_10264() + 0.5 - (double)(this.method_17682() / 2.0f), (double)toPos.method_10260() + 0.5);
                }
            }
            this.removePearl(pearl);
            pearl.method_31472();
            this.event = null;
        } else {
            super.method_5859(pX, pY, pZ);
            Supplementaries.error();
        }
    }

    @NotNull
    private static class_2680 getLandingState(class_2680 state, class_2338 pos, class_2350 direction, class_1937 level) {
        if (state.method_28498((class_2769)class_2315.field_10918)) {
            state = (class_2680)state.method_11657((class_2769)class_2315.field_10918, (Comparable)direction);
        }
        return class_2248.method_9510((class_2680)state, (class_1936)level, (class_2338)pos);
    }

    private static boolean isValidBlockEntity(class_2586 blockEntity) {
        return blockEntity instanceof CannonBlockTile || blockEntity instanceof class_2601 || blockEntity instanceof TrappedPresentBlockTile;
    }

    public void method_5759(double x, double y, double z, float yRot, float xRot, int steps) {
        super.method_5759(x, y, z, yRot, xRot, steps);
        this.method_5814(x, y, z);
    }

    public static void onProjectileImpact(class_1676 projectile, class_239 hitResult) {
        class_1937 level = projectile.method_37908();
        if (!level.field_9236 && projectile instanceof class_1684) {
            class_1684 pearl = (class_1684)projectile;
            class_1297 class_12972 = projectile.method_24921();
            if (class_12972 instanceof PearlMarker) {
                PearlMarker markerEntity = (PearlMarker)class_12972;
                if (projectile.method_5738("dispensed")) {
                    markerEntity.event = Pair.of((Object)pearl, (Object)hitResult);
                }
            }
        }
    }

    public static class_1684 createPearlToDispenseAndPlaceMarker(class_2342 source, class_2374 pearlPos) {
        class_3218 level = source.comp_1967();
        class_2338 pos = source.comp_1968();
        class_1297 dispCart = ((IMovingBlockSource)source).supp$getEntity();
        return PearlMarker.createPearlToDispenseAndPlaceMarker(level, pos, dispCart, pearlPos);
    }

    public static class_1684 createPearlToDispenseAndPlaceMarker(class_3218 level, class_2338 pos, @Nullable class_1297 owner, class_2374 pearlPos) {
        class_1684 pearl = new class_1684(class_1299.field_6082, (class_1937)level);
        pearl.method_5814(pearlPos.method_10216(), pearlPos.method_10214(), pearlPos.method_10215());
        if (owner != null) {
            pearl.method_7432(owner);
        } else {
            PearlMarker marker;
            Optional entity = level.method_8390(PearlMarker.class, new class_238(pos), e -> e.method_24515().equals((Object)pos)).stream().findAny();
            if (entity.isEmpty()) {
                marker = new PearlMarker((class_1937)level);
                marker.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5 - (double)(marker.method_17682() / 2.0f), (double)pos.method_10260() + 0.5);
                level.method_8649((class_1297)marker);
            } else {
                marker = (PearlMarker)((Object)entity.get());
            }
            marker.addPearl(pearl);
            pearl.method_7432((class_1297)marker);
        }
        pearl.method_5780("dispensed");
        return pearl;
    }
}

