/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.SpriteCoordinateUnExpander;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookModelVisuals;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookType;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManager;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManagerClient;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.EnchantRedesignCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1091;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class BookPileBlockTile
extends ItemDisplayTile
implements IExtraModelDataProvider {
    public final boolean horizontal;
    private float enchantPower = 0.0f;
    public final BooksList booksVisuals = new BooksList();
    public static final ModelDataKey<BooksList> BOOKS_KEY = ModBlockProperties.BOOKS_KEY;
    private static final class_5819 rand = class_5819.method_43047();

    public BookPileBlockTile(class_2338 pos, class_2680 state) {
        this(pos, state, false);
    }

    public BookPileBlockTile(class_2338 pos, class_2680 state, boolean horizontal) {
        super(ModRegistry.BOOK_PILE_TILE.get(), pos, state, 4);
        this.horizontal = horizontal;
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(BOOKS_KEY, (Object)this.booksVisuals);
    }

    private void displayRandomColoredBooks(int i, class_7225.class_7874 provider) {
        for (int j = 0; j < i; ++j) {
            int r = rand.method_43048(10);
            class_1792 it = r < 2 ? class_1802.field_8598 : (r < 3 ? class_1802.field_8674 : class_1802.field_8529);
            this.booksVisuals.add(new BookVisualData(it.method_7854(), this.field_11867, j, this.horizontal, provider, null));
        }
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 registries) {
        super.method_11007(compound, registries);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.requestModelReload();
        }
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        class_2371 itemsCopy = null;
        if (componentInput.method_58694(class_9334.field_49622) == null) {
            itemsCopy = this.method_11282();
            this.method_11281(class_2371.method_10213((int)4, (Object)class_1799.field_8037));
        }
        super.method_57568(componentInput);
        this.method_11281(itemsCopy);
    }

    public void onItemRemoved(class_1657 player, class_1799 stack, int slot) {
        super.onItemRemoved(player, stack, slot);
        int actualBookCount = (int)this.method_11282().stream().filter(i -> !i.method_7960()).count();
        if (actualBookCount == 0) {
            this.field_11863.method_8650(this.field_11867, false);
        }
    }

    public void updateTileOnInventoryChanged() {
        super.updateTileOnInventoryChanged();
        int actualBookCount = (int)this.method_11282().stream().filter(i -> !i.method_7960()).count();
        if (actualBookCount != (Integer)this.method_11010().method_11654((class_2769)BookPileBlock.BOOKS)) {
            if (actualBookCount == 0) {
                return;
            }
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)BookPileBlock.BOOKS, (Comparable)Integer.valueOf(actualBookCount)), 2);
        }
        this.enchantPower = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            class_1792 item;
            BookType type;
            class_1799 itemStack = this.method_5438(i2);
            if (itemStack.method_7960() || (type = PlaceableBookManager.get(item = itemStack.method_7909(), this.horizontal, (class_7225.class_7874)this.field_11863.method_30349())) == null) continue;
            this.enchantPower += type.enchantPower();
        }
    }

    private void consolidateBookPile() {
        boolean prevEmpty = false;
        for (int i = 0; i < 4; ++i) {
            class_1799 it = this.method_5438(i);
            if (it.method_7960()) {
                prevEmpty = true;
                continue;
            }
            if (!prevEmpty) continue;
            this.method_11282().set(i - 1, (Object)it);
            this.method_11282().set(i, (Object)class_1799.field_8037);
        }
    }

    public void updateClientVisualsOnLoad() {
        class_1799 stack;
        this.booksVisuals.clear();
        for (int index = 0; index < 4 && !(stack = this.method_5438(index)).method_7960(); ++index) {
            BookModelVisuals last = index == 0 ? null : this.booksVisuals.get((int)(index - 1)).type;
            this.booksVisuals.add(index, new BookVisualData(stack, this.field_11867, index, this.horizontal, (class_7225.class_7874)this.field_11863.method_30349(), last));
        }
        if (this.booksVisuals.isEmpty()) {
            this.displayRandomColoredBooks((Integer)this.method_11010().method_11654((class_2769)BookPileBlock.BOOKS), (class_7225.class_7874)this.field_11863.method_30349());
        }
    }

    public float getEnchantPower() {
        return this.enchantPower;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.supplementaries.book_pile");
    }

    public boolean method_49104(class_1263 container, int i, class_1799 itemStack) {
        return false;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return false;
    }

    public boolean method_17489(class_1657 player) {
        return false;
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return null;
    }

    public record BooksList(List<BookVisualData> books) {
        public BooksList() {
            this(new ArrayList<BookVisualData>());
        }

        private void add(BookVisualData visualBook) {
            this.books.add(visualBook);
        }

        private void add(int i, BookVisualData visualBook) {
            this.books.add(i, visualBook);
        }

        private void clear() {
            this.books.clear();
        }

        public boolean isEmpty() {
            return this.books.isEmpty();
        }

        public BookVisualData get(int i) {
            return this.books.get(i);
        }

        public int size() {
            return this.books.size();
        }
    }

    public static class BookVisualData {
        private final float yAngle;
        private final BookModelVisuals type;
        private final class_1799 stack;

        public BookVisualData(class_1799 bookStack, class_2338 pos, int index, boolean isHorizontal, class_7225.class_7874 provider, @Nullable BookModelVisuals lastColor) {
            this.stack = bookStack;
            Random rand = new Random(pos.method_10087(2).method_10063());
            for (int j = 0; j < index; ++j) {
                rand.nextInt();
            }
            this.yAngle = (float)((double)rand.nextInt(32) * Math.PI / 16.0);
            List<BookModelVisuals> possibleTypes = PlaceableBookManagerClient.getValidModelsForBookItem(provider, this.stack, isHorizontal);
            List<Object> looksGood = new ArrayList();
            for (BookModelVisuals type : possibleTypes) {
                if (lastColor != null && !type.looksGoodNextTo(lastColor) || type == lastColor) continue;
                looksGood.add(type);
            }
            if (looksGood.isEmpty()) {
                looksGood = possibleTypes;
            }
            this.type = (BookModelVisuals)looksGood.get(rand.nextInt(looksGood.size()));
        }

        public class_4588 getBuilder(class_4597 buffer) {
            if (this.type.hasGlint() && ClientConfigs.Tweaks.BOOK_GLINT.get().booleanValue()) {
                class_4588 foilBuilder = null;
                if (CompatHandler.ENCHANTEDBOOKREDESIGN) {
                    foilBuilder = EnchantRedesignCompat.getBookColoredFoil(this.stack, buffer);
                }
                if (foilBuilder == null) {
                    foilBuilder = new SpriteCoordinateUnExpander(buffer.getBuffer(class_1921.method_23591()), ModMaterials.BOOK_GLINT_MATERIAL.method_24148());
                }
                return foilBuilder;
            }
            return null;
        }

        public float getAngle() {
            return this.yAngle;
        }

        public class_1091 getModel() {
            return this.type.model();
        }
    }
}

