/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.supplementaries.client.TextUtils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestMapDataPacket;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.class_1087;
import net.minecraft.class_1762;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_330;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_8710;
import net.minecraft.class_918;
import net.minecraft.class_9209;
import net.minecraft.class_9262;
import net.minecraft.class_9334;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class NoticeBoardBlockTileRenderer
implements class_827<NoticeBoardBlockTile> {
    private final class_918 itemRenderer;
    private final class_330 mapRenderer;
    private final class_327 font;
    private final class_4184 camera;
    private static final float PAPER_X_MARGIN = 0.1875f;
    private static final float PAPER_Y_MARGIN = 0.125f;

    public NoticeBoardBlockTileRenderer(class_5614.class_5615 context) {
        class_310 minecraft = class_310.method_1551();
        this.itemRenderer = minecraft.method_1480();
        this.mapRenderer = minecraft.field_1773.method_3194();
        this.font = context.method_32143();
        this.camera = minecraft.field_1773.method_19418();
    }

    public int getFrontLight(class_1937 world, class_2338 pos, class_2350 dir) {
        return class_761.method_23794((class_1920)world, (class_2338)pos.method_10093(dir));
    }

    public void render(NoticeBoardBlockTile tile, float partialTicks, class_4587 poseStack, class_4597 buffer, int combinedLightIn, int overlay) {
        if (!tile.shouldSkipTileRenderer()) {
            class_2338 pos;
            class_1937 level = tile.method_10997();
            if (level == null) {
                return;
            }
            class_1799 stack = tile.getDisplayedItem();
            if (stack.method_7960()) {
                return;
            }
            class_2350 dir = tile.getDirection();
            float yaw = -dir.method_10144();
            class_243 cameraPos = this.camera.method_19326();
            if (LOD.isOutOfFocus((class_243)cameraPos, (class_2338)(pos = tile.method_11016()), (float)yaw, (float)0.0f, (class_2350)dir, (float)0.0f)) {
                return;
            }
            int frontLight = this.getFrontLight(level, pos, dir);
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22907(RotHlpr.rot((int)((int)yaw)));
            poseStack.method_22904(0.0, 0.0, 0.5);
            NoticeBoardBlockTileRenderer.renderNoticeBoardContent(this.mapRenderer, this.font, this.itemRenderer, tile, poseStack, buffer, frontLight, overlay, stack, dir, new LOD(cameraPos, pos));
            poseStack.method_22909();
        }
    }

    public static void renderNoticeBoardContent(class_330 mapRenderer, class_327 font, class_918 itemRenderer, NoticeBoardBlockTile tile, class_4587 poseStack, class_4597 buffer, int frontLight, int overlay, class_1799 stack, class_2350 dir, LOD lod) {
        if (tile.isGlowing()) {
            frontLight = 0xF000F0;
        }
        if (stack.method_7909() instanceof class_1762) {
            class_9209 mapId = (class_9209)stack.method_57824(class_9334.field_49646);
            class_22 mapData = class_1806.method_7997((class_9209)mapId, (class_1937)tile.method_10997());
            if (mapData != null) {
                poseStack.method_22903();
                poseStack.method_22904(0.0, 0.0, 0.008);
                poseStack.method_22905(0.0078125f, -0.0078125f, -0.0078125f);
                poseStack.method_22904(-64.0, -64.0, 0.0);
                mapRenderer.method_1773(poseStack, buffer, mapId, mapData, true, frontLight);
                poseStack.method_22909();
            } else {
                class_746 player = class_310.method_1551().field_1724;
                NetworkHelper.sendToServer((class_8710)new ServerBoundRequestMapDataPacket(tile.method_11016(), player.method_5667()));
            }
            return;
        }
        class_9262<String> text = tile.getText();
        if (text != null) {
            String page = (String)text.method_57140(class_310.method_1551().method_33883());
            if (!lod.isNearMed()) {
                return;
            }
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.5, 0.008);
            if (MiscUtils.FESTIVITY.isAprilsFool()) {
                float d0 = ColorUtils.getShading((Vector3f)dir.method_23955());
                TextUtils.renderBeeMovie(poseStack, buffer, frontLight, font, d0);
                poseStack.method_22909();
                return;
            }
            String bookName = tile.method_5438(0).method_7964().getString().toLowerCase(Locale.ROOT);
            if (bookName.equals("credits")) {
                float d0 = ColorUtils.getShading((Vector3f)dir.method_23955());
                TextUtils.renderCredits(poseStack, buffer, frontLight, font, d0);
                poseStack.method_22909();
                return;
            }
            TextUtil.RenderProperties textProperties = tile.getTextHolder().computeRenderProperties(frontLight, dir.method_23955(), () -> ((LOD)lod).isVeryNear());
            if (tile.needsVisualUpdate()) {
                NoticeBoardBlockTileRenderer.updateAndCacheLines(font, tile, page, textProperties);
            }
            List<class_5481> rendererLines = tile.getCachedLines();
            float scale = tile.getFontScale();
            poseStack.method_22905(scale, -scale, scale);
            int numberOfLines = rendererLines.size();
            boolean centered = ClientConfigs.Blocks.NOTICE_BOARD_CENTERED_TEXT.get();
            boolean missingno = bookName.equals("missingno");
            for (int lin = 0; lin < numberOfLines; ++lin) {
                class_5481 str = rendererLines.get(lin);
                float dx = centered ? (float)(-font.method_30880(str)) / 2.0f + 0.5f : -0.3125f / scale;
                float dy = (1.0f / scale - (float)(8 * numberOfLines)) / 2.0f + 0.5f;
                Matrix4f pose = poseStack.method_23760().method_23761();
                if (missingno) {
                    font.method_27521("\u00a7ka", dx, dy + (float)(8 * lin), textProperties.textColor(), false, pose, buffer, class_327.class_6415.field_33993, 0, frontLight);
                    continue;
                }
                if (textProperties.outline()) {
                    font.method_37296(str, dx, dy + (float)(8 * lin), textProperties.textColor(), textProperties.darkenedColor(), pose, buffer, textProperties.light());
                    continue;
                }
                font.method_22942(str, dx, dy + (float)(8 * lin), textProperties.darkenedColor(), false, pose, buffer, class_327.class_6415.field_33993, 0, textProperties.light());
            }
            poseStack.method_22909();
            return;
        }
        class_4730 pattern = tile.getCachedPattern();
        if (pattern != null) {
            class_4588 builder = pattern.method_24145(buffer, class_1921::method_23588);
            int i = tile.getDyeColor().method_16357();
            float scale = 0.5f;
            int b = (int)(scale * (float)class_5253.class_5254.method_27767((int)i));
            int g = (int)(scale * (float)class_5253.class_5254.method_27766((int)i));
            int r = (int)(scale * (float)class_5253.class_5254.method_27765((int)i));
            int lu = VertexUtil.lightU((int)frontLight);
            int lv = VertexUtil.lightV((int)frontLight);
            poseStack.method_46416(0.0f, 0.0f, 0.008f);
            VertexUtil.addQuad((class_4588)builder, (class_4587)poseStack, (float)-0.4375f, (float)-0.4375f, (float)0.4375f, (float)0.4375f, (float)0.15625f, (float)0.0625f, (float)0.59375f, (float)0.9375f, (int)r, (int)g, (int)b, (int)255, (int)lu, (int)lv);
        } else if (!tile.isNormalItem()) {
            class_1087 model = itemRenderer.method_4019(stack, tile.method_10997(), null, 0);
            poseStack.method_22904(0.0, 0.0, 0.015675);
            poseStack.method_22905(-0.5f, 0.5f, -0.5f);
            itemRenderer.method_23179(stack, class_811.field_4319, true, poseStack, buffer, frontLight, overlay, model);
        }
    }

    private static void updateAndCacheLines(class_327 font, NoticeBoardBlockTile tile, String page, TextUtil.RenderProperties textProperties) {
        float paperWidth = 0.625f;
        float paperHeight = 0.75f;
        class_5348 text = TextUtil.parseText((String)page);
        if (text instanceof class_5250) {
            class_5250 mc = (class_5250)text;
            text = mc.method_10862(textProperties.style());
        } else {
            text = class_2561.method_43470((String)page).method_10862(textProperties.style());
        }
        Pair p = TextUtil.fitLinesToBox((class_327)font, (class_5348)text, (float)paperWidth, (float)paperHeight);
        tile.setFontScale(((Float)p.getSecond()).floatValue());
        tile.setCachedPageLines((List)p.getFirst());
    }
}

