/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.blay09.mods.waystones.core.InMemoryPlayerWaystoneData;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;

public class KnownWaystonesMessage
implements class_8710 {
    public static final class_8710.class_9154<KnownWaystonesMessage> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"waystones", (String)"known_waystones"));
    private final class_2960 type;
    private final Collection<Waystone> waystones;

    public KnownWaystonesMessage(class_2960 type, Collection<Waystone> waystones) {
        this.type = type;
        this.waystones = waystones;
    }

    public static void encode(class_9129 buf, KnownWaystonesMessage message) {
        buf.method_10812(message.type);
        buf.method_52998(message.waystones.size());
        for (Waystone waystone : message.waystones) {
            WaystoneImpl.write(buf, waystone);
        }
    }

    public static KnownWaystonesMessage decode(class_9129 buf) {
        class_2960 type = buf.method_10810();
        int waystoneCount = buf.readShort();
        ArrayList<Waystone> waystones = new ArrayList<Waystone>();
        for (int i = 0; i < waystoneCount; ++i) {
            waystones.add(WaystoneImpl.read(buf));
        }
        return new KnownWaystonesMessage(type, waystones);
    }

    public static void handle(class_1657 player, KnownWaystonesMessage message) {
        List<Waystone> waystones = message.waystones.stream().toList();
        if (message.type.equals((Object)WaystoneTypes.WAYSTONE)) {
            InMemoryPlayerWaystoneData playerWaystoneData = (InMemoryPlayerWaystoneData)PlayerWaystoneManager.getPlayerWaystoneData(BalmEnvironment.CLIENT);
            playerWaystoneData.setWaystones(message.waystones);
        }
        Balm.getEvents().fireEvent((Object)new WaystonesListReceivedEvent(message.type, waystones));
        for (Waystone waystone : message.waystones) {
            WaystoneManagerImpl.get(player.method_5682()).updateWaystone(waystone);
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

