/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.TeleportDestination;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.error.WaystoneTeleportError;
import net.blay09.mods.waystones.api.event.WaystoneTeleportEvent;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WaystonesConfigData;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.network.message.TeleportEffectMessage;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2748;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class WaystoneTeleportManager {
    public static Collection<? extends class_1297> findPets(class_1297 entity) {
        return entity.method_37908().method_8390(class_1321.class, new class_238(entity.method_24515()).method_1014(10.0), pet -> entity.method_5667().equals(pet.method_6139()) && !pet.method_24345() && !pet.method_60953() && !WaystonePermissionManager.isEntityDeniedTeleports((class_1297)pet));
    }

    public static List<class_1308> findLeashedAnimals(class_1297 player) {
        return player.method_37908().method_8390(class_1308.class, new class_238(player.method_24515()).method_1014(10.0), e -> player.equals((Object)e.method_60952()));
    }

    public static Either<List<class_1297>, WaystoneTeleportError> doTeleport(WaystoneTeleportContext context) {
        MinecraftServer server = context.getEntity().method_5682();
        if (server == null) {
            return Either.right((Object)new WaystoneTeleportError.NotOnServer());
        }
        return WaystoneTeleportManager.resolveDestination(server, context.getTargetWaystone()).flatMap(it -> WaystoneTeleportManager.doTeleport(context, it));
    }

    public static Either<List<class_1297>, WaystoneTeleportError> doTeleport(WaystoneTeleportContext context, TeleportDestination destination) {
        class_3218 sourceLevel = (class_3218)context.getEntity().method_37908();
        List<class_1297> teleportedEntities = WaystoneTeleportManager.teleportEntityAndAttached(context.getEntity(), context, destination);
        context.getAdditionalEntities().forEach(additionalEntity -> teleportedEntities.addAll(WaystoneTeleportManager.teleportEntityAndAttached(additionalEntity, context, destination)));
        class_2338 sourcePos = context.getEntity().method_24515();
        class_3218 targetLevel = (class_3218)destination.level();
        class_2338 targetPos = class_2338.method_49638((class_2374)destination.location());
        class_2586 targetTileEntity = targetLevel.method_8321(targetPos);
        if (targetTileEntity instanceof WarpPlateBlockEntity) {
            WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)targetTileEntity;
            teleportedEntities.forEach(warpPlate::markEntityForCooldown);
        }
        if (context.playsSound()) {
            sourceLevel.method_45445(context.getEntity(), sourcePos, class_3417.field_14716, class_3419.field_15248, 0.01f, 1.0f);
            targetLevel.method_8396(null, targetPos, class_3417.field_14716, class_3419.field_15248, 0.05f, 1.0f);
        }
        if (context.playsEffect()) {
            teleportedEntities.forEach(additionalEntity -> Balm.getNetworking().sendToTracking(sourceLevel, sourcePos, (class_8710)new TeleportEffectMessage(sourcePos)));
            Balm.getNetworking().sendToTracking(targetLevel, targetPos, (class_8710)new TeleportEffectMessage(targetPos));
        }
        if (targetTileEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)targetTileEntity;
            teleportedEntities.forEach(waystoneBlockEntity::applyModifierEffects);
        }
        return Either.left(teleportedEntities);
    }

    private static List<class_1297> teleportEntityAndAttached(class_1297 entity, WaystoneTeleportContext context, TeleportDestination destination) {
        ArrayList<class_1297> teleportedEntities = new ArrayList<class_1297>();
        class_3218 targetLevel = (class_3218)destination.level();
        class_243 targetLocation = destination.location();
        class_2350 targetDirection = destination.direction();
        class_1297 mount = entity.method_5854();
        class_1297 teleportedMount = null;
        if (mount != null) {
            teleportedMount = WaystoneTeleportManager.teleportEntity(mount, targetLevel, targetLocation, targetDirection);
            teleportedEntities.add(teleportedMount);
        }
        List<class_1308> leashedEntities = context.getLeashedEntities();
        ArrayList teleportedLeashedEntities = new ArrayList();
        leashedEntities.forEach(leashedEntity -> {
            class_1297 teleportedLeashedEntity = WaystoneTeleportManager.teleportEntity((class_1297)leashedEntity, targetLevel, targetLocation, targetDirection);
            teleportedEntities.add(teleportedLeashedEntity);
            teleportedLeashedEntities.add(teleportedLeashedEntity);
        });
        class_1297 teleportedEntity = WaystoneTeleportManager.teleportEntity(entity, targetLevel, targetLocation, targetDirection);
        teleportedEntities.add(teleportedEntity);
        teleportedLeashedEntities.forEach(teleportedLeashedEntity -> {
            if (teleportedLeashedEntity instanceof class_1308) {
                class_1308 teleportedLeashedMob = (class_1308)teleportedLeashedEntity;
                teleportedLeashedMob.method_60964(teleportedEntity, true);
            }
        });
        if (teleportedMount != null) {
            // empty if block
        }
        return teleportedEntities;
    }

    private static class_1297 teleportEntity(class_1297 entity, class_3218 targetWorld, class_243 targetPos3d, class_2350 direction) {
        float yaw = direction.method_10144();
        double x = targetPos3d.field_1352;
        double y = targetPos3d.field_1351;
        double z = targetPos3d.field_1350;
        if (entity instanceof class_3222) {
            class_1923 chunkPos = new class_1923(class_2338.method_49637((double)x, (double)y, (double)z));
            targetWorld.method_14178().method_17297(class_3230.field_19347, chunkPos, 1, (Object)entity.method_5628());
            entity.method_5848();
            if (((class_3222)entity).method_6113()) {
                ((class_3222)entity).method_7358(true, true);
            }
            if (targetWorld == entity.method_37908()) {
                ((class_3222)entity).field_13987.method_14360(x, y, z, yaw, entity.method_36455(), Collections.emptySet());
            } else {
                ((class_3222)entity).method_14251(targetWorld, x, y, z, yaw, entity.method_36455());
            }
            entity.method_5847(yaw);
        } else {
            float pitch = class_3532.method_15363((float)entity.method_36455(), (float)-90.0f, (float)90.0f);
            if (targetWorld == entity.method_37908()) {
                entity.method_5808(x, y, z, yaw, pitch);
                entity.method_5847(yaw);
            } else {
                entity.method_18375();
                class_1297 oldEntity = entity;
                entity = entity.method_5864().method_5883((class_1937)targetWorld);
                if (entity == null) {
                    return oldEntity;
                }
                entity.method_5878(oldEntity);
                entity.method_5808(x, y, z, yaw, pitch);
                entity.method_5847(yaw);
                oldEntity.method_31745(class_1297.class_5529.field_27002);
                targetWorld.method_18769(entity);
            }
        }
        if (!(entity instanceof class_1309) || !((class_1309)entity).method_6128()) {
            entity.method_18799(entity.method_18798().method_18805(1.0, 0.0, 1.0));
            entity.method_24830(true);
        }
        if (entity instanceof class_1314) {
            ((class_1314)entity).method_5942().method_6340();
        }
        WaystoneTeleportManager.sendHackySyncPacketsAfterTeleport(entity);
        return entity;
    }

    private static Either<TeleportDestination, WaystoneTeleportError> resolveDestination(MinecraftServer server, Waystone waystone) {
        class_2960 waystoneType;
        class_3218 level = server.method_3847(waystone.getDimension());
        if (level == null) {
            return Either.right((Object)new WaystoneTeleportError.InvalidDimension(waystone.getDimension()));
        }
        class_2338 pos = waystone.getPos();
        class_2680 state = level.method_8320(pos);
        class_2350 direction = state.method_28498((class_2769)WaystoneBlock.FACING) ? (class_2350)state.method_11654((class_2769)WaystoneBlock.FACING) : class_2350.field_11043;
        ArrayList directionCandidates = Lists.newArrayList((Object[])new class_2350[]{direction, class_2350.field_11034, class_2350.field_11039, class_2350.field_11035, class_2350.field_11043});
        for (class_2350 candidate : directionCandidates) {
            class_2338 offsetPos = pos.method_10093(candidate);
            class_2338 offsetPosUp = offsetPos.method_10084();
            if (level.method_8320(offsetPos).method_26228((class_1922)level, offsetPos) || level.method_8320(offsetPosUp).method_26228((class_1922)level, offsetPosUp)) continue;
            direction = candidate;
            break;
        }
        boolean shouldOffsetFacing = !(waystoneType = waystone.getWaystoneType()).equals((Object)WaystoneTypes.WARP_PLATE);
        class_2338 targetPos = shouldOffsetFacing ? pos.method_10093(direction) : pos;
        class_243 location = new class_243((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5);
        return Either.left((Object)new TeleportDestination((class_1937)level, location, direction));
    }

    private static void sendHackySyncPacketsAfterTeleport(class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            player.field_13987.method_14364((class_2596)new class_2748(player.field_7510, player.field_7495, player.field_7520));
        }
    }

    public static Either<List<class_1297>, WaystoneTeleportError> tryTeleport(WaystoneTeleportContext context) {
        class_1657 player;
        WaystoneTeleportEvent.Pre event = new WaystoneTeleportEvent.Pre(context);
        Balm.getEvents().fireEvent((Object)event);
        if (event.isCanceled()) {
            return Either.right((Object)new WaystoneTeleportError.CancelledByEvent());
        }
        class_1297 entity = context.getEntity();
        if (!context.getLeashedEntities().isEmpty()) {
            if (WaystonesConfig.getActive().teleports.transportLeashed == WaystonesConfigData.TransportMobs.DISABLED) {
                return Either.right((Object)new WaystoneTeleportError.LeashedWarpDenied());
            }
            for (class_1308 leashedEntity : context.getLeashedEntities()) {
                if (!WaystonePermissionManager.isEntityDeniedTeleports((class_1297)leashedEntity)) continue;
                return Either.right((Object)new WaystoneTeleportError.SpecificLeashedWarpDenied((class_1297)leashedEntity));
            }
            if (context.isDimensionalTeleport() && WaystonesConfig.getActive().teleports.transportLeashed == WaystonesConfigData.TransportMobs.SAME_DIMENSION) {
                return Either.right((Object)new WaystoneTeleportError.LeashedDimensionalWarpDenied());
            }
        }
        if (entity instanceof class_1657) {
            player = (class_1657)entity;
            if (!context.getRequirements().canAfford(player) && !player.method_31549().field_7477) {
                return Either.right((Object)new WaystoneTeleportError.NotEnoughXp());
            }
        }
        if (entity instanceof class_1657) {
            player = (class_1657)entity;
            context.getRequirements().consume(player);
        }
        return WaystoneTeleportManager.doTeleport(context).ifLeft(teleportedEntities -> Balm.getEvents().fireEvent((Object)new WaystoneTeleportEvent.Post(context, (List<class_1297>)teleportedEntities)));
    }

    public static Collection<class_1297> findPassengers(class_1297 entity) {
        List passengers = entity.method_5685();
        ArrayList<class_1297> result = new ArrayList<class_1297>(passengers);
        class_1297 vehicle = entity.method_5854();
        if (vehicle != null) {
            result.addAll(vehicle.method_5685());
        }
        result.remove(entity);
        return result;
    }
}

